/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.intset;

import java.util.HashSet;
import java.util.Iterator;
import org.mindswap.pellet.utils.intset.AbstractIntSet;
import org.mindswap.pellet.utils.intset.IntIterator;
import org.mindswap.pellet.utils.intset.IntSet;

public class HashIntSet
extends AbstractIntSet
implements IntSet {
    private HashSet<Integer> ints = new HashSet();

    @Override
    public void add(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ints.add(n);
        this.added(n, n);
    }

    @Override
    public void addAll(IntSet intSet) {
        if (intSet instanceof HashIntSet) {
            this.ints.addAll(((HashIntSet)intSet).ints);
            if (!intSet.isEmpty()) {
                this.added(intSet.min(), intSet.max());
            }
        } else {
            super.addAll(intSet);
        }
    }

    @Override
    public boolean contains(int n) {
        return this.ints.contains(n);
    }

    @Override
    public IntSet copy() {
        HashIntSet hashIntSet = new HashIntSet();
        hashIntSet.addAll(this);
        return hashIntSet;
    }

    @Override
    public boolean isEmpty() {
        return this.ints.isEmpty();
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private Iterator<Integer> base;
            {
                this.base = HashIntSet.this.ints.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public int next() {
                return this.base.next();
            }
        };
    }

    @Override
    public void remove(int n) {
        this.ints.remove(n);
        this.removed(n, n);
    }

    @Override
    public int size() {
        return this.ints.size();
    }
}

