/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class UnaryTBox {
    public static final Logger log = Logger.getLogger(UnaryTBox.class.getName());
    private Map<ATermAppl, List<Unfolding>> unfoldings = CollectionUtils.makeIdentityMap();

    public void add(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        List<Unfolding> list = this.unfoldings.get(aTermAppl);
        if (list == null) {
            list = CollectionUtils.makeList();
            this.unfoldings.put(aTermAppl, list);
        }
        aTermAppl2 = ATermUtils.normalize(aTermAppl2);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Add sub: " + ATermUtils.toString(aTermAppl) + " < " + ATermUtils.toString(aTermAppl2));
        }
        list.add(Unfolding.create(aTermAppl2, set));
    }

    public boolean remove(ATermAppl aTermAppl) {
        return false;
    }

    public Iterator<Unfolding> unfold(ATermAppl aTermAppl) {
        List<Unfolding> list = this.unfoldings.get(aTermAppl);
        return list == null ? IteratorUtils.emptyIterator() : list.iterator();
    }

    public void print(Appendable appendable) throws IOException {
        for (Map.Entry<ATermAppl, List<Unfolding>> entry : this.unfoldings.entrySet()) {
            appendable.append(ATermUtils.toString(entry.getKey()));
            appendable.append(" < ");
            appendable.append(entry.getValue().toString());
            appendable.append("\n");
        }
    }
}

