/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy.printer;

import aterm.ATermAppl;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.TaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;

public class RDFXMLTaxonomyPrinter
implements TaxonomyPrinter<ATermAppl> {
    static final String OWL_EQUIVALENT_CLASS = "owl:equivalentClass";
    static final String RDFS_SUB_CLASS_OF = "rdfs:subClassOf";
    static final String RDF_TYPE = "rdf:type";
    protected boolean onlyDirectSubclass = true;
    private Taxonomy<ATermAppl> taxonomy;
    private PrintWriter out;
    private Set<ATermAppl> visited;

    @Override
    public void print(Taxonomy<ATermAppl> taxonomy) {
        this.print(taxonomy, new PrintWriter(System.out));
    }

    @Override
    public void print(Taxonomy<ATermAppl> taxonomy, PrintWriter printWriter) {
        this.taxonomy = taxonomy;
        this.out = printWriter;
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println();
        printWriter.println("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" ");
        printWriter.println("         xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" ");
        printWriter.println("         xmlns:owl=\"http://www.w3.org/2002/07/owl#\"> ");
        printWriter.println();
        this.printTree();
        printWriter.println();
        printWriter.println("</rdf:RDF>");
        printWriter.flush();
    }

    protected void printTree() {
        this.visited = new HashSet<ATermAppl>();
        this.visited.add(ATermUtils.BOTTOM);
        this.printTree(ATermUtils.TOP);
        this.printTree(ATermUtils.BOTTOM);
        for (ATermAppl aTermAppl : this.taxonomy.getClasses()) {
            this.printTree(aTermAppl);
        }
    }

    protected void printTree(ATermAppl aTermAppl) {
        Set set;
        Object object;
        if (this.visited.contains(aTermAppl)) {
            return;
        }
        Set<ATermAppl> set2 = ATermUtils.primitiveOrBottom(this.taxonomy.getEquivalents(aTermAppl));
        this.visited.add(aTermAppl);
        this.visited.addAll(set2);
        this.printConceptDefinition(aTermAppl, false);
        for (ATermAppl object22 : set2) {
            this.printTriple(OWL_EQUIVALENT_CLASS, object22);
        }
        if (!aTermAppl.equals(ATermUtils.BOTTOM)) {
            object = this.taxonomy.getSupers(aTermAppl, this.onlyDirectSubclass);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                set = (Set)iterator.next();
                ATermAppl aTermAppl2 = ATermUtils.primitiveOrBottom(set).iterator().next();
                this.printTriple(RDFS_SUB_CLASS_OF, aTermAppl2);
            }
        }
        this.out.println("</owl:Class>");
        for (ATermAppl aTermAppl3 : set2) {
            this.out.println();
            this.printConceptDefinition(aTermAppl3, true);
        }
        this.out.println();
        object = TaxonomyUtils.getDirectInstances(this.taxonomy, aTermAppl);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            set = (ATermAppl)iterator.next();
            if (ATermUtils.isBnode((ATermAppl)set)) {
                return;
            }
            this.out.print("<rdf:Description rdf:about=\"");
            this.out.print(set.getName());
            this.out.println("\">");
            this.printTriple(RDF_TYPE, aTermAppl);
            this.out.println("</rdf:Description>");
            this.out.println();
        }
    }

    protected void printTriple(String string, ATermAppl aTermAppl) {
        this.out.print("   <" + string);
        this.out.print(" rdf:resource=\"");
        this.printConcept(aTermAppl);
        this.out.println("\"/> ");
    }

    protected void printConceptDefinition(ATermAppl aTermAppl, boolean bl) {
        this.out.print("<owl:Class rdf:about=\"");
        this.printConcept(aTermAppl);
        if (bl) {
            this.out.println("\"/> ");
        } else {
            this.out.println("\"> ");
        }
    }

    protected void printConcept(ATermAppl aTermAppl) {
        String string = null;
        string = aTermAppl.equals(ATermUtils.TOP) ? "http://www.w3.org/2002/07/owl#Thing" : (aTermAppl.equals(ATermUtils.BOTTOM) ? "http://www.w3.org/2002/07/owl#Nothing" : aTermAppl.getName());
        this.out.print(string);
    }
}

