/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import java.util.List;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.GuessBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class GuessRule
extends AbstractTableauRule {
    public GuessRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.GUESS, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public void apply(Individual individual) {
        if (individual.isBlockable()) {
            return;
        }
        List<ATermAppl> list = individual.getTypes(5);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ATermAppl aTermAppl = list.get(i);
            this.applyGuessingRule(individual, aTermAppl);
            if (!this.strategy.getABox().isClosed()) continue;
            return;
        }
    }

    private void applyGuessingRule(Individual individual, ATermAppl aTermAppl) {
        Object object;
        int n;
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        Role role = this.strategy.getABox().getRole(aTermAppl2.getArgument(0));
        int n2 = ((ATermInt)aTermAppl2.getArgument(1)).getInt() - 1;
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(2);
        if (role.isDatatypeRole()) {
            return;
        }
        boolean bl = false;
        EdgeList edgeList = individual.getRPredecessorEdges(role.getInverse());
        for (n = 0; n < edgeList.size(); ++n) {
            object = edgeList.edgeAt(n);
            Individual individual2 = object.getFrom();
            if (!individual2.isBlockable()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        if (individual.getMaxCard(role) < n2) {
            return;
        }
        if (individual.hasDistinctRNeighborsForMin(role, n2, ATermUtils.TOP, true)) {
            return;
        }
        n = individual.getMinCard(role, aTermAppl3);
        if (n == 0) {
            n = 1;
        }
        object = individual.getDepends((ATerm)aTermAppl);
        edgeList = individual.getRNeighborEdges(role);
        for (int i = 0; i < edgeList.size(); ++i) {
            Edge edge = edgeList.edgeAt(i);
            object = ((DependencySet)object).union(edge.getDepends(), this.strategy.getABox().doExplanation());
        }
        GuessBranch guessBranch = new GuessBranch(this.strategy.getABox(), this.strategy, individual, role, n, n2, aTermAppl3, (DependencySet)object);
        this.strategy.addBranch(guessBranch);
        guessBranch.tryNext();
    }
}

