/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;

public class DataSatisfiabilityRule
extends AbstractTableauRule {
    public DataSatisfiabilityRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.DATATYPE, AbstractTableauRule.BlockingType.NONE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(Individual individual) {
        Object object;
        HashSet<Literal> hashSet = new HashSet<Literal>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<Literal, Set<Literal>> hashMap = new HashMap<Literal, Set<Literal>>();
        DependencySet dependencySet = DependencySet.EMPTY;
        boolean bl = false;
        for (Edge object22 : individual.getOutEdges()) {
            Role role = object22.getRole();
            if (!role.isDatatypeRole()) continue;
            dependencySet = dependencySet.union(object22.getDepends(), this.strategy.getABox().doExplanation());
            Literal literal = (Literal)object22.getTo();
            linkedList.add(literal);
            object = (Set)hashMap.get(literal);
            for (Role role2 : role.getDisjointRoles()) {
                for (Edge edge : individual.getOutEdges().getEdges(role2)) {
                    Literal literal2 = (Literal)edge.getTo();
                    if (object == null) {
                        object = new HashSet();
                        hashMap.put(literal, (Set<Literal>)object);
                        bl = true;
                    }
                    object.add((Literal)literal2);
                }
            }
        }
        while (!linkedList.isEmpty()) {
            Literal literal = (Literal)linkedList.removeFirst();
            if (!hashSet.add(literal)) continue;
            Set set = (Set)hashMap.get(literal);
            for (Node node : literal.getDifferents()) {
                if (node.isLiteral()) {
                    void var8_13;
                    object = (Literal)node;
                    linkedList.add(object);
                    if (var8_13 == null) {
                        HashSet hashSet2 = new HashSet();
                        hashMap.put(literal, hashSet2);
                        bl = true;
                    }
                    var8_13.add(object);
                    dependencySet = dependencySet.union(literal.getDifferenceDependency(node), this.strategy.getABox().doExplanation());
                    continue;
                }
                throw new IllegalStateException();
            }
        }
        if (bl) {
            try {
                if (!this.strategy.getABox().getDatatypeReasoner().isSatisfiable(hashSet, hashMap)) {
                    for (Node node : hashSet) {
                        for (DependencySet dependencySet2 : node.getDepends().values()) {
                            dependencySet = dependencySet.union(dependencySet2, this.strategy.getABox().doExplanation());
                        }
                    }
                    this.strategy.getABox().setClash(Clash.unexplained(individual, dependencySet));
                }
            }
            catch (InvalidLiteralException invalidLiteralException) {
                String string = "Invalid literal encountered during satisfiability check: " + invalidLiteralException.getMessage();
                if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    log.fine(string);
                    for (Node node : hashSet) {
                        for (DependencySet dependencySet3 : node.getDepends().values()) {
                            dependencySet = dependencySet.union(dependencySet3, this.strategy.getABox().doExplanation());
                        }
                    }
                    this.strategy.getABox().setClash(Clash.invalidLiteral(individual, dependencySet));
                }
                log.severe(string);
                throw new InternalReasonerException(string, invalidLiteralException);
            }
            catch (DatatypeReasonerException datatypeReasonerException) {
                String string = "Unexpected datatype reasoner exception: " + datatypeReasonerException.getMessage();
                log.severe(string);
                throw new InternalReasonerException(string, datatypeReasonerException);
            }
        }
    }
}

