/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;

public abstract class Branch {
    public static final Logger log = Logger.getLogger(Branch.class.getName());
    protected ABox abox;
    protected CompletionStrategy strategy;
    protected int branch;
    protected int tryCount;
    protected int tryNext;
    private DependencySet termDepends;
    private DependencySet prevDS;
    protected int anonCount;
    protected int nodeCount;

    Branch(ABox aBox, CompletionStrategy completionStrategy, DependencySet dependencySet, int n) {
        this.abox = aBox;
        this.setStrategy(completionStrategy);
        this.setTermDepends(dependencySet);
        this.setTryCount(n);
        this.prevDS = DependencySet.EMPTY;
        this.setTryNext(0);
        this.setBranch(aBox.getBranch());
        this.setAnonCount(aBox.getAnonCount());
        this.setNodeCount(aBox.size());
    }

    public void setLastClash(DependencySet dependencySet) {
        if (this.getTryNext() >= 0) {
            this.prevDS = this.prevDS.union(dependencySet, this.abox.doExplanation());
            if (PelletOptions.USE_INCREMENTAL_DELETION) {
                this.abox.getKB().getDependencyIndex().addCloseBranchDependency(this, dependencySet);
            }
        }
    }

    public DependencySet getCombinedClash() {
        return this.prevDS;
    }

    public void setStrategy(CompletionStrategy completionStrategy) {
        this.strategy = completionStrategy;
    }

    public boolean tryNext() {
        if (this.getTryNext() == this.getTryCount()) {
            if (!this.abox.isClosed()) {
                this.abox.setClash(Clash.unexplained(this.getNode(), this.termDepends));
            } else {
                this.abox.getClash().setDepends(this.getCombinedClash());
            }
        }
        if (!this.abox.isClosed()) {
            this.tryBranch();
        }
        if (this.abox.isClosed() && !PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getClash().getDepends().remove(this.getBranch());
        }
        return !this.abox.isClosed();
    }

    public abstract Branch copyTo(ABox var1);

    protected abstract void tryBranch();

    public abstract Node getNode();

    public String toString() {
        return "Branch on node " + this.getNode() + "  Branch number: " + this.getBranch() + " " + this.getTryNext() + "(" + this.getTryCount() + ")";
    }

    public abstract void shiftTryNext(int var1);

    public void setNodeCount(int n) {
        this.nodeCount = n;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setBranch(int n) {
        this.branch = n;
    }

    public int getBranch() {
        return this.branch;
    }

    public int getAnonCount() {
        return this.anonCount;
    }

    public void setTryNext(int n) {
        this.tryNext = n;
    }

    public int getTryNext() {
        return this.tryNext;
    }

    public void setTryCount(int n) {
        this.tryCount = n;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTermDepends(DependencySet dependencySet) {
        this.termDepends = dependencySet;
    }

    public DependencySet getTermDepends() {
        return this.termDepends;
    }

    public void setAnonCount(int n) {
        this.anonCount = n;
    }
}

