/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.output.ATermManchesterSyntaxRenderer;
import org.mindswap.pellet.output.ATermRenderer;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;

public class NodeFormatter {
    private QNameProvider qnames;
    private StringWriter sw;
    private ATermRenderer renderer;
    private PrintWriter formatter;
    private Model rawModel;
    private static final Resource NULL = null;

    public NodeFormatter(Model model) {
        if (model == null) {
            throw new NullPointerException("No model given!");
        }
        this.renderer = new ATermManchesterSyntaxRenderer();
        this.sw = new StringWriter();
        this.formatter = new PrintWriter(this.sw);
        this.renderer.setWriter(this.formatter);
        this.qnames = JenaUtils.makeQNameProvider((PrefixMapping)model);
        if (model instanceof InfModel) {
            InfGraph infGraph = (InfGraph)model.getGraph();
            this.rawModel = ModelFactory.createModelForGraph((Graph)infGraph.getRawGraph());
        } else {
            this.rawModel = model;
        }
    }

    public QNameProvider getQNames() {
        return this.qnames;
    }

    public String format(RDFNode rDFNode) {
        if (rDFNode == null) {
            return "<<null>>";
        }
        this.sw.getBuffer().setLength(0);
        ATerm aTerm = this.node2term(rDFNode);
        if (aTerm instanceof ATermAppl) {
            this.renderer.visit((ATermAppl)aTerm);
        } else {
            this.sw.write("{");
            this.renderer.visitList((ATermList)aTerm);
            this.sw.write("}");
        }
        return this.sw.toString();
    }

    public ATerm node2term(RDFNode rDFNode) {
        ATermAppl aTermAppl = null;
        if (rDFNode.equals(OWL.Thing)) {
            return ATermUtils.TOP;
        }
        if (rDFNode.equals(OWL.Nothing)) {
            return ATermUtils.BOTTOM;
        }
        if (rDFNode.equals(OWL2.topDataProperty)) {
            return ATermUtils.TOP_DATA_PROPERTY;
        }
        if (rDFNode.equals(OWL2.bottomDataProperty)) {
            return ATermUtils.BOTTOM_DATA_PROPERTY;
        }
        if (rDFNode.equals(OWL2.topObjectProperty)) {
            return ATermUtils.TOP_OBJECT_PROPERTY;
        }
        if (rDFNode.equals(OWL2.bottomObjectProperty)) {
            return ATermUtils.BOTTOM_OBJECT_PROPERTY;
        }
        if (rDFNode instanceof Literal) {
            Literal literal = (Literal)rDFNode;
            String string = literal.getDatatypeURI();
            aTermAppl = string != null ? ATermUtils.makeTypedLiteral(literal.getString(), string) : ATermUtils.makePlainLiteral(literal.getString(), literal.getLanguage());
        } else if (rDFNode instanceof Resource) {
            Resource resource = (Resource)rDFNode;
            if (this.rawModel.contains(resource, OWL.onProperty, (RDFNode)NULL)) {
                aTermAppl = this.createRestriction(resource);
            } else if (resource.isAnon()) {
                if (this.rawModel.contains(resource, RDF.first, (RDFNode)NULL)) {
                    aTermAppl = this.createList(resource);
                } else if (this.rawModel.contains(resource, OWL.intersectionOf)) {
                    ATermList aTermList = this.createList(this.rawModel.getProperty(resource, OWL.intersectionOf).getResource());
                    aTermAppl = ATermUtils.makeAnd(aTermList);
                } else if (this.rawModel.contains(resource, OWL.unionOf)) {
                    ATermList aTermList = this.createList(this.rawModel.getProperty(resource, OWL.unionOf).getResource());
                    aTermAppl = ATermUtils.makeOr(aTermList);
                } else if (this.rawModel.contains(resource, OWL.oneOf)) {
                    ATermList aTermList = this.createList(this.rawModel.getProperty(resource, OWL.oneOf).getResource());
                    ATermList aTermList2 = ATermUtils.EMPTY_LIST;
                    ATermList aTermList3 = aTermList;
                    while (!aTermList3.isEmpty()) {
                        ATermAppl aTermAppl2 = (ATermAppl)aTermList3.getFirst();
                        ATermAppl aTermAppl3 = ATermUtils.makeValue((ATerm)aTermAppl2);
                        aTermList2 = aTermList2.insert((ATerm)aTermAppl3);
                        aTermList3 = aTermList3.getNext();
                    }
                    aTermAppl = ATermUtils.makeOr(aTermList2);
                } else if (this.rawModel.contains(resource, OWL.complementOf)) {
                    ATerm aTerm = this.node2term((RDFNode)this.rawModel.getProperty(resource, OWL.complementOf).getResource());
                    aTermAppl = ATermUtils.makeNot(aTerm);
                } else {
                    aTermAppl = ATermUtils.makeBnode(resource.getId().toString());
                }
            } else {
                aTermAppl = ATermUtils.makeTermAppl(resource.getURI());
            }
        }
        return aTermAppl;
    }

    private ATermAppl createRestriction(Resource resource) {
        ATermAppl aTermAppl = ATermUtils.BOTTOM;
        Statement statement = this.rawModel.getProperty(resource, OWL.onProperty);
        Resource resource2 = statement.getResource();
        ATerm aTerm = this.node2term((RDFNode)resource2);
        if (resource.hasProperty(OWL.hasValue)) {
            statement = this.rawModel.getProperty(resource, OWL.hasValue);
            RDFNode rDFNode = statement.getObject();
            ATerm aTerm2 = this.node2term(rDFNode);
            aTermAppl = ATermUtils.makeHasValue(aTerm, aTerm2);
        } else if (resource.hasProperty(OWL.allValuesFrom)) {
            statement = this.rawModel.getProperty(resource, OWL.allValuesFrom);
            Resource resource3 = statement.getResource();
            ATerm aTerm3 = this.node2term((RDFNode)resource3);
            aTermAppl = ATermUtils.makeAllValues(aTerm, aTerm3);
        } else if (resource.hasProperty(OWL.someValuesFrom)) {
            statement = this.rawModel.getProperty(resource, OWL.someValuesFrom);
            Resource resource4 = statement.getResource();
            ATerm aTerm4 = this.node2term((RDFNode)resource4);
            aTermAppl = ATermUtils.makeSomeValues(aTerm, aTerm4);
        } else if (resource.hasProperty(OWL.minCardinality)) {
            statement = this.rawModel.getProperty(resource, OWL.minCardinality);
            int n = 0;
            try {
                n = statement.getInt();
            }
            catch (Exception exception) {
                n = Integer.parseInt(statement.getLiteral().getLexicalForm());
            }
            aTermAppl = ATermUtils.makeDisplayMin(aTerm, n, (ATerm)ATermUtils.EMPTY);
        } else if (resource.hasProperty(OWL.maxCardinality)) {
            statement = this.rawModel.getProperty(resource, OWL.maxCardinality);
            int n = 0;
            try {
                n = statement.getInt();
            }
            catch (Exception exception) {
                n = Integer.parseInt(statement.getLiteral().getLexicalForm());
            }
            aTermAppl = ATermUtils.makeDisplayMax(aTerm, n, (ATerm)ATermUtils.EMPTY);
        } else if (resource.hasProperty(OWL.cardinality)) {
            statement = this.rawModel.getProperty(resource, OWL.cardinality);
            int n = 0;
            try {
                n = statement.getInt();
            }
            catch (Exception exception) {
                n = Integer.parseInt(statement.getLiteral().getLexicalForm());
            }
            aTermAppl = ATermUtils.makeDisplayCard(aTerm, n, (ATerm)ATermUtils.EMPTY);
        }
        return aTermAppl;
    }

    private ATermList createList(Resource resource) {
        if (resource.equals((Object)RDF.nil)) {
            return ATermUtils.EMPTY_LIST;
        }
        if (!this.rawModel.contains(resource, RDF.first)) {
            System.err.println("Invalid list structure: List " + resource + " does not have a rdf:first property. Ignoring rest of the list.");
            return ATermUtils.EMPTY_LIST;
        }
        ATerm aTerm = this.node2term(this.rawModel.getProperty(resource, RDF.first).getObject());
        Resource resource2 = this.rawModel.getProperty(resource, RDF.rest).getResource();
        return ATermUtils.makeList(aTerm, this.createList(resource2));
    }
}

