/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.ontology;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.format.CompactClassLintFormat;
import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.ontology.OntologyLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.util.OWLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;

public class EquivalentAndSubclassAxiomPattern
implements OntologyLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new CompactClassLintFormat();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return "A named concept appears in equivalent axiom(s) and on the left-hand side of a subclass axiom";
    }

    @Override
    public boolean isFixable() {
        return true;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    @Override
    public List<Lint> match(OWLOntology oWLOntology) {
        ArrayList<Lint> arrayList = new ArrayList<Lint>();
        for (OWLClass oWLClass : oWLOntology.getClassesInSignature()) {
            Object object2;
            Set set = oWLOntology.getEquivalentClassesAxioms(oWLClass);
            Set set2 = oWLOntology.getSubClassAxiomsForSubClass(oWLClass);
            HashSet<OWLEquivalentClassesAxiom> hashSet = new HashSet<OWLEquivalentClassesAxiom>();
            block1: for (Object object2 : set) {
                for (OWLClassExpression oWLClassExpression : object2.getClassExpressions()) {
                    if (!OWLUtil.isComplex(oWLClassExpression)) continue;
                    hashSet.add((OWLEquivalentClassesAxiom)object2);
                    continue block1;
                }
            }
            if (hashSet.isEmpty() || hashSet.size() == 1 && set2.isEmpty()) continue;
            Lint lint = new Lint(this, oWLOntology);
            lint.addParticipatingClass(oWLClass);
            lint.addAllParticipatingAxioms(hashSet);
            lint.addAllParticipatingAxioms(set2);
            object2 = EquivalentAndSubclassAxiomPattern.fixEquivalentAxioms(oWLClass, hashSet);
            LintFixer lintFixer = new LintFixer(hashSet, (Set<? extends OWLAxiom>)object2);
            lint.setLintFixer(lintFixer);
            arrayList.add(lint);
        }
        return arrayList;
    }

    private static Set<OWLClassAxiom> fixEquivalentAxioms(OWLClass oWLClass, Set<OWLEquivalentClassesAxiom> set) {
        HashSet<OWLClassAxiom> hashSet = new HashSet<OWLClassAxiom>();
        for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : set) {
            HashSet hashSet2 = new HashSet(oWLEquivalentClassesAxiom.getClassExpressions());
            hashSet2.remove(oWLClass);
            if (hashSet2.size() == 1) {
                hashSet.add((OWLClassAxiom)OWL.subClassOf((OWLClassExpression)oWLClass, (OWLClassExpression)hashSet2.iterator().next()));
                continue;
            }
            hashSet.add((OWLClassAxiom)OWL.equivalentClasses(hashSet2));
            hashSet.add((OWLClassAxiom)OWL.subClassOf((OWLClassExpression)oWLClass, (OWLClassExpression)OWL.and(hashSet2)));
        }
        return hashSet;
    }
}

