/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.jena.SparqlDLResultSet;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorResultSet;
import com.hp.hpl.jena.sparql.engine.main.StageGeneratorGeneric;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.graph.loader.GraphLoader;
import org.mindswap.pellet.utils.ATermUtils;

class SparqlDLStage {
    public static final Logger log = Logger.getLogger(SparqlDLStage.class.getName());
    private ARQParser parser;
    private BasicPattern pattern;
    private Collection<String> vars;

    public SparqlDLStage(BasicPattern basicPattern) {
        this(basicPattern, true);
    }

    public SparqlDLStage(BasicPattern basicPattern, boolean bl) {
        this.pattern = basicPattern;
        this.parser = new ARQParser(bl);
        this.initVars();
    }

    private void initVars() {
        this.vars = new LinkedHashSet<String>();
        for (int i = 0; i < this.pattern.size(); ++i) {
            Triple triple = this.pattern.get(i);
            if (ARQParser.isDistinguishedVariable(triple.getSubject())) {
                this.vars.add(triple.getSubject().getName());
            }
            if (triple.getPredicate().isVariable()) {
                this.vars.add(triple.getPredicate().getName());
            }
            if (!ARQParser.isDistinguishedVariable(triple.getObject())) continue;
            this.vars.add(triple.getObject().getName());
        }
    }

    public QueryIterator build(QueryIterator queryIterator, ExecutionContext executionContext) {
        Graph graph = executionContext.getActiveGraph();
        if (!(graph instanceof PelletInfGraph)) {
            throw new UnsupportedOperationException("A Pellet-backed model is required");
        }
        PelletInfGraph pelletInfGraph = (PelletInfGraph)graph;
        pelletInfGraph.prepare();
        Query query = this.parsePattern(pelletInfGraph);
        if (query != null) {
            return new PelletQueryIterator(pelletInfGraph, query, queryIterator, executionContext);
        }
        return new StageGeneratorGeneric().execute(this.pattern, queryIterator, executionContext);
    }

    private Query parsePattern(PelletInfGraph pelletInfGraph) {
        try {
            return this.parser.parse(this.pattern, this.vars, pelletInfGraph.getKB(), false);
        }
        catch (UnsupportedQueryException unsupportedQueryException) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Falling back to Jena stage", unsupportedQueryException);
            }
            return null;
        }
    }

    private static class PelletQueryIterator
    extends QueryIterRepeatApply {
        private PelletInfGraph pellet;
        private Query query;

        public PelletQueryIterator(PelletInfGraph pelletInfGraph, Query query, QueryIterator queryIterator, ExecutionContext executionContext) {
            super(queryIterator, executionContext);
            this.pellet = pelletInfGraph;
            this.query = query;
        }

        private ResultBinding convertBinding(Binding binding) {
            ResultBindingImpl resultBindingImpl = new ResultBindingImpl();
            GraphLoader graphLoader = this.pellet.getLoader();
            Iterator iterator = binding.vars();
            while (iterator.hasNext()) {
                Var var = (Var)iterator.next();
                Node node = binding.get(var);
                if (node == null) continue;
                ATermAppl aTermAppl = ATermUtils.makeVar(var.getVarName());
                ATermAppl aTermAppl2 = graphLoader.node2term(node);
                resultBindingImpl.setValue(aTermAppl, aTermAppl2);
            }
            return resultBindingImpl;
        }

        protected QueryIterator nextStage(Binding binding) {
            Query query = this.query.apply(this.convertBinding(binding));
            QueryResult queryResult = QueryEngine.exec(query);
            SparqlDLResultSet sparqlDLResultSet = new SparqlDLResultSet(queryResult, null, binding);
            QueryIteratorResultSet queryIteratorResultSet = new QueryIteratorResultSet((ResultSet)sparqlDLResultSet);
            return queryIteratorResultSet;
        }
    }
}

