/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.sparqldl.engine.CombinedQueryEngine;
import com.clarkparsia.pellet.sparqldl.engine.CoreStrategy;
import com.clarkparsia.pellet.sparqldl.engine.QueryExec;
import com.clarkparsia.pellet.sparqldl.model.MultiQueryResults;
import com.clarkparsia.pellet.sparqldl.model.NotKnownQueryAtom;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import com.clarkparsia.pellet.sparqldl.model.UnionQueryAtom;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.clarkparsia.pellet.sparqldl.parser.QueryParser;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.DisjointSet;
import org.mindswap.pellet.utils.SetUtils;

public class QueryEngine {
    public static Logger log = Logger.getLogger(QueryEngine.class.getName());
    public static CoreStrategy STRATEGY = CoreStrategy.ALLFAST;

    public static QueryExec getQueryExec() {
        return new CombinedQueryEngine();
    }

    public static QueryParser getParser() {
        return new ARQParser();
    }

    public static boolean supports(Query query, KnowledgeBase knowledgeBase) {
        return QueryEngine.getQueryExec().supports(query);
    }

    public static QueryResult exec(Query query, KnowledgeBase knowledgeBase) {
        KnowledgeBase knowledgeBase2 = query.getKB();
        query.setKB(knowledgeBase);
        QueryResult queryResult = QueryEngine.exec(query);
        query.setKB(knowledgeBase2);
        return queryResult;
    }

    public static QueryResult exec(Query query) {
        if (query.getAtoms().isEmpty()) {
            QueryResultImpl queryResultImpl = new QueryResultImpl(query);
            queryResultImpl.add(new ResultBindingImpl());
            return queryResultImpl;
        }
        query.getKB().ensureConsistency();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Preprocessing:\n" + query);
        }
        Query query2 = QueryEngine.preprocess(query);
        if (PelletOptions.SIMPLIFY_QUERY) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Simplifying:\n" + query2);
            }
            QueryEngine.simplify(query2);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Splitting:\n" + query2);
        }
        List<Query> list = QueryEngine.split(query2);
        QueryResult queryResult = null;
        if (list.isEmpty()) {
            throw new InternalReasonerException("Splitting query returned no results!");
        }
        if (list.size() == 1) {
            queryResult = QueryEngine.execSingleQuery(list.get(0));
        } else {
            ArrayList<QueryResult> arrayList = new ArrayList<QueryResult>(list.size());
            for (Query query3 : list) {
                arrayList.add(QueryEngine.execSingleQuery(query3));
            }
            queryResult = new MultiQueryResults(query.getResultVars(), arrayList);
        }
        return queryResult;
    }

    private static boolean isObjectProperty(ATermAppl aTermAppl, KnowledgeBase knowledgeBase) {
        if (!ATermUtils.isVar(aTermAppl) && !knowledgeBase.isObjectProperty((ATerm)aTermAppl)) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Undefined object property used in query: " + aTermAppl);
            }
            return false;
        }
        return true;
    }

    private static boolean isDatatypeProperty(ATermAppl aTermAppl, KnowledgeBase knowledgeBase) {
        if (!ATermUtils.isVar(aTermAppl) && !knowledgeBase.isDatatypeProperty((ATerm)aTermAppl)) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Undefined datatype property used in query: " + aTermAppl);
            }
            return false;
        }
        return true;
    }

    private static boolean isAnnotationProperty(ATermAppl aTermAppl, KnowledgeBase knowledgeBase) {
        if (!ATermUtils.isVar(aTermAppl) && !knowledgeBase.isAnnotationProperty((ATerm)aTermAppl)) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Undefined annotation property used in query: " + aTermAppl);
            }
            return false;
        }
        return true;
    }

    private static boolean isProperty(ATermAppl aTermAppl, KnowledgeBase knowledgeBase) {
        if (!(ATermUtils.isVar(aTermAppl) || knowledgeBase.isObjectProperty((ATerm)aTermAppl) || knowledgeBase.isDatatypeProperty((ATerm)aTermAppl) || knowledgeBase.isAnnotationProperty((ATerm)aTermAppl))) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Not an object/data/annotation property: " + aTermAppl);
            }
            return false;
        }
        return true;
    }

    private static boolean isIndividual(ATermAppl aTermAppl, KnowledgeBase knowledgeBase) {
        if (!ATermUtils.isVar(aTermAppl) && !knowledgeBase.isIndividual((ATerm)aTermAppl)) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Undefined individual used in query: " + aTermAppl);
            }
            return false;
        }
        return true;
    }

    private static boolean isClass(ATermAppl aTermAppl, KnowledgeBase knowledgeBase) {
        if (!ATermUtils.isVar(aTermAppl) && !knowledgeBase.isClass((ATerm)aTermAppl)) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Undefined class used in query: " + aTermAppl);
            }
            return false;
        }
        return true;
    }

    private static boolean isDatatype(ATermAppl aTermAppl, KnowledgeBase knowledgeBase) {
        if (!ATermUtils.isVar(aTermAppl) && !knowledgeBase.isDatatype(aTermAppl)) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Undefined datatype used in query: " + aTermAppl);
            }
            return false;
        }
        return true;
    }

    private static boolean hasDefinedTerms(QueryAtom queryAtom, KnowledgeBase knowledgeBase) {
        List<ATermAppl> list = queryAtom.getArguments();
        switch (queryAtom.getPredicate()) {
            case Type: 
            case DirectType: {
                return QueryEngine.isIndividual(list.get(0), knowledgeBase) && QueryEngine.isClass(list.get(1), knowledgeBase);
            }
            case PropertyValue: 
            case NegativePropertyValue: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl2 = list.get(1);
                ATermAppl aTermAppl3 = list.get(2);
                return QueryEngine.isIndividual(aTermAppl, knowledgeBase) && (ATermUtils.isVar(aTermAppl3) ? QueryEngine.isProperty(aTermAppl2, knowledgeBase) : (ATermUtils.isLiteral(aTermAppl3) ? QueryEngine.isDatatypeProperty(aTermAppl2, knowledgeBase) : QueryEngine.isObjectProperty(aTermAppl2, knowledgeBase) && QueryEngine.isIndividual(aTermAppl3, knowledgeBase)));
            }
            case SameAs: 
            case DifferentFrom: {
                return QueryEngine.isIndividual(list.get(0), knowledgeBase) && QueryEngine.isIndividual(list.get(1), knowledgeBase);
            }
            case DatatypeProperty: {
                return QueryEngine.isDatatypeProperty(list.get(0), knowledgeBase);
            }
            case ObjectProperty: 
            case Transitive: 
            case InverseFunctional: 
            case Symmetric: 
            case Asymmetric: 
            case Reflexive: 
            case Irreflexive: {
                return QueryEngine.isObjectProperty(list.get(0), knowledgeBase);
            }
            case Functional: {
                return QueryEngine.isProperty(list.get(0), knowledgeBase);
            }
            case InverseOf: {
                return QueryEngine.isObjectProperty(list.get(0), knowledgeBase) && QueryEngine.isObjectProperty(list.get(1), knowledgeBase);
            }
            case Domain: {
                return QueryEngine.isProperty(list.get(0), knowledgeBase) && QueryEngine.isClass(list.get(1), knowledgeBase);
            }
            case Range: {
                return QueryEngine.isObjectProperty(list.get(0), knowledgeBase) && QueryEngine.isClass(list.get(1), knowledgeBase) || QueryEngine.isDatatypeProperty(list.get(0), knowledgeBase) && QueryEngine.isDatatype(list.get(1), knowledgeBase);
            }
            case SubPropertyOf: 
            case EquivalentProperty: 
            case StrictSubPropertyOf: 
            case DirectSubPropertyOf: 
            case propertyDisjointWith: {
                return QueryEngine.isProperty(list.get(0), knowledgeBase) && QueryEngine.isProperty(list.get(1), knowledgeBase);
            }
            case SubClassOf: 
            case EquivalentClass: 
            case DisjointWith: 
            case ComplementOf: 
            case StrictSubClassOf: 
            case DirectSubClassOf: {
                return QueryEngine.isClass(list.get(0), knowledgeBase) && QueryEngine.isClass(list.get(1), knowledgeBase);
            }
            case NotKnown: {
                return !QueryEngine.hasUndefinedTerm(((NotKnownQueryAtom)queryAtom).getAtoms(), knowledgeBase);
            }
            case Union: {
                for (List<QueryAtom> list2 : ((UnionQueryAtom)queryAtom).getUnion()) {
                    if (!QueryEngine.hasUndefinedTerm(list2, knowledgeBase)) continue;
                    return false;
                }
                return true;
            }
            case Datatype: {
                return knowledgeBase.isDatatype(list.get(1));
            }
            case Annotation: {
                return QueryEngine.isAnnotationProperty(list.get(1), knowledgeBase);
            }
        }
        throw new AssertionError();
    }

    private static boolean hasUndefinedTerm(List<QueryAtom> list, KnowledgeBase knowledgeBase) {
        for (QueryAtom queryAtom : list) {
            if (QueryEngine.hasDefinedTerms(queryAtom, knowledgeBase)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUndefinedTerm(Query query) {
        return QueryEngine.hasUndefinedTerm(query.getAtoms(), query.getKB());
    }

    private static QueryResult execSingleQuery(Query query) {
        if (QueryEngine.hasUndefinedTerm(query)) {
            return new QueryResultImpl(query);
        }
        return QueryEngine.getQueryExec().exec(query);
    }

    public static List<Query> split(Query query) {
        try {
            Object object;
            HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(query.getResultVars());
            DisjointSet<ATermAppl> disjointSet = new DisjointSet<ATermAppl>();
            for (QueryAtom object22 : query.getAtoms()) {
                object = null;
                for (ATermAppl aTermAppl : object22.getArguments()) {
                    if (!ATermUtils.isVar(aTermAppl)) continue;
                    disjointSet.add(aTermAppl);
                    if (object != null) {
                        disjointSet.union((ATermAppl)object, aTermAppl);
                    }
                    object = aTermAppl;
                }
            }
            Collection collection = disjointSet.getEquivalanceSets();
            if (collection.size() == 1) {
                return Collections.singletonList(query);
            }
            HashMap<ATermAppl, Object> hashMap = new HashMap<ATermAppl, Object>();
            object = null;
            for (QueryAtom queryAtom : query.getAtoms()) {
                ATermAppl aTermAppl = null;
                for (ATermAppl aTermAppl2 : queryAtom.getArguments()) {
                    if (!ATermUtils.isVar(aTermAppl2)) continue;
                    aTermAppl = disjointSet.find(aTermAppl2);
                    break;
                }
                Object object2 = null;
                if (aTermAppl == null) {
                    if (object == null) {
                        object = new QueryImpl(query);
                    }
                    object2 = object;
                } else {
                    object2 = (Query)hashMap.get(aTermAppl);
                    if (object2 == null) {
                        object2 = new QueryImpl(query);
                        hashMap.put(aTermAppl, object2);
                    }
                    for (ATermAppl aTermAppl3 : queryAtom.getArguments()) {
                        if (hashSet.contains(aTermAppl3)) {
                            object2.addResultVar(aTermAppl3);
                        }
                        for (Query.VarType varType : Query.VarType.values()) {
                            if (!query.getDistVarsForType(varType).contains(aTermAppl3)) continue;
                            object2.addDistVar(aTermAppl3, varType);
                        }
                    }
                }
                object2.add(queryAtom);
            }
            ArrayList arrayList = new ArrayList(hashMap.values());
            if (object != null) {
                arrayList.add(0, object);
            }
            return arrayList;
        }
        catch (RuntimeException runtimeException) {
            log.log(Level.WARNING, "Query split failed, continuing with query execution.", runtimeException);
            return Collections.singletonList(query);
        }
    }

    private static void simplify(Query query) {
        QueryEngine.domainRangeSimplification(query);
    }

    private static Query preprocess(Query query) {
        ATermAppl aTermAppl;
        ATermAppl aTermAppl2;
        Query query2 = query;
        Set<ATermAppl> set = query2.getUndistVars();
        boolean bl = true;
        block4: while (bl) {
            bl = false;
            for (QueryAtom queryAtom : query2.findAtoms(QueryPredicate.SameAs, null, null)) {
                ResultBindingImpl resultBindingImpl;
                aTermAppl2 = queryAtom.getArguments().get(0);
                aTermAppl = queryAtom.getArguments().get(1);
                boolean bl2 = false;
                boolean bl3 = false;
                if (!aTermAppl2.equals(aTermAppl)) {
                    if (set.contains(aTermAppl2)) {
                        bl2 = true;
                    } else if (set.contains(aTermAppl)) {
                        bl3 = true;
                    } else if (ATermUtils.isVar(aTermAppl2) && !query2.getResultVars().contains(aTermAppl2)) {
                        bl2 = true;
                    } else if (ATermUtils.isVar(aTermAppl) && !query2.getResultVars().contains(aTermAppl)) {
                        bl3 = true;
                    }
                }
                if (!bl2 && !bl3) continue;
                if (bl2) {
                    resultBindingImpl = new ResultBindingImpl();
                    resultBindingImpl.setValue(aTermAppl2, aTermAppl);
                } else {
                    resultBindingImpl = new ResultBindingImpl();
                    resultBindingImpl.setValue(aTermAppl, aTermAppl2);
                }
                query2 = query2.apply(resultBindingImpl);
                bl = true;
                continue block4;
            }
        }
        for (QueryAtom queryAtom : query2.findAtoms(QueryPredicate.SameAs, null, null)) {
            aTermAppl2 = queryAtom.getArguments().get(0);
            if (!aTermAppl2.equals(aTermAppl = queryAtom.getArguments().get(1)) || query2.getResultVars().contains(aTermAppl2) || query2.getAtoms().size() <= 1) continue;
            query2.remove(queryAtom);
        }
        for (QueryAtom queryAtom : new HashSet<QueryAtom>(query2.getAtoms())) {
            switch (queryAtom.getPredicate()) {
                case Type: 
                case DirectType: {
                    aTermAppl2 = queryAtom.getArguments().get(1);
                    if (!set.contains(aTermAppl2) || !set.contains(queryAtom.getArguments().get(0))) break;
                    query2.add(QueryAtomFactory.SubClassOfAtom(aTermAppl2, aTermAppl2));
                    break;
                }
                case PropertyValue: {
                    aTermAppl = queryAtom.getArguments().get(1);
                    if (!set.contains(queryAtom.getArguments().get(0)) && (!set.contains(queryAtom.getArguments().get(2)) || !query2.getDistVars().contains(aTermAppl))) break;
                    query2.add(QueryAtomFactory.SubPropertyOfAtom(aTermAppl, aTermAppl));
                    break;
                }
            }
        }
        return query2;
    }

    public static CoreStrategy getStrategy(QueryAtom queryAtom) {
        return STRATEGY;
    }

    private static void domainRangeSimplification(Query query) {
        ATermAppl aTermAppl;
        HashMap<ATermAppl, ATermAppl> hashMap = new HashMap<ATermAppl, ATermAppl>();
        KnowledgeBase knowledgeBase = query.getKB();
        Set<ATermAppl> set = query.getVars();
        for (ATermAppl object : set) {
            aTermAppl = new HashSet();
            for (QueryAtom queryAtom : query.findAtoms(QueryPredicate.PropertyValue, object, null, null)) {
                if (ATermUtils.isVar(queryAtom.getArguments().get(1))) continue;
                aTermAppl.addAll(knowledgeBase.getDomains(queryAtom.getArguments().get(1)));
            }
            for (QueryAtom queryAtom : query.findAtoms(QueryPredicate.PropertyValue, null, null, object)) {
                if (ATermUtils.isVar(queryAtom.getArguments().get(1))) continue;
                aTermAppl.addAll(knowledgeBase.getRanges((ATerm)queryAtom.getArguments().get(1)));
            }
            if (aTermAppl.isEmpty()) continue;
            hashMap.put(object, aTermAppl);
        }
        for (QueryAtom queryAtom : new ArrayList<QueryAtom>(query.getAtoms())) {
            Set set2;
            if (queryAtom.getPredicate() != QueryPredicate.Type) continue;
            aTermAppl = queryAtom.getArguments().get(0);
            ATermAppl aTermAppl2 = queryAtom.getArguments().get(1);
            if (ATermUtils.isVar(aTermAppl2) || (set2 = (Set)hashMap.get(aTermAppl)) == null || set2.isEmpty()) continue;
            if (set2.contains(aTermAppl2)) {
                query.remove(queryAtom);
                continue;
            }
            if (!knowledgeBase.isClassified()) continue;
            Set<ATermAppl> set3 = knowledgeBase.getTaxonomy().getFlattenedSubs(aTermAppl2, false);
            Set<ATermAppl> set4 = knowledgeBase.getAllEquivalentClasses(aTermAppl2);
            if (!SetUtils.intersects(set2, set3) && !SetUtils.intersects(set2, set4)) continue;
            query.remove(queryAtom);
        }
    }

    public static boolean execBooleanABoxQuery(Query query) {
        ATermAppl aTermAppl;
        boolean bl;
        Object object;
        Bool bool;
        QueryAtom queryAtom2;
        KnowledgeBase knowledgeBase = query.getKB();
        knowledgeBase.ensureConsistency();
        Bool bool2 = Bool.TRUE;
        for (QueryAtom queryAtom2 : query.getAtoms()) {
            bool = Bool.UNKNOWN;
            if (queryAtom2.isGround()) {
                object = queryAtom2.getArguments();
                switch (queryAtom2.getPredicate()) {
                    case Type: {
                        bool = knowledgeBase.isKnownType(object.get(0), object.get(1));
                        break;
                    }
                    case PropertyValue: 
                    case Annotation: {
                        bool = knowledgeBase.hasKnownPropertyValue(object.get(0), object.get(1), (ATermAppl)object.get(2));
                        break;
                    }
                    default: {
                        bool = Bool.UNKNOWN;
                    }
                }
            }
            if (bool.isUnknown()) {
                bool2 = Bool.UNKNOWN;
                continue;
            }
            if (!bool.isFalse()) continue;
            bool2 = Bool.FALSE;
            if (!log.isLoggable(Level.FINER)) break;
            log.finer("Failed atom: " + queryAtom2);
            break;
        }
        if (bool2.isKnown()) {
            bl = bool2.isTrue();
        } else if (!query.getConstants().isEmpty()) {
            aTermAppl = query.getConstants().iterator().next();
            queryAtom2 = query.rollUpTo(aTermAppl, Collections.emptySet(), false);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Boolean query: " + aTermAppl + " -> " + queryAtom2);
            }
            bl = knowledgeBase.isType(aTermAppl, (ATermAppl)queryAtom2);
        } else {
            aTermAppl = query.getUndistVars().iterator().next();
            queryAtom2 = query.rollUpTo(aTermAppl, Collections.emptySet(), false);
            bool = ATermUtils.normalize(ATermUtils.makeNot((ATerm)queryAtom2));
            object = knowledgeBase.getRole((ATerm)TermFactory.TOP_OBJECT_PROPERTY);
            boolean bl2 = ((Role)object).addDomain((ATermAppl)bool, DependencySet.INDEPENDENT);
            ABox aBox = knowledgeBase.getABox().copy();
            aBox.setInitialized(false);
            boolean bl3 = bl = !aBox.isConsistent();
            if (bl2) {
                ((Role)object).removeDomain((ATermAppl)bool, DependencySet.INDEPENDENT);
            }
        }
        return bl;
    }

    public static boolean checkGround(QueryAtom queryAtom, KnowledgeBase knowledgeBase) {
        List<ATermAppl> list = queryAtom.getArguments();
        switch (queryAtom.getPredicate()) {
            case Type: {
                return knowledgeBase.isType(list.get(0), list.get(1));
            }
            case DirectType: {
                return knowledgeBase.getInstances(list.get(1), true).contains(list.get(0));
            }
            case Annotation: {
                return knowledgeBase.getAnnotations(list.get(0), list.get(1)).contains(list.get(2));
            }
            case PropertyValue: {
                return knowledgeBase.hasPropertyValue(list.get(0), list.get(1), list.get(2));
            }
            case SameAs: {
                return knowledgeBase.isSameAs(list.get(0), list.get(1));
            }
            case DifferentFrom: {
                return knowledgeBase.isDifferentFrom(list.get(0), list.get(1));
            }
            case EquivalentClass: {
                return knowledgeBase.isEquivalentClass(list.get(0), list.get(1));
            }
            case SubClassOf: {
                return knowledgeBase.isSubClassOf(list.get(0), list.get(1));
            }
            case DirectSubClassOf: {
                for (Set<ATermAppl> set : knowledgeBase.getSubClasses(list.get(1), true)) {
                    if (!set.contains(list.get(0))) continue;
                    return true;
                }
                return false;
            }
            case StrictSubClassOf: {
                return knowledgeBase.isSubClassOf(list.get(0), list.get(1)) && !knowledgeBase.getEquivalentClasses(list.get(1)).contains(list.get(0));
            }
            case DisjointWith: {
                return knowledgeBase.isDisjoint(list.get(0), list.get(1));
            }
            case ComplementOf: {
                return knowledgeBase.isComplement(list.get(0), list.get(1));
            }
            case EquivalentProperty: {
                return knowledgeBase.isEquivalentProperty(list.get(0), list.get(1));
            }
            case SubPropertyOf: {
                return knowledgeBase.isSubPropertyOf(list.get(0), list.get(1));
            }
            case DirectSubPropertyOf: {
                for (Set<ATermAppl> set : knowledgeBase.getSubProperties(list.get(1), true)) {
                    if (!set.contains(list.get(0))) continue;
                    return true;
                }
                return false;
            }
            case StrictSubPropertyOf: {
                return knowledgeBase.isSubPropertyOf(list.get(0), list.get(1)) && !knowledgeBase.getEquivalentProperties(list.get(1)).contains(list.get(0));
            }
            case Domain: {
                return knowledgeBase.hasDomain(list.get(0), list.get(1));
            }
            case Range: {
                return knowledgeBase.hasRange(list.get(0), list.get(1));
            }
            case InverseOf: {
                return knowledgeBase.isInverse(list.get(0), list.get(1));
            }
            case ObjectProperty: {
                return knowledgeBase.isObjectProperty((ATerm)list.get(0));
            }
            case DatatypeProperty: {
                return knowledgeBase.isDatatypeProperty((ATerm)list.get(0));
            }
            case Functional: {
                return knowledgeBase.isFunctionalProperty(list.get(0));
            }
            case InverseFunctional: {
                return knowledgeBase.isInverseFunctionalProperty(list.get(0));
            }
            case Symmetric: {
                return knowledgeBase.isSymmetricProperty(list.get(0));
            }
            case Asymmetric: {
                return knowledgeBase.isAsymmetricProperty(list.get(0));
            }
            case Reflexive: {
                return knowledgeBase.isReflexiveProperty(list.get(0));
            }
            case Irreflexive: {
                return knowledgeBase.isIrreflexiveProperty(list.get(0));
            }
            case Transitive: {
                return knowledgeBase.isTransitiveProperty(list.get(0));
            }
            case NotKnown: {
                for (QueryAtom queryAtom2 : ((NotKnownQueryAtom)queryAtom).getAtoms()) {
                    if (QueryEngine.checkGround(queryAtom2, knowledgeBase)) continue;
                    return true;
                }
                return false;
            }
            case NegativePropertyValue: {
                return knowledgeBase.isType(list.get(0), TermFactory.not(TermFactory.hasValue(list.get(1), list.get(2))));
            }
            case Union: {
                block39: for (List<QueryAtom> list2 : ((UnionQueryAtom)queryAtom).getUnion()) {
                    for (QueryAtom queryAtom3 : list2) {
                        if (QueryEngine.checkGround(queryAtom3, knowledgeBase)) continue;
                        continue block39;
                    }
                    return true;
                }
                return false;
            }
            case Datatype: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl2 = list.get(1);
                if (!ATermUtils.isLiteral(aTermAppl)) {
                    return false;
                }
                DatatypeReasoner datatypeReasoner = knowledgeBase.getDatatypeReasoner();
                try {
                    Object object = datatypeReasoner.getValue(aTermAppl);
                    return datatypeReasoner.isSatisfiable(Collections.singleton(aTermAppl2), object);
                }
                catch (DatatypeReasonerException datatypeReasonerException) {
                    String string = String.format("Unexpected datatype reasoner exception while checking if literal (%s) is in datarange (%s): %s ", aTermAppl, aTermAppl2, datatypeReasonerException.getMessage());
                    log.severe(string);
                    throw new InternalReasonerException(string, datatypeReasonerException);
                }
            }
        }
        throw new IllegalArgumentException("Unknown atom type : " + (Object)((Object)queryAtom.getPredicate()));
    }
}

