/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryCost;
import com.clarkparsia.pellet.sparqldl.engine.QueryPlan;
import com.clarkparsia.pellet.sparqldl.engine.QuerySizeEstimator;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.utils.ATermUtils;

public class CostBasedQueryPlanNew
extends QueryPlan {
    private static final Logger log = Logger.getLogger(CostBasedQueryPlanNew.class.getName());
    private List<QueryAtom> sortedAtoms;
    private int index;
    private int size;
    private QueryCost cost;

    public CostBasedQueryPlanNew(Query query) {
        super(query);
        QuerySizeEstimator.computeSizeEstimate(query);
        this.index = 0;
        this.size = query.getAtoms().size();
        this.cost = new QueryCost(query.getKB());
        this.sortedAtoms = null;
        if (this.size == 0) {
            return;
        }
        if (this.size == 1) {
            this.sortedAtoms = query.getAtoms();
        } else {
            double d = this.chooseOrdering(new ArrayList<QueryAtom>(query.getAtoms()), new ArrayList<QueryAtom>(this.size), new HashSet<ATermAppl>(), false, Double.POSITIVE_INFINITY);
            if (this.sortedAtoms == null) {
                throw new UnsupportedQueryException("No safe ordering for query: " + query);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "WINNER : Cost=" + d + " ,atoms=" + this.sortedAtoms);
            }
        }
    }

    private double chooseOrdering(List<QueryAtom> list, List<QueryAtom> list2, Set<ATermAppl> set, boolean bl, double d) {
        if (list.isEmpty()) {
            if (bl) {
                if (this.sortedAtoms == null) {
                    this.sortedAtoms = new ArrayList<QueryAtom>(list2);
                }
            } else {
                double d2 = this.cost.estimate(list2);
                log.fine("Cost " + d2 + " for " + list2);
                if (d2 < d) {
                    this.sortedAtoms = new ArrayList<QueryAtom>(list2);
                    d = d2;
                }
            }
            return d;
        }
        block0: for (int i = 0; i < list.size(); ++i) {
            QueryAtom queryAtom = list.get(i);
            boolean bl2 = bl;
            HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(set);
            if (!queryAtom.isGround()) {
                int n = 0;
                int n2 = 0;
                for (ATermAppl aTermAppl : queryAtom.getArguments()) {
                    if (!ATermUtils.isVar(aTermAppl)) continue;
                    if (hashSet.add(aTermAppl)) {
                        ++n2;
                        if (!queryAtom.getPredicate().equals((Object)QueryPredicate.NotKnown)) continue;
                        for (int j = 0; j < list.size(); ++j) {
                            QueryAtom queryAtom2 = list.get(j);
                            if (i == j || queryAtom2.getPredicate().equals((Object)QueryPredicate.NotKnown) || !queryAtom2.getArguments().contains(aTermAppl)) continue;
                            if (!log.isLoggable(Level.FINE)) continue block0;
                            log.fine("Unbound vars for not");
                            continue block0;
                        }
                        continue;
                    }
                    ++n;
                }
                if (n == 0 && hashSet.size() > n2) {
                    if (this.sortedAtoms != null) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("Stop at not optimal ordering");
                        continue;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Continue not optimal ordering, no solution yet.");
                    }
                    bl2 = true;
                }
            }
            list.remove(queryAtom);
            list2.add(queryAtom);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Atom[" + i + "/" + list.size() + "] " + queryAtom + " from " + list + " to " + list2);
            }
            d = this.chooseOrdering(list, list2, hashSet, bl2, d);
            list.add(i, queryAtom);
            list2.remove(list2.size() - 1);
        }
        return d;
    }

    @Override
    public QueryAtom next(ResultBinding resultBinding) {
        return this.sortedAtoms.get(this.index++).apply(resultBinding);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public void back() {
        --this.index;
    }

    @Override
    public void reset() {
        this.index = 0;
    }
}

