/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class Tuple<T> {
    private DependencySet ds;
    private List<T> elements;

    public Tuple(DependencySet dependencySet, T ... TArray) {
        if (dependencySet == null) {
            throw new InternalReasonerException("Null dependencyset argument to rete tuple");
        }
        this.ds = dependencySet;
        this.elements = Collections.unmodifiableList(Arrays.asList(TArray));
    }

    public Tuple(DependencySet dependencySet, List<T> list) {
        this.ds = dependencySet;
        this.elements = Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public DependencySet getDependencySet() {
        return this.ds;
    }

    public List<T> getElements() {
        return this.elements;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return this.elements.toString();
    }
}

