/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.NumericVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public class NumberToLiteralVisitor
implements NumericVisitor {
    private ABox abox;
    private Literal result;

    public NumberToLiteralVisitor(ABox aBox) {
        this.abox = aBox;
    }

    private void argCheck(Number[] numberArray) {
        if (numberArray.length != 1) {
            throw new InternalReasonerException("Wrong number of arguments to visitor.");
        }
    }

    public Literal getLiteral() {
        return this.result;
    }

    private void setLiteral(Number number, String string) {
        this.result = this.abox.addLiteral(ATermUtils.makeTypedLiteral(number.toString(), string));
    }

    @Override
    public void visit(BigDecimal[] bigDecimalArray) {
        this.argCheck(bigDecimalArray);
        this.setLiteral(bigDecimalArray[0], "http://www.w3.org/2001/XMLSchema#decimal");
    }

    @Override
    public void visit(BigInteger[] bigIntegerArray) {
        this.argCheck(bigIntegerArray);
        this.setLiteral(bigIntegerArray[0], "http://www.w3.org/2001/XMLSchema#integer");
    }

    @Override
    public void visit(Double[] doubleArray) {
        this.argCheck(doubleArray);
        this.setLiteral(doubleArray[0], "http://www.w3.org/2001/XMLSchema#double");
    }

    @Override
    public void visit(Float[] floatArray) {
        this.argCheck(floatArray);
        this.setLiteral(floatArray[0], "http://www.w3.org/2001/XMLSchema#float");
    }
}

