/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.BooleanOperators;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.ComparisonTesters;
import com.clarkparsia.pellet.rules.builtins.DateTimeOperators;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.FunctionBuiltIn;
import com.clarkparsia.pellet.rules.builtins.GeneralFunction;
import com.clarkparsia.pellet.rules.builtins.GeneralFunctionBuiltIn;
import com.clarkparsia.pellet.rules.builtins.NoSuchBuiltIn;
import com.clarkparsia.pellet.rules.builtins.NumericAdapter;
import com.clarkparsia.pellet.rules.builtins.NumericFunction;
import com.clarkparsia.pellet.rules.builtins.NumericOperators;
import com.clarkparsia.pellet.rules.builtins.StringOperators;
import com.clarkparsia.pellet.rules.builtins.Tester;
import com.clarkparsia.pellet.rules.builtins.TesterBuiltIn;
import com.clarkparsia.pellet.rules.builtins.URIOperators;
import java.util.HashMap;
import java.util.Map;

public class BuiltInRegistry {
    public static final BuiltInRegistry instance = new BuiltInRegistry();
    private Map<String, BuiltIn> builtIns = new HashMap<String, BuiltIn>();

    private BuiltInRegistry() {
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#equal", this.tester(ComparisonTesters.equal));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#greaterThan", this.tester(ComparisonTesters.greaterThan));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#greaterThanOrEqual", this.tester(ComparisonTesters.greaterThanOrEqual));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#lessThan", this.tester(ComparisonTesters.lessThan));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#lessThanOrEqual", this.tester(ComparisonTesters.lessThanOrEqual));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#notEqual", this.tester(ComparisonTesters.notEqual));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#date", this.generalFunc(DateTimeOperators.date));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#dateTime", this.generalFunc(DateTimeOperators.dateTime));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#dayTimeDuration", this.function(DateTimeOperators.dayTimeDuration));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#time", this.generalFunc(DateTimeOperators.time));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#yearMonthDuration", this.function(DateTimeOperators.yearMonthDuration));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#resolveURI", this.function(URIOperators.resolveURI));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#anyURI", this.function(URIOperators.anyURI));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#abs", this.numeric(NumericOperators.abs));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#add", this.numeric(NumericOperators.add));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#ceiling", this.numeric(NumericOperators.ceiling));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#cos", this.numeric(NumericOperators.cos));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#divide", this.numeric(NumericOperators.divide));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#floor", this.numeric(NumericOperators.floor));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#integerDivide", this.numeric(NumericOperators.integerDivide));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#mod", this.numeric(NumericOperators.mod));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#multiply", this.numeric(NumericOperators.multiply));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#pow", this.numeric(NumericOperators.pow));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#round", this.numeric(NumericOperators.round));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#roundHalfToEven", this.numeric(NumericOperators.roundHalfToEven));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#sin", this.numeric(NumericOperators.sin));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#subtract", this.numeric(NumericOperators.subtract));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#tan", this.numeric(NumericOperators.tan));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#unaryMinus", this.numeric(NumericOperators.unaryMinus));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#unaryPlus", this.numeric(NumericOperators.unaryPlus));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#contains", this.tester(StringOperators.contains));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#containsIgnoreCase", this.tester(StringOperators.containsIgnoreCase));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#endsWith", this.tester(StringOperators.endsWith));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#lowerCase", this.function(StringOperators.lowerCase));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#matches", this.tester(StringOperators.matches));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#normalizeSpace", this.function(StringOperators.normalizeSpace));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#replace", this.function(StringOperators.replace));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#startsWith", this.tester(StringOperators.startsWith));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#stringConcat", this.function(StringOperators.stringConcat));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#stringEqualIgnoreCase", this.tester(StringOperators.stringEqualIgnoreCase));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#stringLength", this.function(StringOperators.stringLength));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#substring", this.function(StringOperators.substring));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#substringAfter", this.function(StringOperators.substringAfter));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#substringBefore", this.function(StringOperators.substringBefore));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#tokenize", StringOperators.tokenize);
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#translate", this.function(StringOperators.translate));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#upperCase", this.function(StringOperators.upperCase));
        this.registerBuiltIn("http://www.w3.org/2003/11/swrlb#booleanNot", this.generalFunc(BooleanOperators.booleanNot));
    }

    public BuiltIn getBuiltIn(String string) {
        BuiltIn builtIn = this.builtIns.get(string);
        if (builtIn == null) {
            builtIn = NoSuchBuiltIn.instance;
        }
        return builtIn;
    }

    private BuiltIn function(Function function) {
        return new FunctionBuiltIn(function);
    }

    private BuiltIn generalFunc(GeneralFunction generalFunction) {
        return new GeneralFunctionBuiltIn(generalFunction);
    }

    private BuiltIn numeric(NumericFunction numericFunction) {
        return this.function(new NumericAdapter(numericFunction));
    }

    public void registerBuiltIn(String string, BuiltIn builtIn) {
        this.builtIns.put(string, builtIn);
    }

    private BuiltIn tester(Tester tester) {
        return new TesterBuiltIn(tester);
    }
}

