/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.RulesToReteTranslator;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DefaultAtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.Pair;

public class ContinuousReteTransformer {
    private static final String PREFIX = "tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:";
    private static final ATermAppl DUMMY = ATermUtils.makeTermAppl("tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:slot-filler");
    private static final int RULEPOS = 1;
    private static final int VARSTARTPOS = 4;
    public static final ATermAppl VARBINDING = ATermUtils.makeTermAppl("tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:variable-binding");
    private static int ruleNumber = 0;
    private ABox abox;
    private AtomFilter filter;
    private Map<Rule, ATermAppl> reverseRuleMap;
    private Map<ATermAppl, Pair<Rule, List<AtomVariable>>> ruleMap;
    private RulesToReteTranslator translator;

    public ContinuousReteTransformer(ABox aBox) {
        this.abox = aBox;
        this.filter = new AtomFilter();
        this.ruleMap = new HashMap<ATermAppl, Pair<Rule, List<AtomVariable>>>();
        this.reverseRuleMap = new HashMap<Rule, ATermAppl>();
        this.translator = new RulesToReteTranslator(aBox);
    }

    protected ATermAppl getRuleID(Rule rule) {
        ATermAppl aTermAppl = this.reverseRuleMap.get(rule);
        if (aTermAppl == null) {
            aTermAppl = ATermUtils.makeTermAppl("tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:rule-" + ruleNumber++);
            this.reverseRuleMap.put(rule, aTermAppl);
        }
        return aTermAppl;
    }

    public com.clarkparsia.pellet.rules.rete.Rule transformRule(Rule rule) {
        Object object;
        ATermAppl aTermAppl = this.getRuleID(rule);
        DependencySet dependencySet = DependencySet.INDEPENDENT;
        TreeSet<ATerm> treeSet = new TreeSet<ATerm>(Comparators.termComparator);
        ArrayList<TermTuple> arrayList = new ArrayList<TermTuple>();
        HashMap<ATermAppl, AtomVariable> hashMap = new HashMap<ATermAppl, AtomVariable>();
        for (RuleAtom object22 : rule.getBody()) {
            object22.accept(this.filter);
            if (!this.filter.isSafe() || (object = this.translator.translateAtom(object22, dependencySet)) == null) continue;
            arrayList.add((TermTuple)object);
            for (AtomVariable atomVariable : VariableUtils.getVars(object22)) {
                Pair<ATermAppl, DependencySet> pair = this.translator.translateAtomObject(atomVariable);
                ATermAppl aTermAppl2 = (ATermAppl)pair.first;
                hashMap.put(aTermAppl2, atomVariable);
                treeSet.add((ATerm)aTermAppl2);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(VARBINDING);
        arrayList2.add(aTermAppl);
        arrayList2.add(DUMMY);
        arrayList2.add(DUMMY);
        arrayList2.addAll(treeSet);
        List<TermTuple> list = Collections.singletonList(new TermTuple(DependencySet.INDEPENDENT, arrayList2));
        object = new ArrayList(treeSet.size());
        for (ATermAppl aTermAppl3 : treeSet) {
            object.add(hashMap.get(aTermAppl3));
        }
        this.ruleMap.put(aTermAppl, new Pair<Rule, Object>(rule, object));
        return new com.clarkparsia.pellet.rules.rete.Rule(arrayList, list);
    }

    public Pair<Rule, VariableBinding> translateFact(Fact fact) {
        Pair<Rule, VariableBinding> pair = null;
        if (fact.getElements().size() >= 4 && ((ATermAppl)fact.getElements().get(0)).equals(VARBINDING)) {
            Pair<Rule, List<AtomVariable>> pair2 = this.ruleMap.get(fact.getElements().get(1));
            Rule rule = (Rule)pair2.first;
            List list = (List)pair2.second;
            List list2 = fact.getElements().subList(4, fact.getElements().size());
            if (list.size() != list2.size()) {
                throw new InternalReasonerException("Variable list doesn't match constants!");
            }
            VariableBinding variableBinding = new VariableBinding(this.abox);
            for (int i = 0; i < list.size(); ++i) {
                ((AtomVariable)list.get(i)).accept(new BindingSetter(variableBinding, (ATermAppl)list2.get(i)));
            }
            pair = new Pair<Rule, VariableBinding>(rule, variableBinding);
        }
        return pair;
    }

    private static class BindingSetter
    extends DefaultAtomObjectVisitor {
        private VariableBinding binding;
        private ATermAppl constant;

        public BindingSetter(VariableBinding variableBinding, ATermAppl aTermAppl) {
            this.binding = variableBinding;
            this.constant = aTermAppl;
        }

        @Override
        public void visit(AtomDVariable atomDVariable) {
            this.binding.set(atomDVariable, this.constant);
        }

        @Override
        public void visit(AtomIVariable atomIVariable) {
            this.binding.set(atomIVariable, this.constant);
        }
    }

    private class AtomFilter
    implements RuleAtomVisitor {
        private boolean result = false;

        private AtomFilter() {
        }

        public boolean isSafe() {
            return this.result;
        }

        @Override
        public void visit(BuiltInAtom builtInAtom) {
            this.result = false;
        }

        @Override
        public void visit(ClassAtom classAtom) {
            ATermAppl aTermAppl = (ATermAppl)classAtom.getPredicate();
            this.result = ContinuousReteTransformer.this.abox.getKB().getTBox().isPrimitive(aTermAppl);
        }

        @Override
        public void visit(DataRangeAtom dataRangeAtom) {
            this.result = false;
        }

        @Override
        public void visit(DatavaluedPropertyAtom datavaluedPropertyAtom) {
            this.result = true;
        }

        @Override
        public void visit(DifferentIndividualsAtom differentIndividualsAtom) {
            this.result = false;
        }

        @Override
        public void visit(IndividualPropertyAtom individualPropertyAtom) {
            this.result = ContinuousReteTransformer.this.abox.getRole((ATerm)individualPropertyAtom.getPredicate()).isSimple();
        }

        @Override
        public void visit(SameIndividualAtom sameIndividualAtom) {
            this.result = false;
        }
    }
}

