/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.BindingGenerator;
import com.clarkparsia.pellet.rules.BindingGeneratorImpl;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategy;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.DataRangeBindingHelper;
import com.clarkparsia.pellet.rules.DatavaluePropertyBindingHelper;
import com.clarkparsia.pellet.rules.ObjectVariableBindingHelper;
import com.clarkparsia.pellet.rules.TrivialSatisfactionHelpers;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.BuiltInRegistry;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DefaultRuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.mindswap.pellet.ABox;

public class BindingGeneratorStrategyImpl
implements BindingGeneratorStrategy {
    private ABox abox;

    public BindingGeneratorStrategyImpl(ABox aBox) {
        this.abox = aBox;
    }

    @Override
    public BindingGenerator createGenerator(Rule rule) {
        return this.createGenerator(rule, new VariableBinding(this.abox));
    }

    @Override
    public BindingGenerator createGenerator(Rule rule, VariableBinding variableBinding) {
        BodyAtomsToSelectiveHelpersVisitor bodyAtomsToSelectiveHelpersVisitor = new BodyAtomsToSelectiveHelpersVisitor();
        HashSet<AtomIVariable> hashSet = new HashSet<AtomIVariable>();
        HashSet<AtomDVariable> hashSet2 = new HashSet<AtomDVariable>();
        for (RuleAtom iterator : rule.getBody()) {
            iterator.accept(bodyAtomsToSelectiveHelpersVisitor);
            hashSet.addAll(VariableUtils.getIVars(iterator));
            hashSet2.addAll(VariableUtils.getDVars(iterator));
        }
        List<BindingHelper> list = bodyAtomsToSelectiveHelpersVisitor.getHelpers();
        HashSet hashSet3 = new HashSet();
        for (BindingHelper bindingHelper : list) {
            Set<AtomVariable> set = Collections.emptySet();
            hashSet3.addAll(bindingHelper.getBindableVars(set));
        }
        for (AtomIVariable atomIVariable : hashSet) {
            if (hashSet3.contains(atomIVariable)) continue;
            list.add(new ObjectVariableBindingHelper(this.abox, atomIVariable));
        }
        list.addAll(new TrivialSatisfactionHelpers(this.abox).getHelpers(rule));
        if (!this.ensureOrdering(list, variableBinding)) {
            ABox.log.warning("IGNORING RULE " + rule + ": Could not generate safe ordering for body constraints.");
            return new BindingGeneratorImpl();
        }
        this.optimize(list);
        return new BindingGeneratorImpl(this.abox, variableBinding, list);
    }

    private boolean ensureOrdering(List<BindingHelper> list, VariableBinding variableBinding) {
        ArrayList<BindingHelper> arrayList = new ArrayList<BindingHelper>();
        HashSet<AtomVariable> hashSet = new HashSet<AtomVariable>();
        ListIterator<BindingHelper> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            BindingHelper bindingHelper = listIterator.next();
            if (hashSet.containsAll(bindingHelper.getPrerequisiteVars(hashSet))) {
                hashSet.addAll(bindingHelper.getBindableVars(hashSet));
                ListIterator listIterator2 = arrayList.listIterator();
                while (listIterator2.hasNext()) {
                    BindingHelper bindingHelper2 = (BindingHelper)listIterator2.next();
                    if (!hashSet.containsAll(bindingHelper2.getPrerequisiteVars(hashSet))) continue;
                    listIterator.add(bindingHelper2);
                    hashSet.addAll(bindingHelper2.getBindableVars(hashSet));
                    listIterator2.remove();
                }
                continue;
            }
            arrayList.add(bindingHelper);
            listIterator.remove();
        }
        return arrayList.size() == 0;
    }

    private void optimize(List<BindingHelper> list) {
        HashSet<AtomVariable> hashSet = new HashSet<AtomVariable>();
        for (int i = 0; i < list.size(); ++i) {
            int n = 0;
            while (i + n < list.size()) {
                BindingHelper bindingHelper = list.get(i + n);
                if (hashSet.containsAll(bindingHelper.getBindableVars(hashSet)) && hashSet.containsAll(bindingHelper.getPrerequisiteVars(hashSet))) {
                    list.remove(i + n);
                    list.add(i, bindingHelper);
                    ++i;
                    continue;
                }
                ++n;
            }
            if (i >= list.size()) continue;
            hashSet.addAll(list.get(i).getBindableVars(hashSet));
        }
    }

    private class BodyAtomsToSelectiveHelpersVisitor
    extends DefaultRuleAtomVisitor {
        private List<BindingHelper> helpers = new ArrayList<BindingHelper>();

        private BodyAtomsToSelectiveHelpersVisitor() {
        }

        public List<BindingHelper> getHelpers() {
            return this.helpers;
        }

        @Override
        public void visit(BuiltInAtom builtInAtom) {
            BuiltIn builtIn = BuiltInRegistry.instance.getBuiltIn((String)builtInAtom.getPredicate());
            this.helpers.add(builtIn.createHelper(builtInAtom));
        }

        @Override
        public void visit(DataRangeAtom dataRangeAtom) {
            this.helpers.add(new DataRangeBindingHelper(BindingGeneratorStrategyImpl.this.abox, dataRangeAtom));
        }

        @Override
        public void visit(DatavaluedPropertyAtom datavaluedPropertyAtom) {
            this.helpers.add(new DatavaluePropertyBindingHelper(BindingGeneratorStrategyImpl.this.abox, datavaluedPropertyAtom));
        }
    }
}

