/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.el.GenericTaxonomyBuilder;
import com.clarkparsia.pellet.el.RoleRestrictionCache;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.CDOptimizedTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public abstract class RuleBasedELClassifier
extends CDOptimizedTaxonomyBuilder
implements TaxonomyBuilder {
    public static final Logger logger = Logger.getLogger(RuleBasedELClassifier.class.getName());
    protected Timers timers = new Timers();

    protected abstract void addSubclassRule(ATermAppl var1, ATermAppl var2);

    protected abstract void addRoleDomainRule(ATermAppl var1, ATermAppl var2);

    protected abstract void addRoleRangeRule(ATermAppl var1, ATermAppl var2);

    protected abstract void addRoleChainRule(ATerm[] var1, ATermAppl var2);

    protected abstract void addRoleHierarchyRule(ATermAppl var1, ATermAppl var2);

    protected abstract MultiValueMap<ATermAppl, ATermAppl> run(Collection<ATermAppl> var1);

    @Override
    public boolean classify() {
        this.reset();
        this.monitor.setProgressTitle("Classifiying");
        this.monitor.setProgressLength(this.classes.size());
        this.monitor.taskStarted();
        this.monitor.setProgress(0);
        logger.info("Creating structures");
        Timer timer = this.timers.startTimer("createConcepts");
        this.processAxioms();
        timer.stop();
        logger.info("Running rules");
        MultiValueMap<ATermAppl, ATermAppl> multiValueMap = this.run(this.kb.getAllClasses());
        this.monitor.setProgress(this.classes.size());
        logger.info("Building hierarchy");
        timer = this.timers.startTimer("buildHierarchy");
        this.buildTaxonomy(multiValueMap);
        timer.stop();
        this.monitor.setProgress(this.classes.size());
        this.monitor.taskFinished();
        return true;
    }

    protected void buildTaxonomy(MultiValueMap<ATermAppl, ATermAppl> multiValueMap) {
        this.taxonomy = new GenericTaxonomyBuilder().build(multiValueMap);
    }

    private void toELSubClassAxioms(ATermAppl aTermAppl) {
        AFun aFun = aTermAppl.getAFun();
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
        ATermAppl aTermAppl4 = ELSyntaxUtils.simplify(aTermAppl2);
        if (aFun.equals(ATermUtils.SUBFUN)) {
            if (ATermUtils.isPrimitive(aTermAppl3) || ATermUtils.isBottom(aTermAppl3)) {
                this.addSubclassRule(aTermAppl4, aTermAppl3);
                return;
            }
            ATermAppl aTermAppl5 = ELSyntaxUtils.simplify(aTermAppl3);
            this.addSubclassRule(aTermAppl4, aTermAppl5);
        } else if (aFun.equals(ATermUtils.EQCLASSFUN)) {
            ATermAppl aTermAppl6 = ELSyntaxUtils.simplify(aTermAppl3);
            this.addSubclassRule(aTermAppl4, aTermAppl6);
            this.addSubclassRule(aTermAppl6, aTermAppl4);
        } else {
            throw new IllegalArgumentException("Axiom " + aTermAppl + " is not EL.");
        }
    }

    private void processAxioms() {
        ATermAppl[] aTermApplArray;
        ATermList aTermList2;
        Collection<ATermAppl> collection = this.kb.getTBox().getAssertedAxioms();
        for (ATermAppl object : collection) {
            this.toELSubClassAxioms(object);
        }
        for (Role role : this.kb.getRBox().getRoles()) {
            ATermAppl aTermAppl = role.getName();
            aTermList2 = this.kb.getSuperProperties(aTermAppl).iterator();
            while (aTermList2.hasNext()) {
                aTermApplArray = aTermList2.next();
                for (ATermAppl aTermAppl2 : aTermApplArray) {
                    this.addRoleHierarchyRule(aTermAppl, aTermAppl2);
                }
            }
        }
        for (Role role : this.kb.getRBox().getRoles()) {
            for (ATermList aTermList2 : role.getSubRoleChains()) {
                aTermApplArray = ATermUtils.toArray(aTermList2);
                this.addRoleChainRule((ATerm[])aTermApplArray, role.getName());
            }
        }
        RoleRestrictionCache roleRestrictionCache = new RoleRestrictionCache(this.kb.getRBox());
        for (Map.Entry<ATermAppl, ATermAppl> entry : roleRestrictionCache.getDomains().entrySet()) {
            this.addRoleDomainRule(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ATermAppl, ATermAppl> entry : roleRestrictionCache.getRanges().entrySet()) {
            this.addRoleRangeRule(entry.getKey(), entry.getValue());
        }
        for (Role role : this.kb.getRBox().getRoles()) {
            if (!role.isReflexive() || (aTermList2 = roleRestrictionCache.getRange(role.getName())) == null) continue;
            this.addSubclassRule(ATermUtils.TOP, (ATermAppl)aTermList2);
        }
    }
}

