/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDUnsignedShort
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedShort instance;
    private static final int MAX_VALUE;

    public static XSDUnsignedShort getInstance() {
        return instance;
    }

    private XSDUnsignedShort() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedShort"), 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String string) throws InvalidLiteralException {
        try {
            int n = DatatypeConverter.parseInt(string);
            if (n < 0) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            if (n > MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    static {
        MAX_VALUE = 65535;
        instance = new XSDUnsignedShort();
    }
}

