/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDShort
extends AbstractDerivedIntegerType {
    private static final XSDShort instance = new XSDShort();

    public static XSDShort getInstance() {
        return instance;
    }

    private XSDShort() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#short"), (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String string) throws InvalidLiteralException {
        try {
            int n = DatatypeConverter.parseInt(string);
            if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return (short)n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }
}

