/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pellet.DatatypeConverter;

public class Rational
extends Number
implements Comparable<Rational> {
    private static final long serialVersionUID = 1L;
    private static final Pattern lexicalPattern;
    private final Number denominator;
    private final boolean exact;
    private final Number numerator;
    private final Number quotient;

    public static int compare(Rational rational, Rational rational2) {
        int n;
        int n2 = rational.signum();
        if (n2 == (n = rational2.signum())) {
            Number number;
            if (OWLRealUtils.compare(rational.getDenominator(), rational2.getDenominator()) == 0) {
                return OWLRealUtils.compare(rational.getNumerator(), rational2.getNumerator());
            }
            Number number2 = rational.getQuotient();
            int n3 = OWLRealUtils.compare(number2, number = rational2.getQuotient());
            if (n3 == 0) {
                if (rational.isQuotientExact() && rational2.isQuotientExact()) {
                    return 0;
                }
                BigInteger bigInteger = OWLRealUtils.bigInteger(rational.getNumerator()).multiply(OWLRealUtils.bigInteger(rational2.getDenominator()));
                BigInteger bigInteger2 = OWLRealUtils.bigInteger(rational2.getNumerator()).multiply(OWLRealUtils.bigInteger(rational.getDenominator()));
                return bigInteger.compareTo(bigInteger2);
            }
            return n3;
        }
        return n2 > n ? 1 : -1;
    }

    public static Rational valueOf(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        Matcher matcher = lexicalPattern.matcher(string);
        if (!matcher.matches()) {
            throw new NumberFormatException(string);
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        Number number = OWLRealUtils.getCanonicalObject(DatatypeConverter.parseInteger(string2 == null ? string3 : string2 + string3));
        Number number2 = OWLRealUtils.getCanonicalObject(DatatypeConverter.parseInteger(string4));
        if (OWLRealUtils.signum(number2) != 1) {
            throw new NumberFormatException(string);
        }
        return new Rational(number, number2);
    }

    public static Rational simplify(Rational rational) {
        BigInteger bigInteger = OWLRealUtils.bigInteger(rational.getNumerator());
        BigInteger bigInteger2 = OWLRealUtils.bigInteger(rational.getDenominator());
        BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
        while (!bigInteger3.equals(BigInteger.ONE)) {
            bigInteger = bigInteger.divide(bigInteger3);
            bigInteger2 = bigInteger2.divide(bigInteger3);
            bigInteger3 = bigInteger.gcd(bigInteger2);
        }
        Number number = OWLRealUtils.getCanonicalObject(bigInteger);
        Number number2 = OWLRealUtils.getCanonicalObject(bigInteger2);
        if (number.equals(rational.getNumerator()) && number2.equals(rational.getDenominator())) {
            return rational;
        }
        return new Rational(number, number2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DatatypeConverter.printInteger(OWLRealUtils.bigInteger(this.numerator)));
        stringBuffer.append(" / ");
        stringBuffer.append(DatatypeConverter.printInteger(OWLRealUtils.bigInteger(this.denominator)));
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.denominator == null ? 0 : this.denominator.hashCode());
        n = 31 * n + (this.numerator == null ? 0 : this.numerator.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Rational rational = (Rational)object;
        if (this.denominator == null ? rational.denominator != null : !this.denominator.equals(rational.denominator)) {
            return false;
        }
        return !(this.numerator == null ? rational.numerator != null : !this.numerator.equals(rational.numerator));
    }

    public Rational(Number number, Number number2) {
        boolean bl;
        BigDecimal bigDecimal;
        if (number == null) {
            throw new NullPointerException();
        }
        if (!OWLRealUtils.isInteger(number)) {
            throw new IllegalArgumentException();
        }
        if (number2 == null) {
            throw new NullPointerException();
        }
        if (OWLRealUtils.signum(number2) <= 0) {
            throw new IllegalArgumentException();
        }
        if (!OWLRealUtils.isInteger(number2)) {
            throw new IllegalArgumentException();
        }
        this.numerator = number;
        this.denominator = number2;
        BigDecimal bigDecimal2 = OWLRealUtils.bigDecimal(number);
        BigDecimal bigDecimal3 = OWLRealUtils.bigDecimal(number2);
        try {
            bigDecimal = bigDecimal2.divide(bigDecimal3);
            bl = true;
        }
        catch (ArithmeticException arithmeticException) {
            bigDecimal = bigDecimal2.divide(bigDecimal3, MathContext.DECIMAL32);
            bl = false;
        }
        this.quotient = bigDecimal;
        this.exact = bl;
    }

    @Override
    public int compareTo(Rational rational) {
        return Rational.compare(this, rational);
    }

    @Override
    public double doubleValue() {
        return this.quotient.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.quotient.floatValue();
    }

    public Number getDenominator() {
        return this.denominator;
    }

    public Number getNumerator() {
        return this.numerator;
    }

    public Number getQuotient() {
        return this.quotient;
    }

    @Override
    public int intValue() {
        return this.quotient.intValue();
    }

    public boolean isQuotientExact() {
        return this.exact;
    }

    @Override
    public long longValue() {
        return this.quotient.longValue();
    }

    public int signum() {
        return OWLRealUtils.signum(this.numerator);
    }

    static {
        String string = "\\s*([+-])?\\s*(\\d+)\\s*/\\s*(\\d+)\\s*";
        lexicalPattern = Pattern.compile(string);
    }
}

