/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.floating;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.floating.IEEEFloatType;
import com.clarkparsia.pellet.datatypes.types.floating.RestrictedFloatingPointDatatype;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDFloat
extends AbstractBaseDatatype<Float> {
    private static final XSDFloat instance = new XSDFloat();
    private final RestrictedFloatingPointDatatype<Float> dataRange = new RestrictedFloatingPointDatatype<Float>(this, IEEEFloatType.getInstance());

    public static XSDFloat getInstance() {
        return instance;
    }

    private XSDFloat() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#float"));
    }

    @Override
    public RestrictedDatatype<Float> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        Float f = this.getValue(aTermAppl);
        String string = DatatypeConverter.printFloat(f.floatValue());
        if (string.equals(ATermUtils.getLiteralValue(aTermAppl))) {
            return aTermAppl;
        }
        return ATermUtils.makeTypedLiteral(string, this.getName());
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        if (object instanceof Float) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printFloat(((Float)object).floatValue()), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Float getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        try {
            return Float.valueOf(DatatypeConverter.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

