/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import java.math.BigInteger;

public class FloatingPointUtils {
    private static final long DOUBLE_MAGNITUDE_MASK = Long.MAX_VALUE;
    private static final long DOUBLE_NEGATIVE_ZERO_BITS = Long.MIN_VALUE;
    private static final long DOUBLE_POSITIVE_ZERO_BITS = 0L;
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final int FLOAT_MAGNITUDE_MASK = Integer.MAX_VALUE;
    private static final int FLOAT_NEGATIVE_ZERO_BITS = Integer.MIN_VALUE;
    private static final int FLOAT_POSITIVE_ZERO_BITS = 0;
    private static final int FLOAT_SIGN_MASK = Integer.MIN_VALUE;

    public static Double decrement(Double d) {
        if (d.isNaN() || d.isInfinite()) {
            return d;
        }
        long l = Double.doubleToRawLongBits(d);
        if (l == 0L) {
            return Double.longBitsToDouble(Long.MIN_VALUE);
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return Double.longBitsToDouble(l - 1L);
        }
        return Double.longBitsToDouble(l + 1L);
    }

    public static Float decrement(Float f) {
        if (f.isNaN() || f.isInfinite()) {
            return f;
        }
        int n = Float.floatToRawIntBits(f.floatValue());
        if (n == 0) {
            return Float.valueOf(Float.intBitsToFloat(Integer.MIN_VALUE));
        }
        if ((n & Integer.MIN_VALUE) == 0) {
            return Float.valueOf(Float.intBitsToFloat(n - 1));
        }
        return Float.valueOf(Float.intBitsToFloat(n + 1));
    }

    public static Double increment(Double d) {
        if (d.isNaN() || d.isInfinite()) {
            return d;
        }
        long l = Double.doubleToRawLongBits(d);
        if (l == Long.MIN_VALUE) {
            return Double.longBitsToDouble(0L);
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return Double.longBitsToDouble(l + 1L);
        }
        return Double.longBitsToDouble(l - 1L);
    }

    public static Float increment(Float f) {
        if (f.isNaN() || f.isInfinite()) {
            return f;
        }
        int n = Float.floatToRawIntBits(f.floatValue());
        if (n == Integer.MIN_VALUE) {
            return Float.valueOf(Float.intBitsToFloat(0));
        }
        if ((n & Integer.MIN_VALUE) == 0) {
            return Float.valueOf(Float.intBitsToFloat(n + 1));
        }
        return Float.valueOf(Float.intBitsToFloat(n - 1));
    }

    public static BigInteger intervalSize(Double d, Double d2) {
        if (d.isNaN()) {
            throw new IllegalArgumentException();
        }
        if (d2.isNaN()) {
            throw new IllegalArgumentException();
        }
        long l = Double.doubleToRawLongBits(d);
        long l2 = Double.doubleToRawLongBits(d2);
        if ((Long.MIN_VALUE & l) == Long.MIN_VALUE) {
            if ((Long.MIN_VALUE & l2) == Long.MIN_VALUE) {
                return BigInteger.valueOf((Long.MAX_VALUE & l) - (Long.MAX_VALUE & l2) + 1L);
            }
            return BigInteger.valueOf(Long.MAX_VALUE & l).add(BigInteger.valueOf(Long.MAX_VALUE & l2)).add(BigInteger.valueOf(2L));
        }
        return BigInteger.valueOf((Long.MAX_VALUE & l2) - (Long.MAX_VALUE & l) + 1L);
    }

    public static long intervalSize(Float f, Float f2) {
        if (f.isNaN()) {
            throw new IllegalArgumentException();
        }
        if (f2.isNaN()) {
            throw new IllegalArgumentException();
        }
        int n = Float.floatToRawIntBits(f.floatValue());
        int n2 = Float.floatToRawIntBits(f2.floatValue());
        if ((Integer.MIN_VALUE & n) == Integer.MIN_VALUE) {
            if ((Integer.MIN_VALUE & n2) == Integer.MIN_VALUE) {
                return (Integer.MAX_VALUE & n) - (Integer.MAX_VALUE & n2) + 1;
            }
            return (long)(Integer.MAX_VALUE & n) + (long)(Integer.MAX_VALUE & n2) + 2L;
        }
        return (Integer.MAX_VALUE & n2) - (Integer.MAX_VALUE & n) + 1;
    }
}

