/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import aterm.ATermAppl;
import com.clarkparsia.modularity.EntailmentChecker;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.ModuleExtractorFactory;
import com.clarkparsia.modularity.OntologyDiff;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.PelletRuntimeException;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.exceptions.TimerInterruptedException;
import org.mindswap.pellet.exceptions.UndefinedEntityException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.mindswap.pellet.taxonomy.printer.TreeTaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.PartialOrderBuilder;
import org.mindswap.pellet.utils.PartialOrderComparator;
import org.mindswap.pellet.utils.PartialOrderRelation;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.NodeFactory;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.util.Version;

public class IncrementalClassifier
implements OWLReasoner,
OWLOntologyChangeListener {
    public static final Logger log = Logger.getLogger(IncrementalClassifier.class.getName());
    private MultiValueMap<OWLEntity, OWLEntity> modules = null;
    private final PelletReasoner reasoner;
    private ModuleExtractor extractor = ModuleExtractorFactory.createModuleExtractor();
    private Taxonomy<OWLClass> taxonomy = null;
    private boolean multiThreaded = true;
    public Timers timers = this.extractor.getTimers();
    private final Random RND = new Random();
    private boolean realized = false;
    private static final ATermAppl OWL_THING = ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#Thing");
    private static final ATermAppl OWL_NOTHING = ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#Nothing");

    public IncrementalClassifier(OWLOntology oWLOntology) {
        this(PelletReasonerFactory.getInstance().createReasoner(oWLOntology), ModuleExtractorFactory.createModuleExtractor());
    }

    public IncrementalClassifier(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) {
        this(PelletReasonerFactory.getInstance().createReasoner(oWLOntology, oWLReasonerConfiguration), ModuleExtractorFactory.createModuleExtractor());
    }

    public IncrementalClassifier(OWLOntology oWLOntology, ModuleExtractor moduleExtractor) {
        this(PelletReasonerFactory.getInstance().createReasoner(oWLOntology), moduleExtractor);
    }

    public IncrementalClassifier(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration, ModuleExtractor moduleExtractor) {
        this(PelletReasonerFactory.getInstance().createReasoner(oWLOntology, oWLReasonerConfiguration), moduleExtractor);
    }

    public IncrementalClassifier(PelletReasoner pelletReasoner) {
        this(pelletReasoner, ModuleExtractorFactory.createModuleExtractor());
    }

    public IncrementalClassifier(PelletReasoner pelletReasoner, ModuleExtractor moduleExtractor) {
        this.reasoner = pelletReasoner;
        this.extractor = moduleExtractor;
        OWLOntology oWLOntology = pelletReasoner.getRootOntology();
        for (OWLOntology oWLOntology2 : oWLOntology.getImportsClosure()) {
            moduleExtractor.addOntology(oWLOntology2);
        }
        pelletReasoner.getManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public IncrementalClassifier(PersistedState persistedState) {
        this.extractor = persistedState.getModuleExtractor();
        this.taxonomy = persistedState.getTaxonomy();
        this.realized = persistedState.isRealized();
        this.modules = this.extractor.getModules();
        OWLOntology oWLOntology = this.extractor.getAxiomOntology();
        this.reasoner = PelletReasonerFactory.getInstance().createReasoner(oWLOntology);
        this.reasoner.getManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public IncrementalClassifier(PersistedState persistedState, OWLOntology oWLOntology) {
        this.reasoner = PelletReasonerFactory.getInstance().createReasoner(oWLOntology);
        this.extractor = persistedState.getModuleExtractor();
        this.taxonomy = persistedState.getTaxonomy();
        this.realized = persistedState.isRealized();
        this.modules = this.extractor.getModules();
        OntologyDiff ontologyDiff = OntologyDiff.diffAxiomsWithOntologies(this.extractor.getAxioms(), Collections.singleton(oWLOntology));
        if (!ontologyDiff.areSame()) {
            for (OWLAxiom oWLAxiom : ontologyDiff.getAdditions()) {
                this.extractor.addAxiom(oWLAxiom);
            }
            for (OWLAxiom oWLAxiom : ontologyDiff.getDeletions()) {
                this.extractor.deleteAxiom(oWLAxiom);
            }
        }
        this.reasoner.getManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public Collection<OWLAxiom> getAxioms() {
        return this.extractor.getAxioms();
    }

    public static Taxonomy<OWLClass> buildClassHierarchy(PelletReasoner pelletReasoner) {
        Taxonomy<OWLClass> taxonomy = new Taxonomy<OWLClass>(null, OWL.Thing, OWL.Nothing);
        Set set = pelletReasoner.getEquivalentClasses((OWLClassExpression)OWL.Thing).getEntities();
        set.remove(OWL.Thing);
        if (!set.isEmpty()) {
            taxonomy.addEquivalents(OWL.Thing, set);
        }
        Set set2 = pelletReasoner.getEquivalentClasses((OWLClassExpression)OWL.Nothing).getEntities();
        set2.remove(OWL.Nothing);
        if (!set2.isEmpty()) {
            taxonomy.addEquivalents(OWL.Nothing, set2);
        }
        for (Node node : pelletReasoner.getSubClasses((OWLClassExpression)OWL.Thing, true)) {
            IncrementalClassifier.recursiveBuild(taxonomy, (Node<OWLClass>)node, pelletReasoner);
        }
        return taxonomy;
    }

    private static void recursiveBuild(Taxonomy<OWLClass> taxonomy, Node<OWLClass> node, PelletReasoner pelletReasoner) {
        assert (!node.getEntities().isEmpty()) : "Equivalents empty as passed";
        OWLClass oWLClass = (OWLClass)node.iterator().next();
        if (taxonomy.contains(oWLClass)) {
            return;
        }
        Set set = Collections.emptySet();
        taxonomy.addNode(node.getEntities(), set, set, false);
        for (Node node2 : pelletReasoner.getSubClasses((OWLClassExpression)oWLClass, true)) {
            IncrementalClassifier.recursiveBuild(taxonomy, (Node<OWLClass>)node2, pelletReasoner);
            taxonomy.addSuper((OWLClass)node2.iterator().next(), oWLClass);
        }
    }

    public void classify() {
        if (this.isClassified()) {
            if (this.extractor.isChanged()) {
                this.extractor.updateModules(this.taxonomy, true);
                this.extractor.updateModules(this.taxonomy, false);
            }
            return;
        }
        if (this.extractor.canUpdate()) {
            this.incrementalClassify();
        } else {
            this.regularClassify();
        }
        this.resetRealization();
    }

    public void dispose() {
        this.reasoner.dispose();
        this.reasoner.getManager().removeOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression oWLClassExpression) {
        if (oWLClassExpression.isAnonymous()) {
            throw new IllegalArgumentException("This reasoner only supports named classes");
        }
        this.classify();
        return NodeFactory.getOWLClassNode(this.taxonomy.getAllEquivalents((OWLClass)oWLClassExpression));
    }

    public MultiValueMap<OWLEntity, OWLEntity> getModules() {
        return this.modules;
    }

    public PelletReasoner getReasoner() {
        return this.reasoner;
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression oWLClassExpression, boolean bl) {
        if (oWLClassExpression.isAnonymous()) {
            throw new UnsupportedOperationException("This reasoner only supports named classes");
        }
        this.classify();
        HashSet<DefaultNode> hashSet = new HashSet<DefaultNode>();
        for (Set<OWLClass> set : this.taxonomy.getSubs((OWLClass)oWLClassExpression, bl)) {
            hashSet.add(NodeFactory.getOWLClassNode(set));
        }
        return new OWLClassNodeSet(hashSet);
    }

    private void incClassifyAllModStrategy() {
        HashSet<OWLEntity> hashSet = new HashSet<OWLEntity>();
        hashSet.addAll(this.extractor.updateModules(this.taxonomy, true));
        hashSet.addAll(this.extractor.updateModules(this.taxonomy, false));
        if (log.isLoggable(Level.FINE)) {
            log.fine("Module entities " + hashSet);
        }
        OWLOntology oWLOntology = this.extractor.getModuleFromSignature(hashSet);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Module axioms " + oWLOntology.getLogicalAxioms());
        }
        PelletReasoner pelletReasoner = PelletReasonerFactory.getInstance().createReasoner(oWLOntology);
        pelletReasoner.getKB().classify();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Classified module:");
            new ClassTreePrinter().print(pelletReasoner.getKB().getTaxonomy(), new PrintWriter(System.err));
        }
        Taxonomy<OWLClass> taxonomy = IncrementalClassifier.buildClassHierarchy(pelletReasoner);
        HashSet<OWLClass> hashSet2 = new HashSet<OWLClass>();
        for (OWLEntity oWLEntity : hashSet) {
            if (!(oWLEntity instanceof OWLClass)) continue;
            hashSet2.add((OWLClass)oWLEntity);
        }
        this.taxonomy = this.updateClassHierarchy(this.taxonomy, taxonomy, hashSet2);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Updated taxonomy:");
            new TreeTaxonomyPrinter<OWLClass>().print(this.taxonomy, new PrintWriter(System.err));
        }
        OntologyUtils.getOWLOntologyManager().removeOntology(oWLOntology);
    }

    private void incrementalClassify() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Incremental classification starting");
        }
        Timer timer = this.timers.startTimer("incrementalClassify");
        this.incClassifyAllModStrategy();
        timer.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Incremental classification done");
        }
    }

    public boolean isClassified() {
        return this.modules != null && (!this.extractor.isChanged() || !this.extractor.isClassificationNeeded(this.reasoner.getKB().getExpressivity()));
    }

    public boolean isRealized() {
        return this.isClassified() && this.realized;
    }

    public boolean isDefined(OWLClass oWLClass) {
        return !this.extractor.getAxioms((OWLEntity)oWLClass).isEmpty();
    }

    public boolean isDefined(OWLDataProperty oWLDataProperty) {
        return !this.extractor.getAxioms((OWLEntity)oWLDataProperty).isEmpty();
    }

    public boolean isDefined(OWLNamedIndividual oWLNamedIndividual) {
        return !this.extractor.getAxioms((OWLEntity)oWLNamedIndividual).isEmpty();
    }

    public boolean isDefined(OWLObjectProperty oWLObjectProperty) {
        return !this.extractor.getAxioms((OWLEntity)oWLObjectProperty).isEmpty();
    }

    public boolean isEquivalentClass(OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2) {
        if (oWLClassExpression.isAnonymous() || oWLClassExpression2.isAnonymous()) {
            throw new UnsupportedOperationException("This reasoner only supports named classes");
        }
        this.classify();
        return this.taxonomy.isEquivalent((OWLClass)oWLClassExpression, (OWLClass)oWLClassExpression2) == Bool.TRUE;
    }

    public boolean isSatisfiable(OWLClassExpression oWLClassExpression) {
        if (oWLClassExpression.isAnonymous() || !this.isClassified()) {
            return this.reasoner.isSatisfiable(oWLClassExpression);
        }
        return !this.getUnsatisfiableClasses().contains((OWLObject)((OWLClass)oWLClassExpression));
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> list) throws OWLException {
        if (!this.getRootOntology().getOWLOntologyManager().contains(this.getRootOntology().getOntologyID())) {
            return;
        }
        Set set = this.getRootOntology().getImportsClosure();
        for (OWLOntologyChange oWLOntologyChange : list) {
            if (!oWLOntologyChange.isAxiomChange() || !set.contains(oWLOntologyChange.getOntology())) continue;
            this.resetRealization();
            OWLAxiom oWLAxiom = oWLOntologyChange.getAxiom();
            if (oWLOntologyChange instanceof AddAxiom) {
                this.extractor.addAxiom(oWLAxiom);
                continue;
            }
            if (oWLOntologyChange instanceof RemoveAxiom) {
                this.extractor.deleteAxiom(oWLAxiom);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized axiom change: " + oWLOntologyChange);
        }
    }

    private void regularClassify() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Regular classification starting");
        }
        Thread thread = new Thread("classification"){

            @Override
            public void run() {
                Timer timer = IncrementalClassifier.this.timers.startTimer("reasonerClassify");
                IncrementalClassifier.this.reasoner.flush();
                IncrementalClassifier.this.reasoner.getKB().classify();
                timer.stop();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Regular taxonomy:");
                    new TreeTaxonomyPrinter<ATermAppl>().print(IncrementalClassifier.this.reasoner.getKB().getTaxonomy(), new PrintWriter(System.err));
                }
                timer = IncrementalClassifier.this.timers.startTimer("buildClassHierarchy");
                IncrementalClassifier.this.taxonomy = IncrementalClassifier.buildClassHierarchy(IncrementalClassifier.this.reasoner);
                timer.stop();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Copied taxonomy:");
                    new TreeTaxonomyPrinter().print(IncrementalClassifier.this.taxonomy, new PrintWriter(System.err));
                }
            }
        };
        Thread thread2 = new Thread("partitioning"){

            @Override
            public void run() {
                IncrementalClassifier.this.modules = IncrementalClassifier.this.extractor.extractModules();
            }
        };
        try {
            Timer timer = this.timers.startTimer("regularClassify");
            if (this.multiThreaded) {
                thread.start();
                thread2.start();
                thread.join();
                thread2.join();
            } else {
                thread.run();
                thread2.run();
            }
            timer.stop();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Regular classification done");
        }
    }

    private Taxonomy<OWLClass> updateClassHierarchy(Taxonomy<OWLClass> taxonomy, Taxonomy<OWLClass> taxonomy2, Set<OWLClass> set) {
        HashSet<OWLClass> hashSet = new HashSet<OWLClass>(taxonomy2.getClasses());
        hashSet.remove(OWL.Thing);
        hashSet.remove(OWL.Nothing);
        assert (set.containsAll(hashSet)) : "Unaffected nodes in changed taxonomy";
        HashSet<OWLClass> hashSet2 = new HashSet<OWLClass>(set);
        hashSet2.removeAll(taxonomy2.getClasses());
        List<OWLClass> list = taxonomy.topologocialSort(false);
        Set set2 = Collections.emptySet();
        for (OWLClass object : list) {
            if (hashSet2.contains(object) || taxonomy2.contains(object)) continue;
            taxonomy2.addNode(taxonomy.getAllEquivalents(object), set2, set2, false);
            Set<OWLClass> set3 = taxonomy.getFlattenedSupers(object, true);
            set3.removeAll(hashSet2);
            taxonomy2.addSupers(object, set3);
        }
        ArrayList arrayList = new ArrayList();
        for (OWLClass oWLClass : taxonomy.getEquivalents(OWL.Nothing)) {
            if (hashSet2.contains(oWLClass) || taxonomy2.contains(oWLClass)) continue;
            arrayList.add(oWLClass);
        }
        if (!arrayList.isEmpty()) {
            taxonomy2.addEquivalents(OWL.Nothing, arrayList);
        }
        return taxonomy2;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(boolean bl) {
        this.multiThreaded = bl;
    }

    public void flush() {
        this.reasoner.flush();
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)OWL.Nothing);
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.getEquivalentDataProperties(OWL.bottomDataProperty);
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)OWL.bottomObjectProperty);
    }

    public BufferingMode getBufferingMode() {
        return BufferingMode.NON_BUFFERING;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getDataPropertyDomains(oWLDataProperty, bl);
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLDataProperty oWLDataProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getDataPropertyValues(oWLNamedIndividual, oWLDataProperty);
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual oWLNamedIndividual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getDifferentIndividuals(oWLNamedIndividual);
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression oWLClassExpression) {
        Object object;
        DisjointClassComparator disjointClassComparator = new DisjointClassComparator(this.taxonomy, oWLClassExpression);
        if (!this.taxonomy.contains(disjointClassComparator.getComplementRepresentation())) {
            this.reasoner.flush();
            object = new PartialOrderBuilder<OWLClass>(this.taxonomy, disjointClassComparator);
            ((PartialOrderBuilder)object).add(disjointClassComparator.getComplementRepresentation(), true);
        }
        object = new OWLClassNodeSet();
        for (Set<OWLClass> set : this.taxonomy.getSubs(disjointClassComparator.getComplementRepresentation(), false)) {
            object.addSameEntities(set);
        }
        return object;
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression oWLDataPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getDisjointDataProperties(oWLDataPropertyExpression);
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getDisjointObjectProperties(oWLObjectPropertyExpression);
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty oWLDataProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getEquivalentDataProperties(oWLDataProperty);
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getEquivalentObjectProperties(oWLObjectPropertyExpression);
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.reasoner.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.reasoner.getIndividualNodeSetPolicy();
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetBySameAs(Collection<OWLNamedIndividual> collection) {
        HashSet<Node<OWLNamedIndividual>> hashSet = new HashSet<Node<OWLNamedIndividual>>();
        HashSet hashSet2 = new HashSet();
        for (OWLNamedIndividual oWLNamedIndividual : collection) {
            if (hashSet2.contains(oWLNamedIndividual)) continue;
            Node<OWLNamedIndividual> node = this.reasoner.getSameIndividuals(oWLNamedIndividual);
            hashSet.add(node);
            hashSet2.addAll(node.getEntities());
        }
        return new OWLNamedIndividualNodeSet(hashSet);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetByName(Collection<OWLNamedIndividual> collection) {
        HashSet<OWLNamedIndividualNode> hashSet = new HashSet<OWLNamedIndividualNode>();
        for (OWLNamedIndividual oWLNamedIndividual : collection) {
            for (OWLNamedIndividual oWLNamedIndividual2 : this.reasoner.getSameIndividuals(oWLNamedIndividual)) {
                hashSet.add(new OWLNamedIndividualNode(oWLNamedIndividual2));
            }
        }
        return new OWLNamedIndividualNodeSet(hashSet);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSet(Collection<OWLNamedIndividual> collection) {
        if (IndividualNodeSetPolicy.BY_NAME.equals((Object)this.getIndividualNodeSetPolicy())) {
            return this.getIndividualNodeSetByName(collection);
        }
        if (IndividualNodeSetPolicy.BY_SAME_AS.equals((Object)this.getIndividualNodeSetPolicy())) {
            return this.getIndividualNodeSetBySameAs(collection);
        }
        throw new AssertionError((Object)("Unsupported IndividualNodeSetPolicy : " + this.getIndividualNodeSetPolicy()));
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression oWLClassExpression, boolean bl) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (oWLClassExpression.isAnonymous() && bl) {
            throw new UnsupportedOperationException("This reasoner only supports named classes");
        }
        this.reasoner.flush();
        if (!this.isRealized() && !bl) {
            return this.reasoner.getInstances(oWLClassExpression, bl);
        }
        this.realize();
        Set<OWLNamedIndividual> set = bl ? TaxonomyUtils.getDirectInstances(this.taxonomy, (OWLClass)oWLClassExpression) : TaxonomyUtils.getAllInstances(this.taxonomy, (OWLClass)oWLClassExpression);
        return this.getIndividualNodeSet(set);
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getInverseObjectProperties(oWLObjectPropertyExpression);
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getObjectPropertyDomains(oWLObjectPropertyExpression, bl);
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getObjectPropertyRanges(oWLObjectPropertyExpression, bl);
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getObjectPropertyValues(oWLNamedIndividual, oWLObjectPropertyExpression);
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return Collections.emptySet();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return Collections.emptySet();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return Collections.emptyList();
    }

    public String getReasonerName() {
        return "Pellet (Incremental)";
    }

    public Version getReasonerVersion() {
        return this.reasoner.getReasonerVersion();
    }

    public OWLOntology getRootOntology() {
        return this.reasoner.getRootOntology();
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual oWLNamedIndividual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getSameIndividuals(oWLNamedIndividual);
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getSubDataProperties(oWLDataProperty, bl);
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getSubObjectProperties(oWLObjectPropertyExpression, bl);
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression oWLClassExpression, boolean bl) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (oWLClassExpression.isAnonymous()) {
            throw new UnsupportedOperationException("This reasoner only supports named classes");
        }
        this.classify();
        HashSet<DefaultNode> hashSet = new HashSet<DefaultNode>();
        for (Set<OWLClass> set : this.taxonomy.getSupers((OWLClass)oWLClassExpression, bl)) {
            hashSet.add(NodeFactory.getOWLClassNode(set));
        }
        return new OWLClassNodeSet(hashSet);
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getSuperDataProperties(oWLDataProperty, bl);
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getSuperObjectProperties(oWLObjectPropertyExpression, bl);
    }

    public long getTimeOut() {
        return this.reasoner.getTimeOut();
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)OWL.Thing);
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return this.getEquivalentDataProperties(OWL.topDataProperty);
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)OWL.topObjectProperty);
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual oWLNamedIndividual, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        this.realize();
        OWLClassNodeSet oWLClassNodeSet = new OWLClassNodeSet();
        for (Set<OWLClass> set : TaxonomyUtils.getTypes(this.taxonomy, oWLNamedIndividual, bl)) {
            oWLClassNodeSet.addNode((Node)new OWLClassNode(set));
        }
        return oWLClassNodeSet;
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        this.classify();
        return this.getBottomClassNode();
    }

    public void interrupt() {
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.isConsistent();
    }

    public boolean isEntailed(OWLAxiom oWLAxiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        try {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            return entailmentChecker.isEntailed(oWLAxiom);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public boolean isEntailed(Set<? extends OWLAxiom> set) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        try {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            return entailmentChecker.isEntailed(set);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    private PelletRuntimeException convert(PelletRuntimeException pelletRuntimeException) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException, FreshEntitiesException {
        if (pelletRuntimeException instanceof TimeoutException) {
            throw new TimeOutException();
        }
        if (pelletRuntimeException instanceof TimerInterruptedException) {
            throw new ReasonerInterruptedException((Throwable)pelletRuntimeException);
        }
        if (pelletRuntimeException instanceof org.mindswap.pellet.exceptions.InconsistentOntologyException) {
            throw new InconsistentOntologyException();
        }
        if (pelletRuntimeException instanceof UndefinedEntityException) {
            Set set = Collections.emptySet();
            throw new FreshEntitiesException(set);
        }
        return pelletRuntimeException;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return this.getReasoner().isEntailmentCheckingSupported(axiomType);
    }

    public void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.classify();
    }

    public Taxonomy<OWLClass> getTaxonomy() {
        return this.taxonomy;
    }

    private void resetRealization() {
        if (this.taxonomy != null) {
            for (TaxonomyNode<OWLClass> taxonomyNode : this.taxonomy.getNodes()) {
                taxonomyNode.removeDatum(TaxonomyUtils.INSTANCES_KEY);
            }
        }
        this.realized = false;
    }

    private void realize() {
        if (this.isRealized()) {
            return;
        }
        Set<ATermAppl> set = this.reasoner.getKB().getIndividuals();
        HashSet<OWLClass> hashSet = new HashSet<OWLClass>();
        if (!set.isEmpty()) {
            this.realizeByConcept(ATermUtils.TOP, set, this.reasoner.getManager().getOWLDataFactory(), hashSet);
        }
        this.realized = true;
    }

    private Set<ATermAppl> realizeByConcept(ATermAppl aTermAppl, Collection<ATermAppl> collection, OWLDataFactory oWLDataFactory, Set<OWLClass> set) {
        OWLClass oWLClass;
        if (aTermAppl.equals(ATermUtils.BOTTOM)) {
            return SetUtils.emptySet();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Realizing concept " + aTermAppl);
        }
        if (set.contains(oWLClass = this.termToOWLClass(aTermAppl, oWLDataFactory))) {
            return TaxonomyUtils.getAllInstances(this.taxonomy, oWLClass);
        }
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(this.reasoner.getKB().retrieve(aTermAppl, collection));
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>(hashSet);
        if (!hashSet.isEmpty()) {
            TaxonomyNode<OWLClass> taxonomyNode = this.taxonomy.getNode(oWLClass);
            if (taxonomyNode == null) {
                System.out.println(" no node for " + aTermAppl);
            }
            for (TaxonomyNode<OWLClass> taxonomyNode2 : taxonomyNode.getSubs()) {
                OWLClass oWLClass2 = taxonomyNode2.getName();
                Set<ATermAppl> set2 = this.realizeByConcept(this.owlClassToTerm(oWLClass2), hashSet, oWLDataFactory, set);
                if (set2 == null) {
                    return null;
                }
                hashSet2.removeAll(set2);
            }
            if (!hashSet2.isEmpty()) {
                taxonomyNode.putDatum(TaxonomyUtils.INSTANCES_KEY, this.toOWLNamedIndividuals(hashSet2, oWLDataFactory));
            }
        }
        return hashSet;
    }

    private Set<OWLNamedIndividual> toOWLNamedIndividuals(Set<ATermAppl> set, OWLDataFactory oWLDataFactory) {
        HashSet<OWLNamedIndividual> hashSet = new HashSet<OWLNamedIndividual>();
        for (ATermAppl aTermAppl : set) {
            OWLNamedIndividual oWLNamedIndividual = this.termToOWLNamedIndividual(aTermAppl, oWLDataFactory);
            if (oWLNamedIndividual == null) continue;
            hashSet.add(oWLNamedIndividual);
        }
        return hashSet;
    }

    private OWLClass termToOWLClass(ATermAppl aTermAppl, OWLDataFactory oWLDataFactory) {
        if (aTermAppl.equals(ATermUtils.TOP)) {
            return oWLDataFactory.getOWLThing();
        }
        if (aTermAppl.equals(OWL_THING)) {
            return oWLDataFactory.getOWLThing();
        }
        if (aTermAppl.equals(OWL_NOTHING)) {
            return oWLDataFactory.getOWLNothing();
        }
        if (!ATermUtils.isBnode(aTermAppl)) {
            return oWLDataFactory.getOWLClass(IRI.create((String)aTermAppl.getName()));
        }
        return null;
    }

    private OWLNamedIndividual termToOWLNamedIndividual(ATermAppl aTermAppl, OWLDataFactory oWLDataFactory) {
        if (!ATermUtils.isBnode(aTermAppl)) {
            return oWLDataFactory.getOWLNamedIndividual(IRI.create((String)aTermAppl.getName()));
        }
        return null;
    }

    private ATermAppl owlClassToTerm(OWLClass oWLClass) {
        if (oWLClass.isOWLThing()) {
            return ATermUtils.TOP;
        }
        if (oWLClass.isOWLNothing()) {
            return ATermUtils.BOTTOM;
        }
        return ATermUtils.makeTermAppl(oWLClass.getIRI().toString());
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return this.reasoner.getPrecomputableInferenceTypes();
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        switch (inferenceType) {
            case CLASS_HIERARCHY: {
                return this.isClassified();
            }
            case CLASS_ASSERTIONS: {
                return this.isRealized();
            }
        }
        return this.reasoner.isPrecomputed(inferenceType);
    }

    public void precomputeInferences(InferenceType ... inferenceTypeArray) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        for (InferenceType inferenceType : inferenceTypeArray) {
            switch (inferenceType) {
                case CLASS_HIERARCHY: {
                    this.classify();
                }
                case CLASS_ASSERTIONS: {
                    this.realize();
                }
            }
            this.reasoner.precomputeInferences(inferenceTypeArray);
        }
    }

    public class DisjointClassComparator
    implements PartialOrderComparator<OWLClass> {
        private static final String ANONYMOUS_COMPLEMENT_REPRESENTATION_BASE = "http://clarkparsia.com/pellet/complement/";
        private static final String COMPLEMENT_POSTFIX = "-complement";
        private final OWLClassExpression complementClass;
        private final OWLClass complementRepresentation;

        public DisjointClassComparator(Taxonomy<OWLClass> taxonomy, OWLClassExpression oWLClassExpression) {
            this.complementClass = OWL.factory.getOWLObjectComplementOf(oWLClassExpression);
            this.complementRepresentation = this.generateComplementRepresentation(taxonomy, oWLClassExpression);
        }

        private OWLClass generateComplementRepresentation(Taxonomy<OWLClass> taxonomy, OWLClassExpression oWLClassExpression) {
            OWLClass oWLClass = null;
            if (!oWLClassExpression.isAnonymous() && oWLClassExpression instanceof OWLClass) {
                return OWL.factory.getOWLClass(IRI.create((String)(((OWLClass)oWLClassExpression).getIRI() + COMPLEMENT_POSTFIX)));
            }
            while (taxonomy.contains(oWLClass = OWL.factory.getOWLClass(IRI.create((String)(ANONYMOUS_COMPLEMENT_REPRESENTATION_BASE + IncrementalClassifier.this.RND.nextLong()))))) {
            }
            return oWLClass;
        }

        public OWLClass getComplementRepresentation() {
            return this.complementRepresentation;
        }

        @Override
        public PartialOrderRelation compare(OWLClass oWLClass, OWLClass oWLClass2) {
            OWLClass oWLClass3 = oWLClass;
            OWLClass oWLClass4 = oWLClass2;
            if (oWLClass.equals(this.complementRepresentation)) {
                oWLClass3 = this.complementClass;
            }
            if (oWLClass2.equals(this.complementRepresentation)) {
                oWLClass4 = this.complementClass;
            }
            OWLSubClassOfAxiom oWLSubClassOfAxiom = OWL.factory.getOWLSubClassOfAxiom((OWLClassExpression)oWLClass3, (OWLClassExpression)oWLClass4);
            OWLSubClassOfAxiom oWLSubClassOfAxiom2 = OWL.factory.getOWLSubClassOfAxiom((OWLClassExpression)oWLClass4, (OWLClassExpression)oWLClass3);
            boolean bl = IncrementalClassifier.this.reasoner.isEntailed((OWLAxiom)oWLSubClassOfAxiom);
            boolean bl2 = IncrementalClassifier.this.reasoner.isEntailed((OWLAxiom)oWLSubClassOfAxiom2);
            if (bl && bl2) {
                return PartialOrderRelation.EQUAL;
            }
            if (bl) {
                return PartialOrderRelation.LESS;
            }
            if (bl2) {
                return PartialOrderRelation.GREATER;
            }
            return PartialOrderRelation.INCOMPARABLE;
        }
    }

    public static class PersistedState {
        private final ModuleExtractor extractor;
        private final Taxonomy<OWLClass> taxonomy;
        private final boolean realized;

        public PersistedState(IncrementalClassifier incrementalClassifier) {
            this.extractor = incrementalClassifier.extractor;
            this.taxonomy = incrementalClassifier.taxonomy;
            this.realized = incrementalClassifier.realized;
        }

        public PersistedState(ModuleExtractor moduleExtractor, Taxonomy<OWLClass> taxonomy, boolean bl) {
            this.extractor = moduleExtractor;
            this.taxonomy = taxonomy;
            this.realized = bl;
        }

        public ModuleExtractor getModuleExtractor() {
            return this.extractor;
        }

        public Taxonomy<OWLClass> getTaxonomy() {
            return this.taxonomy;
        }

        public boolean isRealized() {
            return this.realized;
        }
    }
}

