/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.out.SinkEntityOutput;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.SyntaxLabels;

public class RDFJSONWriter {
    public static void write(OutputStream out, Graph graph) {
        Prologue prologue = Prologue.create(null, null);
        SinkEntityOutput sink = new SinkEntityOutput(out, prologue, SyntaxLabels.createNodeToLabel());
        RDFJSONWriter.write(sink, graph);
    }

    public static void write(Writer out, Graph graph) {
        Prologue prologue = Prologue.create(null, null);
        SinkEntityOutput sink = new SinkEntityOutput(out, prologue, SyntaxLabels.createNodeToLabel());
        RDFJSONWriter.write(sink, graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(Sink<Pair<Node, Map<Node, Set<Node>>>> sink, Graph graph) {
        ExtendedIterator subjects = GraphUtil.listSubjects((Graph)graph, (Node)Node.ANY, (Node)Node.ANY);
        try {
            HashMap predicates = new HashMap();
            while (subjects.hasNext()) {
                Node subject = (Node)subjects.next();
                ExtendedIterator triples = graph.find(subject, Node.ANY, Node.ANY);
                try {
                    while (triples.hasNext()) {
                        Triple triple = (Triple)triples.next();
                        Node p = triple.getPredicate();
                        if (predicates.containsKey(p)) {
                            ((Set)predicates.get(p)).add(triple.getObject());
                            continue;
                        }
                        HashSet<Node> objects = new HashSet<Node>();
                        objects.add(triple.getObject());
                        predicates.put(p, objects);
                    }
                }
                finally {
                    if (triples != null) {
                        triples.close();
                    }
                }
                sink.send(new Pair(subject, predicates));
                predicates.clear();
            }
        }
        finally {
            if (subjects != null) {
                subjects.close();
            }
            sink.close();
        }
    }
}

