/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.OntologyDiff;
import com.clarkparsia.modularity.io.IncrementalClassifierPersistence;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import com.clarkparsia.pellet.owlapiv3.OWLClassTreePrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.logging.Level;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletClassify
extends PelletCmdApp {
    private static final int ENCODING_RADIX = 36;
    private static final String FILE_NAME_PATTERN = "persisted-state-%s.zip";
    private File saveDirectory = new File(".");
    private boolean currentStateSaved = false;

    @Override
    public String getAppCmd() {
        return "pellet classify " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public String getAppId() {
        return "PelletClassify: Classify the ontology and display the hierarchy";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions pelletCmdOptions = this.getGlobalOptions();
        PelletCmdOption pelletCmdOption = new PelletCmdOption("persist");
        pelletCmdOption.setShortOption("p");
        pelletCmdOption.setDescription("Enable persistence of classification results. The classifier will save its internal state in a file, and will reuse it the next time this ontology is loaded, therefore saving classification time. This option can only be used with OWLAPIv3 loader.");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOptions.add(this.getLoaderOption());
        pelletCmdOptions.add(this.getIgnoreImportsOption());
        pelletCmdOptions.add(this.getInputFormatOption());
        return pelletCmdOptions;
    }

    @Override
    public void run() {
        if (this.options.getOption("persist").getValueAsBoolean()) {
            this.runIncrementalClassify();
        } else {
            this.runClassicClassify();
        }
    }

    private void runClassicClassify() {
        KnowledgeBase knowledgeBase = this.getKB();
        this.startTask("consistency check");
        boolean bl = knowledgeBase.isConsistent();
        this.finishTask("consistency check");
        if (!bl) {
            throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
        }
        this.startTask("classification");
        knowledgeBase.classify();
        this.finishTask("classification");
        ClassTreePrinter classTreePrinter = new ClassTreePrinter();
        classTreePrinter.print(knowledgeBase.getTaxonomy());
    }

    private void runIncrementalClassify() {
        String string = this.options.getOption("loader").getValueAsString();
        if (!"OWLAPIv3".equals(string)) {
            logger.log(Level.WARNING, "Ignoring -l " + string + " option. When using --persist the only allowed loader is OWLAPIv3");
        }
        OWLAPILoader oWLAPILoader = (OWLAPILoader)this.getLoader("OWLAPIv3");
        oWLAPILoader.parse(this.getInputFiles());
        OWLOntology oWLOntology = oWLAPILoader.getOntology();
        IncrementalClassifier incrementalClassifier = this.createIncrementalClassifier(oWLOntology);
        if (!incrementalClassifier.isClassified()) {
            this.startTask("consistency check");
            boolean bl = incrementalClassifier.isConsistent();
            this.finishTask("consistency check");
            if (!bl) {
                throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
            }
            this.startTask("classification");
            incrementalClassifier.classify();
            this.finishTask("classification");
        }
        OWLClassTreePrinter oWLClassTreePrinter = new OWLClassTreePrinter();
        oWLClassTreePrinter.print(incrementalClassifier.getTaxonomy());
        if (!this.currentStateSaved) {
            this.persistIncrementalClassifier(incrementalClassifier, oWLOntology);
        }
    }

    private IncrementalClassifier createIncrementalClassifier(OWLOntology oWLOntology) {
        File file = this.determineSaveFile(oWLOntology);
        IncrementalClassifier incrementalClassifier = null;
        if (file.exists()) {
            incrementalClassifier = this.loadIncrementalClassifier(oWLOntology, file);
        }
        if (incrementalClassifier == null) {
            incrementalClassifier = new IncrementalClassifier(oWLOntology);
        }
        incrementalClassifier.getReasoner().getKB().setTaxonomyBuilderProgressMonitor(PelletOptions.USE_CLASSIFICATION_MONITOR.create());
        return incrementalClassifier;
    }

    private void persistIncrementalClassifier(IncrementalClassifier incrementalClassifier, OWLOntology oWLOntology) {
        File file = this.determineSaveFile(oWLOntology);
        try {
            this.verbose("Saving the state of the classifier to " + file);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            IncrementalClassifierPersistence.save(incrementalClassifier, fileOutputStream);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Unable to persist the current classifier state: " + iOException.toString());
        }
    }

    private IncrementalClassifier loadIncrementalClassifier(OWLOntology oWLOntology, File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.verbose("Reading persisted classifier state from " + file);
            IncrementalClassifier incrementalClassifier = IncrementalClassifierPersistence.load(fileInputStream, oWLOntology);
            OntologyDiff ontologyDiff = OntologyDiff.diffAxioms(incrementalClassifier.getAxioms(), oWLOntology.getAxioms());
            if (ontologyDiff.getDiffCount() > 0) {
                this.verbose("There were changes to the underlying ontology since the classifier was persisted. Incrementally updating the classifier");
                incrementalClassifier.ontologiesChanged(new LinkedList<OWLOntologyChange>(ontologyDiff.getChanges(oWLOntology)));
            } else {
                this.currentStateSaved = true;
            }
            return incrementalClassifier;
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Unable to read the persisted information from a file. Pellet will perform full classification: " + iOException);
            return null;
        }
        catch (OWLException oWLException) {
            logger.log(Level.WARNING, "Unable to incrementally update the classifier. Pellet will perform full classification: " + (Object)((Object)oWLException));
            return null;
        }
    }

    private File determineSaveFile(OWLOntology oWLOntology) {
        String string = String.format(FILE_NAME_PATTERN, this.hashOntologyIRI(oWLOntology));
        return new File(this.saveDirectory, string);
    }

    private String hashOntologyIRI(OWLOntology oWLOntology) {
        byte[] byArray = oWLOntology.getOntologyID().getOntologyIRI().toString().getBytes();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PelletCmdException("MD5 digest algorithm is not available.");
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        return bigInteger.toString(36);
    }
}

