/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class MultiValueMap<K, V>
extends HashMap<K, Set<V>>
implements Map<K, Set<V>> {
    private static final long serialVersionUID = 2660982967886888197L;

    public MultiValueMap() {
    }

    public MultiValueMap(int n) {
        super(n);
    }

    public Set<V> putSingle(K k, V v) {
        HashSet<V> hashSet = new HashSet<V>();
        hashSet.add(v);
        return super.put(k, hashSet);
    }

    @Override
    public Set<V> put(K k, Set<V> set) {
        return super.put(k, set);
    }

    public boolean add(K k, V v) {
        HashSet<V> hashSet = (HashSet<V>)this.get(k);
        if (hashSet == null) {
            hashSet = new HashSet<V>();
            super.put(k, hashSet);
        }
        return hashSet.add(v);
    }

    public boolean addAll(K k, Collection<? extends V> collection) {
        HashSet<? extends V> hashSet = (HashSet<? extends V>)this.get(k);
        if (hashSet == null) {
            hashSet = new HashSet<V>();
            super.put(k, hashSet);
        }
        return hashSet.addAll(collection);
    }

    @Override
    public boolean remove(K k, V v) {
        boolean bl = false;
        Set set = (Set)this.get(k);
        if (set != null) {
            bl = set.remove(v);
            if (set.isEmpty()) {
                super.remove(k);
            }
        }
        return bl;
    }

    public boolean contains(K k, V v) {
        Set set = (Set)this.get(k);
        if (set == null) {
            return false;
        }
        return set.contains(v);
    }

    public Iterator<V> flattenedValues() {
        return new Iterator<V>(){
            private Iterator<Set<V>> setIterator;
            private Iterator<V> valueIterator;
            {
                this.setIterator = MultiValueMap.this.values().iterator();
                this.valueIterator = null;
            }

            @Override
            public boolean hasNext() {
                while (this.valueIterator == null || !this.valueIterator.hasNext()) {
                    if (!this.setIterator.hasNext()) {
                        return false;
                    }
                    this.valueIterator = this.setIterator.next().iterator();
                }
                return true;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.valueIterator.next();
            }

            @Override
            public void remove() {
                this.setIterator.remove();
            }
        };
    }
}

