/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.blocking.BlockingFactory;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.cache.CacheSafety;
import org.mindswap.pellet.tableau.cache.CacheSafetyFactory;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.Timer;

public class EmptySRIQStrategy
extends CompletionStrategy {
    private LinkedList<Individual> mayNeedExpanding;
    private List<List<Individual>> mnx;
    private Map<Individual, ATermAppl> cachedNodes;
    private CacheSafety cacheSafety;

    public EmptySRIQStrategy(ABox aBox) {
        super(aBox);
    }

    @Override
    public void initialize(Expressivity expressivity) {
        this.mergeList = new ArrayList();
        this.cachedNodes = new HashMap<Individual, ATermAppl>();
        this.mnx = new ArrayList<List<Individual>>();
        this.mnx.add(null);
        assert (this.abox.size() == 1) : "This strategy can only be used with originally empty ABoxes";
        this.blocking = BlockingFactory.createBlocking(expressivity);
        Individual individual = this.abox.getIndIterator().next();
        this.applyUniversalRestrictions(individual);
        this.selfRule.apply(individual);
        this.mayNeedExpanding = new LinkedList();
        this.mayNeedExpanding.add(individual);
        this.abox.setBranch(1);
        this.abox.stats.treeDepth = 1;
        this.abox.setChanged(true);
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
    }

    @Override
    public void complete(Expressivity expressivity) {
        Object object;
        if (log.isLoggable(Level.FINE)) {
            log.fine("************  " + EmptySRIQStrategy.class.getName() + "  ************");
        }
        if (this.abox.getNodes().isEmpty()) {
            this.abox.setComplete(true);
            return;
        }
        if (this.abox.getNodes().size() > 1) {
            throw new RuntimeException("This strategy can only be used with an ABox that has a single individual.");
        }
        this.cacheSafety = this.abox.getCache().getSafety().canSupport(expressivity) ? this.abox.getCache().getSafety() : CacheSafetyFactory.createCacheSafety(expressivity);
        this.initialize(expressivity);
        while (!this.abox.isComplete() && !this.abox.isClosed()) {
            object = this.getNextIndividual();
            if (object == null) {
                this.abox.setComplete(true);
                break;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Starting with node " + object);
                this.abox.printTree();
                this.abox.validate();
            }
            this.expand((Individual)object);
            if (this.abox.isClosed()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            if (!expressivity.hasInverse() || !this.parentNeedsExpanding((Individual)object)) continue;
            this.mayNeedExpanding.removeAll(this.getDescendants(((Individual)object).getParent()));
            this.mayNeedExpanding.addFirst(((Individual)object).getParent());
        }
        if (log.isLoggable(Level.FINE)) {
            this.abox.printTree();
        }
        if (PelletOptions.USE_ADVANCED_CACHING && !this.abox.isClosed()) {
            object = new IndividualIterator(this.abox);
            while (object.hasNext()) {
                Individual individual = (Individual)object.next();
                ATermAppl aTermAppl = this.cachedNodes.get(individual);
                if (aTermAppl == null) continue;
                this.addCacheSat(aTermAppl);
            }
        }
    }

    private List<Individual> getDescendants(Individual individual) {
        ArrayList<Individual> arrayList = new ArrayList<Individual>();
        this.getDescendants(individual, arrayList);
        return arrayList;
    }

    private void getDescendants(Individual individual, List<Individual> list) {
        list.add(individual);
        for (Edge edge : individual.getOutEdges()) {
            if (!edge.getTo().isIndividual() || edge.getTo().equals(individual)) continue;
            this.getDescendants((Individual)edge.getTo(), list);
        }
    }

    private void addCacheSat(ATermAppl aTermAppl) {
        if (!this.abox.getCache().putSat(aTermAppl, true)) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("+++ Cache sat concept " + aTermAppl);
        }
        if (ATermUtils.isAnd(aTermAppl)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty()) {
                this.addCacheSat((ATermAppl)aTermList.getFirst());
                aTermList = aTermList.getNext();
            }
        }
    }

    private Individual getNextIndividual() {
        if (this.mayNeedExpanding.isEmpty()) {
            return null;
        }
        return this.mayNeedExpanding.get(0);
    }

    private boolean parentNeedsExpanding(Individual individual) {
        if (individual.isRoot()) {
            return false;
        }
        Individual individual2 = individual.getParent();
        return individual2.canApply(0) || individual2.canApply(1) || individual2.canApply(2) || individual2.canApply(4) || individual2.canApply(5);
    }

    private void expand(Individual individual) {
        Object object;
        Object object2;
        this.checkTimer();
        if (!this.abox.doExplanation() && PelletOptions.USE_ADVANCED_CACHING) {
            object2 = this.abox.getKB().timers.startTimer("cache");
            object = this.isCachedSat(individual);
            ((Timer)object2).stop();
            if (((Bool)object).isKnown()) {
                if (((Bool)object).isTrue()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Stop cached " + individual);
                    }
                    this.mayNeedExpanding.remove(0);
                } else {
                    DependencySet dependencySet = DependencySet.EMPTY;
                    for (ATermAppl aTermAppl : individual.getTypes()) {
                        dependencySet = dependencySet.union(individual.getDepends((ATerm)aTermAppl), this.abox.doExplanation());
                    }
                    this.abox.setClash(Clash.atomic(individual, dependencySet));
                }
                return;
            }
        }
        do {
            if (this.blocking.isDirectlyBlocked(individual)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Stop blocked " + individual);
                }
                this.mayNeedExpanding.remove(0);
                return;
            }
            this.unfoldingRule.apply(individual);
            if (this.abox.isClosed()) {
                return;
            }
            this.disjunctionRule.apply(individual);
            if (this.abox.isClosed()) {
                return;
            }
            if (individual.canApply(0) || individual.canApply(1)) continue;
            if (this.blocking.isDynamic() && this.blocking.isDirectlyBlocked(individual)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Stop blocked " + individual);
                }
                this.mayNeedExpanding.remove(0);
                return;
            }
            this.someValuesRule.apply(individual);
            if (this.abox.isClosed()) {
                return;
            }
            this.minRule.apply(individual);
            if (this.abox.isClosed()) {
                return;
            }
            if (individual.canApply(0) || individual.canApply(1)) continue;
            this.chooseRule.apply(individual);
            if (this.abox.isClosed()) {
                return;
            }
            this.maxRule.apply(individual);
            if (!this.abox.isClosed()) continue;
            return;
        } while (individual.canApply(0) || individual.canApply(1) || individual.canApply(2) || individual.canApply(4));
        this.mayNeedExpanding.remove(0);
        object2 = individual.getOutEdges().sort();
        if (PelletOptions.SEARCH_TYPE) {
            object = ((EdgeList)object2).iterator();
            while (object.hasNext()) {
                Edge edge = (Edge)object.next();
                Node node = edge.getTo();
                if (node.isLiteral() || node.equals(individual)) continue;
                this.mayNeedExpanding.add((Individual)node);
            }
        } else {
            for (int i = ((EdgeList)object2).size() - 1; i >= 0; --i) {
                Edge edge = ((EdgeList)object2).edgeAt(i);
                Node node = edge.getTo();
                if (node.isLiteral() || node.equals(individual)) continue;
                this.mayNeedExpanding.add((Individual)node);
            }
        }
    }

    private ATermAppl createConcept(Individual individual) {
        int n = 0;
        ATermAppl[] aTermApplArray = new ATermAppl[individual.getTypes().size()];
        for (int i = 0; i < 7; ++i) {
            if (i == 6) continue;
            for (ATermAppl aTermAppl : individual.getTypes(i)) {
                if (aTermAppl.equals(ATermUtils.TOP)) continue;
                aTermApplArray[n++] = aTermAppl;
            }
        }
        switch (n) {
            case 0: {
                return ATermUtils.TOP;
            }
            case 1: {
                return aTermApplArray[0];
            }
        }
        return ATermUtils.makeAnd(ATermUtils.toSet((ATerm[])aTermApplArray, n));
    }

    private Bool isCachedSat(Individual individual) {
        if (individual.isRoot()) {
            return Bool.UNKNOWN;
        }
        ATermAppl aTermAppl = this.createConcept(individual);
        Bool bool = this.isCachedSat(aTermAppl);
        if (bool.isUnknown()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("??? Cache miss for " + aTermAppl);
            }
            this.cachedNodes.put(individual, aTermAppl);
        } else if (!this.cacheSafety.isSafe(aTermAppl, individual)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("*** Cache unsafe for " + aTermAppl);
            }
            bool = Bool.UNKNOWN;
        } else if (log.isLoggable(Level.FINER)) {
            log.finer("*** Cache hit for " + aTermAppl + " sat = " + bool);
        }
        return bool;
    }

    private Bool isCachedSat(ATermAppl aTermAppl) {
        Bool bool = this.abox.getCachedSat(aTermAppl);
        if (bool.isKnown() || !ATermUtils.isAnd(aTermAppl)) {
            return bool;
        }
        bool = null;
        ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
        CachedNode cachedNode = null;
        CachedNode cachedNode2 = null;
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
            CachedNode cachedNode3 = this.abox.getCached(aTermAppl2);
            if (cachedNode3 == null || !cachedNode3.isComplete()) {
                bool = Bool.UNKNOWN;
                break;
            }
            if (cachedNode3.isBottom()) {
                bool = Bool.FALSE;
                break;
            }
            if (!cachedNode3.isTop()) {
                if (cachedNode == null) {
                    cachedNode = cachedNode3;
                } else if (cachedNode2 == null) {
                    cachedNode2 = cachedNode3;
                } else {
                    bool = Bool.UNKNOWN;
                    break;
                }
            }
            aTermList = aTermList.getNext();
        }
        if (bool == null) {
            bool = cachedNode2 == null ? Bool.TRUE : this.abox.getCache().isMergable(this.abox.getKB(), cachedNode, cachedNode2);
        }
        if (bool.isKnown()) {
            this.abox.getCache().putSat(aTermAppl, bool.isTrue());
        }
        return bool;
    }

    @Override
    public void restoreLocal(Individual individual, Branch branch) {
        this.restore(branch);
    }

    @Override
    public void restore(Branch branch) {
        Object object;
        Timer timer = this.timers.startTimer("restore");
        ++this.abox.stats.globalRestores;
        Node node = this.abox.getClash().getNode();
        List<ATermAppl> list = node.getPath();
        list.add(node.getName());
        this.abox.setBranch(branch.getBranch());
        this.abox.setClash(null);
        this.mergeList.clear();
        List<ATermAppl> list2 = this.abox.getNodeNames();
        if (log.isLoggable(Level.FINE)) {
            log.fine("RESTORE: Branch " + branch.getBranch());
            if (branch.getNodeCount() < list2.size()) {
                log.fine("Remove nodes " + list2.subList(branch.getNodeCount(), list2.size()));
            }
        }
        for (int i = 0; i < list2.size(); ++i) {
            object = list2.get(i);
            Node node2 = this.abox.getNode((ATerm)object);
            if (i >= branch.getNodeCount()) {
                this.abox.removeNode((ATermAppl)object);
                ATermAppl aTermAppl = this.cachedNodes.remove(node2);
                if (aTermAppl == null || !PelletOptions.USE_ADVANCED_CACHING) continue;
                if (list.contains(object)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("+++ Cache unsat concept " + aTermAppl);
                    }
                    this.abox.getCache().putSat(aTermAppl, false);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("--- Do not cache concept " + aTermAppl + " " + object + " " + node + " " + list);
                continue;
            }
            node2.restore(branch.getBranch());
            if (!node2.equals(node)) continue;
            this.cachedNodes.remove(node2);
        }
        list2.subList(branch.getNodeCount(), list2.size()).clear();
        IndividualIterator individualIterator = this.abox.getIndIterator();
        while (individualIterator.hasNext()) {
            object = (Individual)individualIterator.next();
            this.allValuesRule.apply((Individual)object);
        }
        if (log.isLoggable(Level.FINE)) {
            this.abox.printTree();
        }
        timer.stop();
    }

    protected boolean backtrack() {
        boolean bl = false;
        ++this.abox.stats.backtracks;
        while (!bl) {
            this.completionTimer.check();
            int n = this.abox.getClash().getDepends().max();
            if (n <= 0) {
                return false;
            }
            List<Branch> list = this.abox.getBranches();
            this.abox.stats.backjumps += list.size() - n;
            Branch branch = null;
            if (n <= list.size()) {
                list.subList(n, list.size()).clear();
                branch = list.get(n - 1);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("JUMP: " + n);
                }
                if (branch == null || n != branch.getBranch()) {
                    throw new RuntimeException("Internal error in reasoner: Trying to backtrack branch " + n + " but got " + branch);
                }
                if (branch.getTryNext() < branch.getTryCount()) {
                    branch.setLastClash(this.abox.getClash().getDepends());
                }
                branch.setTryNext(branch.getTryNext() + 1);
                if (branch.getTryNext() < branch.getTryCount()) {
                    this.restore(branch);
                    bl = branch.tryNext();
                }
            }
            if (!bl) {
                this.abox.getClash().getDepends().remove(n);
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("FAIL: " + n);
                continue;
            }
            this.mayNeedExpanding = new LinkedList(this.mnx.get(branch.getBranch()));
            this.mnx.subList(branch.getBranch() + 1, this.mnx.size()).clear();
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("MNX : " + this.mayNeedExpanding);
        }
        this.abox.validate();
        return bl;
    }

    @Override
    public void addBranch(Branch branch) {
        super.addBranch(branch);
        assert (this.mnx.size() == branch.getBranch()) : this.mnx.size() + " != " + branch.getBranch();
        this.mnx.add(new ArrayList<Individual>(this.mayNeedExpanding));
    }
}

