/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import aterm.AFun;
import aterm.ATermAppl;
import aterm.ATermList;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermVisitor;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class ATermBaseVisitor
implements ATermVisitor {
    public static final ATermAppl OWL_THING = ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#Thing");
    public static final ATermAppl OWL_NOTHING = ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#Nothing");

    @Override
    public void visit(ATermAppl aTermAppl) {
        AFun aFun = aTermAppl.getAFun();
        if (aTermAppl.equals(ATermUtils.TOP)) {
            this.visitTerm(OWL_THING);
        } else if (aTermAppl.equals(ATermUtils.BOTTOM)) {
            this.visitTerm(OWL_NOTHING);
        } else if (aFun.getArity() == 0) {
            this.visitTerm(aTermAppl);
        } else if (aFun.equals(ATermUtils.BNODE_FUN)) {
            this.visitTerm(aTermAppl);
        } else if (aFun.equals(ATermUtils.ANDFUN)) {
            this.visitAnd(aTermAppl);
        } else if (aFun.equals(ATermUtils.ORFUN)) {
            if (ATermUtils.isOneOf(aTermAppl)) {
                this.visitOneOf(aTermAppl);
            } else {
                this.visitOr(aTermAppl);
            }
        } else if (aFun.equals(ATermUtils.NOTFUN)) {
            this.visitNot(aTermAppl);
        } else if (aFun.equals(ATermUtils.ALLFUN)) {
            this.visitAll(aTermAppl);
        } else if (aFun.equals(ATermUtils.SOMEFUN)) {
            if (ATermUtils.isHasValue(aTermAppl)) {
                this.visitHasValue(aTermAppl);
            } else {
                this.visitSome(aTermAppl);
            }
        } else if (aFun.equals(ATermUtils.MINFUN)) {
            this.visitMin(aTermAppl);
        } else if (aFun.equals(ATermUtils.MAXFUN)) {
            this.visitMax(aTermAppl);
        } else if (aFun.equals(ATermUtils.CARDFUN)) {
            this.visitCard(aTermAppl);
        } else if (aFun.equals(ATermUtils.VALUEFUN)) {
            this.visitValue(aTermAppl);
        } else if (aFun.equals(ATermUtils.LITFUN)) {
            this.visitLiteral(aTermAppl);
        } else if (aFun.equals(ATermUtils.SELFFUN)) {
            this.visitSelf(aTermAppl);
        } else if (aFun.equals(ATermUtils.INVFUN)) {
            this.visitInverse(aTermAppl);
        } else if (aFun.equals(ATermUtils.RESTRDATATYPEFUN)) {
            this.visitRestrictedDatatype(aTermAppl);
        } else {
            throw new InternalReasonerException("Invalid term " + aTermAppl);
        }
    }

    @Override
    public void visitList(ATermList aTermList) {
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl = (ATermAppl)aTermList.getFirst();
            this.visit(aTermAppl);
            aTermList = aTermList.getNext();
        }
    }
}

