/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.DatatypeReasonerImpl;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellint.rdfxml.OWLEntityDatabase;
import com.clarkparsia.pellint.rdfxml.RDFLints;
import com.clarkparsia.pellint.rdfxml.RDFModel;
import com.clarkparsia.pellint.util.CollectionUtil;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.jena.vocabulary.SWRL;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;

public class OWLSyntaxChecker {
    static final Collection<Property> RESTRICTION_PROPS = Arrays.asList(OWL.onProperty, OWL.hasValue, OWL.allValuesFrom, OWL.someValuesFrom, OWL.minCardinality, OWL2.minQualifiedCardinality, OWL.maxCardinality, OWL2.maxQualifiedCardinality, OWL.cardinality, OWL2.qualifiedCardinality, OWL2.hasSelf);
    static final Collection<Resource> DATA_RANGE_FACETS = CollectionUtil.makeSet();
    static final Collection<Resource> SWRL_BUILT_INS;
    private Map<Resource, List<RDFNode>> m_Lists;
    private OWLEntityDatabase m_OWLEntities;
    private RDFModel m_Model = null;
    private boolean excludeValidPunnings = false;

    public void setExcludeValidPunnings(boolean bl) {
        this.excludeValidPunnings = bl;
    }

    public boolean isExcludeValidPunnings() {
        return this.excludeValidPunnings;
    }

    public RDFLints validate(RDFModel rDFModel) {
        this.m_Model = rDFModel;
        this.m_OWLEntities = new OWLEntityDatabase();
        this.m_OWLEntities.addAnnotationRole((RDFNode)RDFS.label);
        this.m_OWLEntities.addAnnotationRole((RDFNode)RDFS.comment);
        this.m_OWLEntities.addAnnotationRole((RDFNode)RDFS.seeAlso);
        this.m_OWLEntities.addAnnotationRole((RDFNode)RDFS.isDefinedBy);
        this.m_OWLEntities.addAnnotationRole((RDFNode)OWL.versionInfo);
        this.m_OWLEntities.addOntologyRole((RDFNode)OWL.backwardCompatibleWith);
        this.m_OWLEntities.addOntologyRole((RDFNode)OWL.priorVersion);
        this.m_OWLEntities.addOntologyRole((RDFNode)OWL.incompatibleWith);
        this.m_OWLEntities.addClass((RDFNode)OWL.Thing);
        this.m_OWLEntities.addClass((RDFNode)OWL.Nothing);
        this.m_OWLEntities.addDatatype((RDFNode)RDFS.Literal);
        this.m_OWLEntities.addDatatype((RDFNode)ResourceFactory.createResource((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#PlainLiteral"));
        for (ATermAppl aTermAppl : new DatatypeReasonerImpl().listDataRanges()) {
            this.m_OWLEntities.addDatatype((RDFNode)ResourceFactory.createResource((String)aTermAppl.getName()));
        }
        this.m_Lists = CollectionUtil.makeMap();
        this.m_Lists.put(RDF.nil, CollectionUtil.makeList());
        this.processTypes();
        this.processTriples();
        this.processRestrictions();
        return this.reportLints();
    }

    private RDFLints reportLints() {
        RDFLints rDFLints = new RDFLints();
        rDFLints.add("Untyped ontologies", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulOntologies()));
        rDFLints.add("Untyped classes", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulClasses()));
        rDFLints.add("Untyped datatypes", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulDatatypes()));
        rDFLints.add("Untyped object properties", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulObjectRoles()));
        rDFLints.add("Untyped datatype properties", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulDatatypeRoles()));
        rDFLints.add("Untyped annotation properties", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulAnnotaionRoles()));
        rDFLints.add("Untyped properties", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulRoles()));
        rDFLints.add("Untyped individuals", OWLSyntaxChecker.toString(this.m_OWLEntities.getDoubtfulIndividuals()));
        rDFLints.add("Using rdfs:Class instead of owl:Class", OWLSyntaxChecker.toString(this.m_OWLEntities.getAllRDFClasses()));
        rDFLints.add("Multiple typed resources", OWLSyntaxChecker.toString(this.m_OWLEntities.getMultiTypedResources(this.excludeValidPunnings)));
        rDFLints.add("Literals used where a class is expected", OWLSyntaxChecker.toStringLiterals(this.m_OWLEntities.getLiteralsAsClass()));
        rDFLints.add("Literals used where an individual is expected", OWLSyntaxChecker.toStringLiterals(this.m_OWLEntities.getLiteralsAsIndividuals()));
        rDFLints.add("Resource used where a literal is expected", OWLSyntaxChecker.toString(this.m_OWLEntities.getResourcesAsLiterals()));
        rDFLints.addMissingStatements(this.m_OWLEntities.getAllTypingStatements());
        return rDFLints;
    }

    private static List<String> toStringLiterals(Set<Literal> set) {
        List<String> list = CollectionUtil.makeList();
        for (Literal literal : set) {
            list.add("\"" + literal.toString() + "\"");
        }
        return list;
    }

    private static List<String> toString(Set<? extends RDFNode> set) {
        List<String> list = CollectionUtil.makeList();
        int n = 0;
        for (RDFNode rDFNode : set) {
            if (rDFNode.isAnon()) {
                ++n;
                continue;
            }
            list.add(rDFNode.toString());
        }
        if (n > 0) {
            list.add(n + " BNode(s)");
        }
        return list;
    }

    private static <K, V> List<String> toString(Map<K, List<V>> map) {
        List<String> list = CollectionUtil.makeList();
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue());
            list.add(stringBuilder.toString());
        }
        return list;
    }

    private void createList(Resource resource, List<RDFNode> list) {
        if (resource.equals((Object)RDF.nil)) {
            return;
        }
        RDFNode rDFNode = this.m_Model.getUniqueObject(resource, RDF.first);
        RDFNode rDFNode2 = this.m_Model.getUniqueObject(resource, RDF.rest);
        if (rDFNode == null) {
            return;
        }
        if (rDFNode2 == null) {
            return;
        }
        list.add(rDFNode);
        if (!rDFNode2.isResource()) {
            return;
        }
        this.createList((Resource)rDFNode2, list);
    }

    private void createList(Resource resource) {
        if (this.m_Lists.containsKey(resource)) {
            return;
        }
        List<RDFNode> list = CollectionUtil.makeList();
        this.m_Lists.put(resource, list);
        this.createList(resource, list);
    }

    private void processTypes() {
        RDFNode rDFNode;
        RDFNode rDFNode2;
        Resource resource;
        Property property;
        Statement statement2;
        block0: for (Statement object2 : this.m_Model.getStatementsByPredicate(RDF.first)) {
            Resource resource2 = object2.getSubject();
            for (Statement statement2 : this.m_Model.getStatementsByObject((RDFNode)resource2)) {
                property = statement2.getPredicate();
                if (property.equals(RDF.first) || property.equals(RDF.rest)) continue;
                this.createList(resource2);
                continue block0;
            }
        }
        List list = CollectionUtil.makeList();
        for (Statement statement3 : this.m_Model.getStatementsByPredicate(RDF.type)) {
            resource = statement3.getSubject();
            statement2 = statement3.getObject();
            if (statement2.equals(OWL.Class) || statement2.equals(OWL.DeprecatedClass)) {
                this.m_OWLEntities.addClass((RDFNode)resource);
                continue;
            }
            if (statement2.equals(RDFS.Class)) {
                list.add(statement3);
                continue;
            }
            if (statement2.equals(RDFS.Datatype)) {
                this.m_OWLEntities.addDatatype((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL.Thing)) {
                this.m_OWLEntities.addIndividual((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL.Restriction)) {
                this.m_OWLEntities.addRestriction(resource);
                continue;
            }
            if (statement2.equals(OWL2.SelfRestriction)) {
                this.m_OWLEntities.addRestriction(resource);
                continue;
            }
            if (statement2.equals(OWL.AllDifferent)) continue;
            if (statement2.equals(OWL.ObjectProperty)) {
                this.m_OWLEntities.addObjectRole((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL.DatatypeProperty)) {
                this.m_OWLEntities.addDatatypeRole((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL.AnnotationProperty)) {
                this.m_OWLEntities.addAnnotationRole((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL.DeprecatedProperty)) {
                this.m_OWLEntities.addUntypedRole((RDFNode)resource);
                continue;
            }
            if (statement2.equals(RDF.Property)) {
                list.add(statement3);
                continue;
            }
            if (statement2.equals(OWL.TransitiveProperty)) {
                this.m_OWLEntities.addTransitiveRole((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL.SymmetricProperty)) {
                this.m_OWLEntities.addSymmetricRole((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL2.AsymmetricProperty)) {
                this.m_OWLEntities.addAntiSymmetricRole(resource);
                continue;
            }
            if (statement2.equals(OWL2.ReflexiveProperty)) {
                this.m_OWLEntities.addReflexiveRole(resource);
                continue;
            }
            if (statement2.equals(OWL2.IrreflexiveProperty)) {
                this.m_OWLEntities.addIrreflexiveRole(resource);
                continue;
            }
            if (statement2.equals(OWL.FunctionalProperty)) {
                list.add(statement3);
                continue;
            }
            if (statement2.equals(OWL.InverseFunctionalProperty)) {
                this.m_OWLEntities.addInverseFunctionalRole((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL.Ontology)) {
                this.m_OWLEntities.addOntology((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL.DataRange)) {
                this.m_OWLEntities.addDatatype((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL2.NamedIndividual)) {
                this.m_OWLEntities.addIndividual((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL2.NegativePropertyAssertion)) {
                property = this.m_Model.getUniqueObject(resource, OWL2.sourceIndividual);
                rDFNode2 = this.m_Model.getUniqueObject(resource, OWL2.assertionProperty);
                rDFNode = this.m_Model.getUniqueObject(resource, OWL2.targetValue);
                RDFNode rDFNode3 = this.m_Model.getUniqueObject(resource, OWL2.targetIndividual);
                if (property != null) {
                    this.m_OWLEntities.addIndividual((RDFNode)property);
                }
                if (rDFNode2 != null) {
                    if (rDFNode != null) {
                        this.m_OWLEntities.assumeDatatypeRole(rDFNode2);
                    } else {
                        this.m_OWLEntities.assumeObjectRole(rDFNode2);
                    }
                }
                if (rDFNode != null) {
                    if (rDFNode.isLiteral()) {
                        this.m_OWLEntities.addLiteral(rDFNode);
                        continue;
                    }
                    this.m_OWLEntities.addIndividual(rDFNode);
                    continue;
                }
                if (rDFNode3 == null) continue;
                this.m_OWLEntities.addIndividual(rDFNode3);
                continue;
            }
            if (statement2.equals(SWRL.Imp) || statement2.equals(SWRL.AtomList)) continue;
            if (statement2.equals(SWRL.Variable)) {
                this.m_OWLEntities.addSWRLVariable((RDFNode)resource);
                continue;
            }
            if (statement2.equals(SWRL.ClassAtom) || statement2.equals(SWRL.DataRangeAtom) || statement2.equals(SWRL.IndividualPropertyAtom) || statement2.equals(SWRL.DatavaluedPropertyAtom) || statement2.equals(SWRL.SameIndividualAtom) || statement2.equals(SWRL.DifferentIndividualsAtom)) {
                list.add(statement3);
                continue;
            }
            if (statement2.equals(SWRL.BuiltinAtom)) continue;
            this.m_OWLEntities.addIndividual((RDFNode)resource);
            list.add(statement3);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Statement statement4 = (Statement)iterator.next();
            resource = statement4.getSubject();
            statement2 = statement4.getObject();
            if (statement2.equals(RDFS.Class)) {
                if (this.m_Model.containsStatement(resource, RDF.type, (RDFNode)OWL.Restriction) || this.m_Model.containsStatement(resource, RDF.type, (RDFNode)OWL.Class)) continue;
                this.m_OWLEntities.addRDFSClass((RDFNode)resource);
                continue;
            }
            if (statement2.equals(OWL.FunctionalProperty)) {
                if (this.m_OWLEntities.containsRole((RDFNode)resource)) continue;
                this.m_OWLEntities.assumeObjectRole((RDFNode)resource);
                continue;
            }
            if (statement2.equals(RDF.Property)) {
                if (this.m_OWLEntities.containsRole((RDFNode)resource)) continue;
                this.m_OWLEntities.assumeObjectRole((RDFNode)resource);
                continue;
            }
            if (statement2.equals(SWRL.ClassAtom)) {
                property = this.m_Model.getUniqueObject(resource, SWRL.classPredicate);
                rDFNode2 = this.m_Model.getUniqueObject(resource, SWRL.argument1);
                this.m_OWLEntities.assumeClass((RDFNode)property);
                if (this.m_OWLEntities.containsIndividual(rDFNode2)) continue;
                this.m_OWLEntities.assumeSWRLVariable(rDFNode2);
                continue;
            }
            if (statement2.equals(SWRL.DataRangeAtom)) {
                property = this.m_Model.getUniqueObject(resource, SWRL.dataRange);
                rDFNode2 = this.m_Model.getUniqueObject(resource, SWRL.argument1);
                this.m_OWLEntities.assumeDatatype((RDFNode)property);
                if (rDFNode2.isLiteral()) continue;
                this.m_OWLEntities.assumeSWRLVariable(rDFNode2);
                continue;
            }
            if (statement2.equals(SWRL.IndividualPropertyAtom)) {
                property = this.m_Model.getUniqueObject(resource, SWRL.propertyPredicate);
                rDFNode2 = this.m_Model.getUniqueObject(resource, SWRL.argument1);
                rDFNode = this.m_Model.getUniqueObject(resource, SWRL.argument2);
                this.m_OWLEntities.assumeObjectRole((RDFNode)property);
                if (!this.m_OWLEntities.containsIndividual(rDFNode2)) {
                    this.m_OWLEntities.assumeSWRLVariable(rDFNode2);
                }
                if (this.m_OWLEntities.containsIndividual(rDFNode)) continue;
                this.m_OWLEntities.assumeSWRLVariable(rDFNode);
                continue;
            }
            if (statement2.equals(SWRL.DatavaluedPropertyAtom)) {
                property = this.m_Model.getUniqueObject(resource, SWRL.propertyPredicate);
                rDFNode2 = this.m_Model.getUniqueObject(resource, SWRL.argument1);
                rDFNode = this.m_Model.getUniqueObject(resource, SWRL.argument2);
                this.m_OWLEntities.assumeDatatypeRole((RDFNode)property);
                if (!this.m_OWLEntities.containsIndividual(rDFNode2)) {
                    this.m_OWLEntities.assumeSWRLVariable(rDFNode2);
                }
                if (rDFNode.isLiteral()) continue;
                this.m_OWLEntities.assumeSWRLVariable(rDFNode);
                continue;
            }
            if (statement2.equals(SWRL.SameIndividualAtom) || statement2.equals(SWRL.DifferentIndividualsAtom)) {
                property = this.m_Model.getUniqueObject(resource, SWRL.argument1);
                rDFNode2 = this.m_Model.getUniqueObject(resource, SWRL.argument2);
                if (!this.m_OWLEntities.containsIndividual((RDFNode)property)) {
                    this.m_OWLEntities.assumeSWRLVariable((RDFNode)property);
                }
                if (this.m_OWLEntities.containsIndividual(rDFNode2)) continue;
                this.m_OWLEntities.assumeSWRLVariable(rDFNode2);
                continue;
            }
            if (statement2.equals(OWL2.AllDisjointProperties) || statement2.equals(OWL2.AllDisjointClasses)) continue;
            this.m_OWLEntities.assumeClass((RDFNode)statement2);
        }
    }

    private void processRestrictions() {
        for (Resource resource : this.m_OWLEntities.getAllRestrictions()) {
            RDFNode rDFNode = this.m_Model.getUniqueObject(resource, OWL.onProperty);
            if (rDFNode == null) continue;
            RDFNode rDFNode2 = null;
            rDFNode2 = this.m_Model.getUniqueObject(resource, OWL2.onClass);
            if (rDFNode2 != null && rDFNode2.isResource()) {
                this.m_OWLEntities.assumeObjectRole(rDFNode);
                this.m_OWLEntities.assumeClass(rDFNode2);
            }
            if ((rDFNode2 = this.m_Model.getUniqueObject(resource, OWL2.onDataRange)) != null && rDFNode2.isResource()) {
                this.m_OWLEntities.assumeDatatypeRole(rDFNode);
                this.m_OWLEntities.assumeDatatype(rDFNode2);
            }
            if ((rDFNode2 = this.m_Model.getUniqueObject(resource, OWL.hasValue)) != null) {
                if (rDFNode2.isResource()) {
                    this.m_OWLEntities.addIndividual(rDFNode2);
                } else {
                    this.m_OWLEntities.assumeDatatypeRole(rDFNode);
                }
            }
            if (!this.m_OWLEntities.containsRole(rDFNode)) {
                this.m_OWLEntities.assumeObjectRole(rDFNode);
            }
            if ((rDFNode2 = this.m_Model.getUniqueObject(resource, OWL.someValuesFrom)) == null) {
                rDFNode2 = this.m_Model.getUniqueObject(resource, OWL.allValuesFrom);
            }
            if (rDFNode2 == null || !rDFNode2.isResource()) continue;
            if (this.m_OWLEntities.containsObjectRole(rDFNode)) {
                this.m_OWLEntities.assumeClass(rDFNode2);
                continue;
            }
            if (!this.m_OWLEntities.containsDatatypeRole(rDFNode)) continue;
            this.m_OWLEntities.assumeDatatype(rDFNode2);
        }
    }

    private void processTriples() {
        for (Statement statement : this.m_Model.getStatements()) {
            Resource resource = statement.getSubject();
            Property property = statement.getPredicate();
            RDFNode rDFNode = statement.getObject();
            if (rDFNode.isLiteral()) {
                this.m_OWLEntities.addLiteral(rDFNode);
            }
            if (property.equals(RDF.type) || property.equals(RDF.subject) || property.equals(RDF.predicate) || property.equals(RDF.object) || RESTRICTION_PROPS.contains(property) || DATA_RANGE_FACETS.contains(property)) continue;
            if (property.equals(OWL2.members)) {
                if (this.m_Model.containsStatement(resource, RDF.type, (RDFNode)OWL.AllDifferent)) {
                    if (!this.m_Lists.containsKey(rDFNode)) continue;
                    for (RDFNode rDFNode2 : this.m_Lists.get(rDFNode)) {
                        this.m_OWLEntities.addIndividual(rDFNode2);
                    }
                    continue;
                }
                if (this.m_Model.containsStatement(resource, RDF.type, (RDFNode)OWL2.AllDisjointClasses)) {
                    if (!this.m_Lists.containsKey(rDFNode)) continue;
                    for (RDFNode rDFNode3 : this.m_Lists.get(rDFNode)) {
                        this.m_OWLEntities.assumeClass(rDFNode3);
                    }
                    continue;
                }
                if (!this.m_Model.containsStatement(resource, RDF.type, (RDFNode)OWL2.AllDisjointProperties) || !this.m_Lists.containsKey(rDFNode)) continue;
                for (RDFNode rDFNode4 : this.m_Lists.get(rDFNode)) {
                    this.m_OWLEntities.addUntypedRole(rDFNode4);
                }
                continue;
            }
            if (property.equals(OWL2.assertionProperty) || property.equals(OWL2.targetValue) || property.equals(OWL2.sourceIndividual) || property.equals(OWL2.targetIndividual)) continue;
            if (property.equals(OWL.intersectionOf) || property.equals(OWL.unionOf) || property.equals(OWL2.disjointUnionOf)) {
                if (!rDFNode.isResource()) continue;
                for (RDFNode rDFNode5 : this.m_Lists.get(rDFNode)) {
                    this.m_OWLEntities.assumeClass(rDFNode5);
                }
                continue;
            }
            if (property.equals(OWL.complementOf)) {
                if (this.m_OWLEntities.containsDatatype((RDFNode)resource)) {
                    this.m_OWLEntities.assumeDatatype(rDFNode);
                    continue;
                }
                this.m_OWLEntities.assumeClass((RDFNode)resource);
                this.m_OWLEntities.assumeClass(rDFNode);
                continue;
            }
            if (property.equals(OWL.oneOf)) {
                if (this.m_OWLEntities.containsDatatype((RDFNode)resource)) continue;
                this.m_OWLEntities.assumeClass((RDFNode)resource);
                if (!rDFNode.isResource()) continue;
                for (RDFNode rDFNode6 : this.m_Lists.get(rDFNode)) {
                    this.m_OWLEntities.addIndividual(rDFNode6);
                }
                continue;
            }
            if (property.equals(OWL2.hasKey)) {
                this.m_OWLEntities.assumeClass((RDFNode)resource);
                if (!rDFNode.isResource() || !this.m_Lists.containsKey(rDFNode)) continue;
                for (RDFNode rDFNode7 : this.m_Lists.get(rDFNode)) {
                    this.m_OWLEntities.addUntypedRole(rDFNode7);
                }
                continue;
            }
            if (property.equals(RDFS.subClassOf)) {
                this.m_OWLEntities.assumeClass((RDFNode)resource);
                this.m_OWLEntities.assumeClass(rDFNode);
                continue;
            }
            if (property.equals(OWL.equivalentClass)) {
                if (this.m_OWLEntities.containsDatatype((RDFNode)resource) || this.m_OWLEntities.containsDatatype(rDFNode)) continue;
                this.m_OWLEntities.assumeClass((RDFNode)resource);
                this.m_OWLEntities.assumeClass(rDFNode);
                continue;
            }
            if (property.equals(OWL.disjointWith)) {
                this.m_OWLEntities.assumeClass((RDFNode)resource);
                this.m_OWLEntities.assumeClass(rDFNode);
                continue;
            }
            if (property.equals(OWL.equivalentProperty)) {
                if (!this.m_OWLEntities.containsRole((RDFNode)resource)) {
                    this.m_OWLEntities.assumeObjectRole((RDFNode)resource);
                }
                if (this.m_OWLEntities.containsRole(rDFNode)) continue;
                this.m_OWLEntities.assumeObjectRole(rDFNode);
                continue;
            }
            if (property.equals(RDFS.subPropertyOf)) {
                if (!this.m_OWLEntities.containsRole((RDFNode)resource)) {
                    this.m_OWLEntities.assumeObjectRole((RDFNode)resource);
                }
                if (this.m_OWLEntities.containsRole(rDFNode)) continue;
                this.m_OWLEntities.assumeObjectRole(rDFNode);
                continue;
            }
            if (property.equals(OWL2.propertyDisjointWith)) {
                this.m_OWLEntities.addUntypedRole((RDFNode)resource);
                this.m_OWLEntities.addUntypedRole(rDFNode);
                continue;
            }
            if (property.equals(OWL2.propertyChainAxiom)) {
                this.m_OWLEntities.assumeObjectRole((RDFNode)resource);
                if (!rDFNode.isResource()) continue;
                for (RDFNode rDFNode8 : this.m_Lists.get(rDFNode)) {
                    this.m_OWLEntities.assumeObjectRole(rDFNode8);
                }
                continue;
            }
            if (property.equals(OWL2.onDatatype)) {
                if (!this.m_Model.containsStatement(resource, RDF.type, (RDFNode)RDFS.Datatype)) {
                    this.m_OWLEntities.assumeDatatype((RDFNode)resource);
                    continue;
                }
                this.m_OWLEntities.addDatatype((RDFNode)resource);
                continue;
            }
            if (property.equals(OWL2.withRestrictions)) {
                if (!this.m_Model.containsStatement(resource, RDF.type, (RDFNode)RDFS.Datatype)) {
                    this.m_OWLEntities.assumeDatatype((RDFNode)resource);
                } else {
                    this.m_OWLEntities.addDatatype((RDFNode)resource);
                }
                if (rDFNode.isResource() && this.m_Lists.containsKey(rDFNode)) {
                    for (RDFNode rDFNode9 : this.m_Lists.get(rDFNode)) {
                        this.processWithRestrictionNode(rDFNode9);
                    }
                    continue;
                }
                if (!rDFNode.isResource()) continue;
                this.processWithRestrictionNode(rDFNode);
                continue;
            }
            if (property.equals(OWL.inverseOf)) {
                if (!this.m_OWLEntities.containsRole((RDFNode)resource)) {
                    if (resource.isAnon()) {
                        this.m_OWLEntities.addObjectRole(rDFNode);
                    } else {
                        this.m_OWLEntities.assumeObjectRole((RDFNode)resource);
                    }
                }
                if (this.m_OWLEntities.containsRole(rDFNode)) continue;
                this.m_OWLEntities.assumeObjectRole(rDFNode);
                continue;
            }
            if (property.equals(OWL.sameAs)) {
                this.m_OWLEntities.addIndividual((RDFNode)resource);
                this.m_OWLEntities.addIndividual(rDFNode);
                continue;
            }
            if (property.equals(OWL2.onClass)) {
                this.m_OWLEntities.assumeClass(rDFNode);
                continue;
            }
            if (property.equals(OWL.differentFrom)) continue;
            if (property.equals(RDFS.domain)) {
                if (!resource.isAnon() && (resource.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#".toString()) || resource.getURI().equals("http://www.w3.org/2002/07/owl#".toString()))) continue;
                if (!this.m_OWLEntities.containsRole((RDFNode)resource)) {
                    this.m_OWLEntities.assumeObjectRole((RDFNode)resource);
                }
                this.m_OWLEntities.assumeClass(rDFNode);
                continue;
            }
            if (property.equals(RDFS.range)) {
                if (resource.isAnon() || !resource.isAnon() && (resource.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#".toString()) || resource.getURI().equals("http://www.w3.org/2002/07/owl#".toString()))) continue;
                if (!this.m_OWLEntities.containsResource((RDFNode)resource)) {
                    if (this.m_OWLEntities.containsDatatype(rDFNode)) {
                        if (this.m_OWLEntities.containsRole((RDFNode)resource)) continue;
                        this.m_OWLEntities.assumeDatatypeRole((RDFNode)resource);
                        continue;
                    }
                    if (this.m_OWLEntities.containsClass(rDFNode)) {
                        if (this.m_OWLEntities.containsRole((RDFNode)resource)) continue;
                        this.m_OWLEntities.assumeObjectRole((RDFNode)resource);
                        continue;
                    }
                    if (this.m_OWLEntities.containsIndividual(rDFNode) || this.m_OWLEntities.containsRole(rDFNode)) continue;
                    if (!this.m_OWLEntities.containsRole((RDFNode)resource)) {
                        this.m_OWLEntities.assumeObjectRole((RDFNode)resource);
                    }
                    this.m_OWLEntities.assumeClass(rDFNode);
                    continue;
                }
                if (this.m_OWLEntities.containsResource(rDFNode)) continue;
                if (this.m_OWLEntities.containsObjectRole((RDFNode)resource)) {
                    this.m_OWLEntities.assumeClass(rDFNode);
                    continue;
                }
                if (!this.m_OWLEntities.containsDatatypeRole((RDFNode)resource)) continue;
                this.m_OWLEntities.assumeDatatype(rDFNode);
                continue;
            }
            if (property.equals(OWL2.onDataRange)) {
                this.m_OWLEntities.assumeDatatype((RDFNode)resource);
                continue;
            }
            if (property.equals(OWL.distinctMembers)) {
                if (!rDFNode.isResource()) continue;
                for (RDFNode rDFNode10 : this.m_Lists.get(rDFNode)) {
                    this.m_OWLEntities.addIndividual(rDFNode10);
                }
                continue;
            }
            if (property.equals(OWL.imports)) {
                this.m_OWLEntities.assumeOntology(rDFNode);
                this.m_OWLEntities.assumeOntology((RDFNode)resource);
                continue;
            }
            if (property.equals(RDF.first) || property.equals(RDF.rest)) continue;
            if (this.m_OWLEntities.containsOntologyRole((RDFNode)property)) {
                this.m_OWLEntities.assumeOntology(rDFNode);
                this.m_OWLEntities.assumeOntology((RDFNode)resource);
                continue;
            }
            if (property.equals(SWRL.Imp) || property.equals(SWRL.head) || property.equals(SWRL.body) || property.equals(SWRL.builtin) || property.equals(SWRL.classPredicate) || property.equals(SWRL.propertyPredicate) || property.equals(SWRL.argument1) || property.equals(SWRL.argument2) || property.equals(SWRL.arguments) || this.m_OWLEntities.containsAnnotaionRole((RDFNode)property)) continue;
            if (!this.m_OWLEntities.containsRole((RDFNode)property)) {
                if (rDFNode.isLiteral()) {
                    this.m_OWLEntities.assumeDatatypeRole((RDFNode)property);
                } else if (!this.m_OWLEntities.containsIndividual((RDFNode)resource)) {
                    this.m_OWLEntities.assumeAnnotationRole((RDFNode)property);
                } else {
                    this.m_OWLEntities.assumeObjectRole((RDFNode)property);
                }
            }
            if (this.m_OWLEntities.containsAnnotaionRole((RDFNode)property)) continue;
            if (this.m_OWLEntities.containsDatatypeRole((RDFNode)property)) {
                if (rDFNode.isLiteral()) {
                    Resource resource2;
                    Literal literal = rDFNode.asLiteral();
                    String string = literal.getDatatypeURI();
                    if (string != null && !string.equals("") && !this.m_OWLEntities.containsDatatype((RDFNode)(resource2 = ResourceFactory.createResource((String)string)))) {
                        this.m_OWLEntities.assumeDatatype((RDFNode)resource2);
                    }
                } else {
                    this.m_OWLEntities.addResourcesAsLiteral(rDFNode.asResource());
                }
                this.m_OWLEntities.assumeIndividual((RDFNode)resource);
                continue;
            }
            this.m_OWLEntities.assumeIndividual((RDFNode)resource);
            if (rDFNode.isLiteral()) {
                this.m_OWLEntities.addLiteralAsIndividual(rDFNode.asLiteral());
                continue;
            }
            this.m_OWLEntities.assumeIndividual(rDFNode);
        }
    }

    private void processWithRestrictionNode(RDFNode rDFNode) {
    }

    static {
        for (Facet.XSD xSD : Facet.XSD.values()) {
            DATA_RANGE_FACETS.add(ResourceFactory.createResource((String)xSD.getName().getName()));
        }
        SWRL_BUILT_INS = CollectionUtil.makeSet();
        for (Facet.XSD xSD : SWRLBuiltInsVocabulary.values()) {
            SWRL_BUILT_INS.add(ResourceFactory.createResource((String)xSD.getURI().toString()));
        }
    }
}

