/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.ontology;

import com.clarkparsia.pellint.format.CompactClassLintFormat;
import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.ontology.OntologyLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.Severity;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLOntology;

public class TooManyDifferentIndividualsPattern
implements OntologyLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new CompactClassLintFormat();
    private int m_MaxAllowed = 50;

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + " (MaxAllowed = " + this.m_MaxAllowed + ")";
    }

    @Override
    public String getDescription() {
        return "Too many individuals involved in DifferentIndividuals axioms - maximum recommended is " + this.m_MaxAllowed;
    }

    @Override
    public boolean isFixable() {
        return false;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void setMaxAllowed(int n) {
        this.m_MaxAllowed = n;
    }

    @Override
    public List<Lint> match(OWLOntology oWLOntology) {
        int n = 0;
        for (Object object : oWLOntology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS)) {
            n += TooManyDifferentIndividualsPattern.estimateMemoryConcumption(object.getIndividuals().size());
        }
        ArrayList arrayList = new ArrayList();
        if (n > TooManyDifferentIndividualsPattern.estimateMemoryConcumption(this.m_MaxAllowed)) {
            Object object;
            object = new Lint(this, oWLOntology);
            ((Lint)object).setSeverity(new Severity(n));
            arrayList.add(object);
        }
        return arrayList;
    }

    private static int estimateMemoryConcumption(int n) {
        return n * (n - 1);
    }
}

