/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NotKnownQueryAtom
implements QueryAtom {
    private List<QueryAtom> atoms;
    private boolean isGround;
    private List<ATermAppl> args;

    public NotKnownQueryAtom(QueryAtom queryAtom) {
        this(Collections.singletonList(queryAtom));
    }

    public NotKnownQueryAtom(List<QueryAtom> list) {
        this.atoms = Collections.unmodifiableList(list);
        this.isGround = true;
        this.args = new ArrayList<ATermAppl>();
        for (QueryAtom queryAtom : list) {
            this.args.addAll(queryAtom.getArguments());
            if (!this.isGround || queryAtom.isGround()) continue;
            this.isGround = false;
        }
    }

    @Override
    public QueryAtom apply(ResultBinding resultBinding) {
        ArrayList<QueryAtom> arrayList;
        if (this.atoms.size() == 1) {
            arrayList = Collections.singletonList(this.atoms.get(0).apply(resultBinding));
        } else {
            arrayList = new ArrayList();
            for (QueryAtom queryAtom : this.atoms) {
                arrayList.add(queryAtom.apply(resultBinding));
            }
        }
        return new NotKnownQueryAtom(arrayList);
    }

    public boolean equals(Object object) {
        if (!(object instanceof NotKnownQueryAtom)) {
            return false;
        }
        return this.atoms.equals(((NotKnownQueryAtom)object).atoms);
    }

    @Override
    public List<ATermAppl> getArguments() {
        return this.args;
    }

    public List<QueryAtom> getAtoms() {
        return this.atoms;
    }

    @Override
    public QueryPredicate getPredicate() {
        return QueryPredicate.NotKnown;
    }

    public int hashCode() {
        return 17 * this.atoms.hashCode();
    }

    @Override
    public boolean isGround() {
        return this.isGround;
    }

    public String toString() {
        return "NotKnown" + this.atoms;
    }
}

