/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.StringFunctionAdapter;
import com.clarkparsia.pellet.rules.builtins.StringToStringFunction;
import java.net.URI;
import java.net.URISyntaxException;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class URIOperators {
    public static final Function resolveURI = new StringFunctionAdapter(new ResolveURI());
    public static final Function anyURI = new StringFunctionAdapter(new AnyURI());

    private static class AnyURI
    implements StringToStringFunction {
        private AnyURI() {
        }

        @Override
        public String apply(String ... stringArray) {
            if (stringArray.length != 6) {
                throw new InternalReasonerException("AnyURI wrong number of arguments");
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            String string5 = stringArray[4];
            String string6 = stringArray[5];
            if (!string.endsWith(":")) {
                string = string + ":";
            }
            if (!string2.startsWith("//")) {
                string2 = "//" + string2;
            }
            if (string3.length() > 0 && !string3.startsWith(":")) {
                string3 = ":" + string3;
            }
            if (string4.length() > 0 && !string4.startsWith("/")) {
                string4 = "/" + string4;
            }
            if (string5.length() > 0 && !string5.startsWith("?")) {
                string5 = "?" + string5;
            }
            if (string6.length() > 0 && !string6.startsWith("#")) {
                string6 = "#" + string6;
            }
            try {
                URI uRI = new URI(string + string2 + string3 + string4 + string5 + string6);
                return uRI.toASCIIString();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InternalReasonerException("Returned string is not a URI");
            }
        }
    }

    private static class ResolveURI
    implements StringToStringFunction {
        private ResolveURI() {
        }

        @Override
        public String apply(String ... stringArray) {
            URI uRI;
            URI uRI2;
            if (stringArray.length != 2) {
                throw new InternalReasonerException("ResolveURI takes two and only two arguments");
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            if (string.length() == 0) {
                return string;
            }
            try {
                uRI2 = new URI(string);
                if (uRI2.isAbsolute()) {
                    return string;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InternalReasonerException("Relative URI reference is not a valid URI");
            }
            try {
                uRI = new URI(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InternalReasonerException("Base URI reference is not a valid URI");
            }
            if (uRI2 == null) {
                throw new InternalReasonerException("Error in resolving relative URI");
            }
            if (uRI == null) {
                throw new InternalReasonerException("Error in resolving base URI");
            }
            try {
                URI uRI3 = new URI(uRI.toASCIIString() + uRI2.toASCIIString());
                return uRI3.toASCIIString();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InternalReasonerException("Evaluation of base and relative URI is not a URI");
            }
        }
    }
}

