/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.IEEEFloatType;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.RestrictedFloatingPointDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDFloat
implements Datatype<Float> {
    private static final XSDFloat instance;
    private static final Logger log;
    private final RestrictedFloatingPointDatatype<Float> dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#float");

    public static XSDFloat getInstance() {
        return instance;
    }

    private XSDFloat() {
        this.hashCode = this.name.hashCode();
        this.dataRange = new RestrictedFloatingPointDatatype<Float>(this, IEEEFloatType.getInstance());
    }

    @Override
    public RestrictedDatatype<Float> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        if (!aTermAppl.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String string = ATermUtils.getLiteralValue(aTermAppl);
        try {
            Float f = Float.valueOf(DatatypeConverter.parseFloat(string));
            String string2 = DatatypeConverter.printFloat(f.floatValue());
            if (string2.equals(string)) {
                return aTermAppl;
            }
            return ATermUtils.makeTypedLiteral(string2, this.name);
        }
        catch (NumberFormatException numberFormatException) {
            log.severe(String.format("Number format exception (%s) cause while parsing float %s", numberFormatException.getMessage(), string));
            throw new InvalidLiteralException(this.name, string);
        }
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        if (IEEEFloatType.getInstance().isInstance(object)) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printFloat(IEEEFloatType.getInstance().cast(object).floatValue()), this.name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Float getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        if (!aTermAppl.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String string = ATermUtils.getLiteralValue(aTermAppl);
        try {
            return Float.valueOf(DatatypeConverter.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.name, string);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    static {
        log = Logger.getLogger(XSDFloat.class.getCanonicalName());
        instance = new XSDFloat();
    }
}

