/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.renderer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.coode.owlapi.rdf.model.RDFGraph;
import org.coode.owlapi.rdf.model.RDFLiteralNode;
import org.coode.owlapi.rdf.model.RDFNode;
import org.coode.owlapi.rdf.model.RDFResourceNode;
import org.coode.owlapi.rdf.model.RDFTranslator;
import org.coode.owlapi.rdf.model.RDFTriple;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.AxiomSubjectProvider;
import org.semanticweb.owlapi.util.SWRLVariableExtractor;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public abstract class RDFRendererBase {
    private static final String ANNOTATION_PROPERTIES_BANNER_TEXT = "Annotation properties";
    private static final String DATATYPES_BANNER_TEXT = "Datatypes";
    private static final String OBJECT_PROPERTIES_BANNER_TEXT = "Object Properties";
    private static final String DATA_PROPERTIES_BANNER_TEXT = "Data properties";
    private static final String CLASSES_BANNER_TEXT = "Classes";
    private static final String INDIVIDUALS_BANNER_TEXT = "Individuals";
    private static final String ANNOTATED_IRIS_BANNER_TEXT = "Annotations";
    public static final String GENERAL_AXIOMS_BANNER_TEXT = "General axioms";
    public static final String RULES_BANNER_TEXT = "Rules";
    protected OWLOntology ontology;
    private RDFGraph graph;
    protected Set<IRI> prettyPrintedTypes;
    private OWLOntologyFormat format;
    public static final TripleComparator tripleComparator = new TripleComparator();

    public RDFRendererBase(OWLOntology ontology) {
        this(ontology, ontology.getOWLOntologyManager().getOntologyFormat(ontology));
    }

    @Deprecated
    public RDFRendererBase(OWLOntology ontology, OWLOntologyManager manager) {
        this(ontology, ontology.getOWLOntologyManager().getOntologyFormat(ontology));
    }

    @Deprecated
    protected RDFRendererBase(OWLOntology ontology, OWLOntologyManager manager, OWLOntologyFormat format) {
        this(ontology, format);
    }

    protected RDFRendererBase(OWLOntology ontology, OWLOntologyFormat format) {
        this.ontology = ontology;
        this.format = format;
    }

    public RDFGraph getGraph() {
        return this.graph;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    protected abstract void beginDocument() throws IOException;

    protected abstract void endDocument() throws IOException;

    protected void beginObject() throws IOException {
    }

    protected void endObject() throws IOException {
    }

    protected abstract void writeAnnotationPropertyComment(OWLAnnotationProperty var1) throws IOException;

    protected abstract void writeDataPropertyComment(OWLDataProperty var1) throws IOException;

    protected abstract void writeObjectPropertyComment(OWLObjectProperty var1) throws IOException;

    protected abstract void writeClassComment(OWLClass var1) throws IOException;

    protected abstract void writeDatatypeComment(OWLDatatype var1) throws IOException;

    protected abstract void writeIndividualComments(OWLNamedIndividual var1) throws IOException;

    public void render() throws IOException {
        this.beginDocument();
        this.renderOntologyHeader();
        this.renderOntologyComponents();
        this.endDocument();
    }

    private void renderOntologyComponents() throws IOException {
        this.renderInOntologySignatureEntities();
        this.renderAnonymousIndividuals();
        this.renderUntypedIRIAnnotationAssertions();
        this.renderGeneralAxioms();
        this.renderSWRLRules();
    }

    private void renderInOntologySignatureEntities() throws IOException {
        this.renderAnnotationProperties();
        this.renderDatatypes();
        this.renderObjectProperties();
        this.renderDataProperties();
        this.renderClasses();
        this.renderNamedIndividuals();
    }

    private void renderAnnotationProperties() throws IOException {
        Set<OWLAnnotationProperty> annotationProperties = this.ontology.getAnnotationPropertiesInSignature();
        this.renderEntities(annotationProperties, ANNOTATION_PROPERTIES_BANNER_TEXT);
    }

    private void renderNamedIndividuals() throws IOException {
        Set<OWLNamedIndividual> individuals = this.ontology.getIndividualsInSignature();
        this.renderEntities(individuals, INDIVIDUALS_BANNER_TEXT);
    }

    private void renderClasses() throws IOException {
        Set<OWLClass> clses = this.ontology.getClassesInSignature();
        this.renderEntities(clses, CLASSES_BANNER_TEXT);
    }

    private void renderDataProperties() throws IOException {
        Set<OWLDataProperty> dataProperties = this.ontology.getDataPropertiesInSignature();
        this.renderEntities(dataProperties, DATA_PROPERTIES_BANNER_TEXT);
    }

    private void renderObjectProperties() throws IOException {
        Set<OWLObjectProperty> objectProperties = this.ontology.getObjectPropertiesInSignature();
        this.renderEntities(objectProperties, OBJECT_PROPERTIES_BANNER_TEXT);
    }

    private void renderDatatypes() throws IOException {
        Set<OWLDatatype> datatypes = this.ontology.getDatatypesInSignature();
        this.renderEntities(datatypes, DATATYPES_BANNER_TEXT);
    }

    private void renderEntities(Set<? extends OWLEntity> entities, String bannerText) throws IOException {
        boolean firstRendering = true;
        for (OWLEntity oWLEntity : RDFRendererBase.toSortedSet(entities)) {
            if (!this.createGraph(oWLEntity)) continue;
            if (firstRendering) {
                firstRendering = false;
                if (!bannerText.isEmpty()) {
                    this.writeBanner(bannerText);
                }
            }
            this.renderEntity(oWLEntity);
        }
    }

    private void renderEntity(OWLEntity entity) throws IOException {
        this.beginObject();
        this.writeEntityComment(entity);
        this.render(new RDFResourceNode(entity.getIRI()));
        this.renderAnonRoots();
        this.endObject();
    }

    private void writeEntityComment(OWLEntity entity) throws IOException {
        if (entity.isOWLClass()) {
            this.writeClassComment(entity.asOWLClass());
        } else if (entity.isOWLDatatype()) {
            this.writeDatatypeComment(entity.asOWLDatatype());
        } else if (entity.isOWLObjectProperty()) {
            this.writeObjectPropertyComment(entity.asOWLObjectProperty());
        } else if (entity.isOWLDataProperty()) {
            this.writeDataPropertyComment(entity.asOWLDataProperty());
        } else if (entity.isOWLAnnotationProperty()) {
            this.writeAnnotationPropertyComment(entity.asOWLAnnotationProperty());
        } else if (entity.isOWLNamedIndividual()) {
            this.writeIndividualComments(entity.asOWLNamedIndividual());
        }
    }

    private void renderUntypedIRIAnnotationAssertions() throws IOException {
        HashSet<IRI> annotatedIRIs = new HashSet<IRI>();
        for (OWLAnnotationAssertionAxiom ax : this.ontology.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
            IRI iri;
            OWLAnnotationSubject subject = ax.getSubject();
            if (!(subject instanceof IRI) || this.ontology.containsEntityInSignature(iri = (IRI)subject)) continue;
            annotatedIRIs.add(iri);
        }
        if (!annotatedIRIs.isEmpty()) {
            this.writeBanner(ANNOTATED_IRIS_BANNER_TEXT);
            for (IRI iri : annotatedIRIs) {
                this.beginObject();
                this.createGraph(this.ontology.getAnnotationAssertionAxioms(iri));
                this.render(new RDFResourceNode(iri));
                this.renderAnonRoots();
                this.endObject();
            }
        }
    }

    private void renderAnonymousIndividuals() throws IOException {
        for (OWLAnonymousIndividual anonInd : this.ontology.getReferencedAnonymousIndividuals()) {
            boolean anonRoot = true;
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            for (OWLAxiom ax : this.ontology.getReferencingAxioms(anonInd)) {
                if (ax instanceof OWLDifferentIndividualsAxiom) continue;
                AxiomSubjectProvider subjectProvider = new AxiomSubjectProvider();
                OWLObject obj = subjectProvider.getSubject(ax);
                if (!obj.equals(anonInd)) {
                    anonRoot = false;
                    break;
                }
                axioms.add(ax);
            }
            if (!anonRoot) continue;
            this.createGraph(axioms);
            this.renderAnonRoots();
        }
    }

    private void renderSWRLRules() throws IOException {
        Set<SWRLRule> ruleAxioms = this.ontology.getAxioms(AxiomType.SWRL_RULE);
        this.createGraph(ruleAxioms);
        if (!ruleAxioms.isEmpty()) {
            this.writeBanner(RULES_BANNER_TEXT);
            SWRLVariableExtractor variableExtractor = new SWRLVariableExtractor();
            for (SWRLRule rule : ruleAxioms) {
                rule.accept(variableExtractor);
            }
            for (SWRLVariable var : variableExtractor.getVariables()) {
                this.render(new RDFResourceNode(var.getIRI()));
            }
            this.renderAnonRoots();
        }
    }

    private void renderGeneralAxioms() throws IOException {
        Set<OWLAxiom> generalAxioms = this.getGeneralAxioms();
        this.createGraph(generalAxioms);
        Set<RDFResourceNode> rootNodes = this.graph.getRootAnonymousNodes();
        if (!rootNodes.isEmpty()) {
            this.writeBanner(GENERAL_AXIOMS_BANNER_TEXT);
            this.beginObject();
            this.renderAnonRoots();
            this.endObject();
        }
    }

    private Set<OWLAxiom> getGeneralAxioms() {
        HashSet<OWLAxiom> generalAxioms = new HashSet<OWLAxiom>();
        generalAxioms.addAll(this.ontology.getGeneralClassAxioms());
        generalAxioms.addAll(this.ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS));
        for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (oWLDisjointClassesAxiom.getClassExpressions().size() <= 2) continue;
            generalAxioms.add(oWLDisjointClassesAxiom);
        }
        for (OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            if (oWLDisjointObjectPropertiesAxiom.getProperties().size() <= 2) continue;
            generalAxioms.add(oWLDisjointObjectPropertiesAxiom);
        }
        for (OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            if (oWLDisjointDataPropertiesAxiom.getProperties().size() <= 2) continue;
            generalAxioms.add(oWLDisjointDataPropertiesAxiom);
        }
        for (OWLHasKeyAxiom oWLHasKeyAxiom : this.ontology.getAxioms(AxiomType.HAS_KEY)) {
            if (!oWLHasKeyAxiom.getClassExpression().isAnonymous()) continue;
            generalAxioms.add(oWLHasKeyAxiom);
        }
        return generalAxioms;
    }

    private void renderOntologyHeader() throws IOException {
        this.graph = new RDFGraph();
        OWLOntologyID ontID = this.ontology.getOntologyID();
        RDFResourceNode ontologyHeaderNode = this.createOntologyHeaderNode();
        this.addVersionIRIToOntologyHeader(ontologyHeaderNode);
        this.addImportsDeclarationsToOntologyHeader(ontologyHeaderNode);
        this.addAnnotationsToOntologyHeader(ontologyHeaderNode);
        if (!ontID.isAnonymous() || !this.graph.isEmpty()) {
            this.graph.addTriple(new RDFTriple(ontologyHeaderNode, new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), new RDFResourceNode(OWLRDFVocabulary.OWL_ONTOLOGY.getIRI())));
        }
        if (!this.graph.isEmpty()) {
            this.render(ontologyHeaderNode);
        }
    }

    private RDFResourceNode createOntologyHeaderNode() {
        OWLOntologyID ontID = this.ontology.getOntologyID();
        if (ontID.isAnonymous()) {
            return new RDFResourceNode(System.identityHashCode(this.ontology));
        }
        return new RDFResourceNode(ontID.getOntologyIRI());
    }

    private void addVersionIRIToOntologyHeader(RDFResourceNode ontologyHeaderNode) {
        OWLOntologyID ontID = this.ontology.getOntologyID();
        if (ontID.getVersionIRI() != null) {
            this.graph.addTriple(new RDFTriple(ontologyHeaderNode, new RDFResourceNode(OWLRDFVocabulary.OWL_VERSION_IRI.getIRI()), new RDFResourceNode(ontID.getVersionIRI())));
        }
    }

    private void addImportsDeclarationsToOntologyHeader(RDFResourceNode ontologyHeaderNode) {
        for (OWLImportsDeclaration decl : this.ontology.getImportsDeclarations()) {
            this.graph.addTriple(new RDFTriple(ontologyHeaderNode, new RDFResourceNode(OWLRDFVocabulary.OWL_IMPORTS.getIRI()), new RDFResourceNode(decl.getIRI())));
        }
    }

    private void addAnnotationsToOntologyHeader(RDFResourceNode ontologyHeaderNode) {
        for (OWLAnnotation anno : this.ontology.getAnnotations()) {
            OWLAnnotationValueVisitorEx<RDFNode> valVisitor = new OWLAnnotationValueVisitorEx<RDFNode>(){

                @Override
                public RDFNode visit(IRI iri) {
                    return new RDFResourceNode(iri);
                }

                @Override
                public RDFNode visit(OWLAnonymousIndividual individual) {
                    return new RDFResourceNode(System.identityHashCode(individual));
                }

                @Override
                public RDFNode visit(OWLLiteral literal) {
                    return RDFTranslator.translateLiteralNode(literal);
                }
            };
            RDFNode node = anno.getValue().accept(valVisitor);
            this.graph.addTriple(new RDFTriple(ontologyHeaderNode, new RDFResourceNode(anno.getProperty().getIRI()), node));
        }
    }

    private boolean createGraph(OWLEntity entity) {
        final HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        if (!this.isIndividualAndClass(entity)) {
            axioms.addAll(entity.getAnnotationAssertionAxioms(this.ontology));
        }
        axioms.addAll(this.ontology.getDeclarationAxioms(entity));
        entity.accept(new OWLEntityVisitor(){

            @Override
            public void visit(OWLClass cls) {
                for (OWLAxiom oWLAxiom : RDFRendererBase.this.ontology.getAxioms(cls)) {
                    OWLDisjointClassesAxiom disjAx;
                    if (oWLAxiom instanceof OWLDisjointClassesAxiom && (disjAx = (OWLDisjointClassesAxiom)oWLAxiom).getClassExpressions().size() > 2) continue;
                    axioms.add(oWLAxiom);
                }
                for (OWLHasKeyAxiom oWLHasKeyAxiom : RDFRendererBase.this.ontology.getAxioms(AxiomType.HAS_KEY)) {
                    if (!oWLHasKeyAxiom.getClassExpression().equals(cls)) continue;
                    axioms.add(oWLHasKeyAxiom);
                }
            }

            @Override
            public void visit(OWLDatatype datatype) {
                axioms.addAll(RDFRendererBase.this.ontology.getDatatypeDefinitions(datatype));
                RDFRendererBase.this.createGraph(axioms);
            }

            @Override
            public void visit(OWLNamedIndividual individual) {
                for (OWLAxiom oWLAxiom : RDFRendererBase.this.ontology.getAxioms(individual)) {
                    if (oWLAxiom instanceof OWLDifferentIndividualsAxiom) continue;
                    axioms.add(oWLAxiom);
                }
            }

            @Override
            public void visit(OWLDataProperty property) {
                for (OWLAxiom oWLAxiom : RDFRendererBase.this.ontology.getAxioms(property)) {
                    if (oWLAxiom instanceof OWLDisjointDataPropertiesAxiom && ((OWLDisjointDataPropertiesAxiom)oWLAxiom).getProperties().size() > 2) continue;
                    axioms.add(oWLAxiom);
                }
            }

            @Override
            public void visit(OWLObjectProperty property) {
                for (OWLAxiom oWLAxiom : RDFRendererBase.this.ontology.getAxioms(property)) {
                    if (oWLAxiom instanceof OWLDisjointObjectPropertiesAxiom && ((OWLDisjointObjectPropertiesAxiom)oWLAxiom).getProperties().size() > 2) continue;
                    axioms.add(oWLAxiom);
                }
                for (OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom : RDFRendererBase.this.ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                    if (!oWLSubPropertyChainOfAxiom.getSuperProperty().equals(property)) continue;
                    axioms.add(oWLSubPropertyChainOfAxiom);
                }
                axioms.addAll(RDFRendererBase.this.ontology.getAxioms(RDFRendererBase.this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLObjectInverseOf(property)));
            }

            @Override
            public void visit(OWLAnnotationProperty property) {
                axioms.addAll(RDFRendererBase.this.ontology.getAxioms(property));
            }
        });
        if (axioms.isEmpty() && this.shouldInsertDeclarations() && RDFOntologyFormat.isMissingType(entity, this.ontology)) {
            axioms.add(this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(entity));
        }
        this.createGraph(axioms);
        return !axioms.isEmpty();
    }

    private boolean isIndividualAndClass(OWLEntity entity) {
        return entity.isOWLNamedIndividual() && this.ontology.containsClassInSignature(entity.getIRI());
    }

    protected boolean shouldInsertDeclarations() {
        return !(this.format instanceof RDFOntologyFormat) || ((RDFOntologyFormat)this.format).isAddMissingTypes();
    }

    protected void createGraph(Set<? extends OWLObject> objects) {
        RDFTranslator translator = new RDFTranslator(this.ontology.getOWLOntologyManager(), this.ontology, this.shouldInsertDeclarations());
        for (OWLObject oWLObject : objects) {
            oWLObject.accept(translator);
        }
        this.graph = translator.getGraph();
    }

    protected abstract void writeBanner(String var1) throws IOException;

    private static <N extends OWLEntity> Set<N> toSortedSet(Set<N> entities) {
        TreeSet<OWLEntity> results = new TreeSet<OWLEntity>(new OWLEntityIRIComparator());
        results.addAll(entities);
        return results;
    }

    public void renderAnonRoots() throws IOException {
        for (RDFResourceNode node : this.graph.getRootAnonymousNodes()) {
            this.render(node);
        }
    }

    public abstract void render(RDFResourceNode var1) throws IOException;

    protected boolean isObjectList(RDFResourceNode node) {
        for (RDFTriple triple : this.graph.getSortedTriplesForSubject(node, false)) {
            if (!triple.getProperty().getIRI().equals(OWLRDFVocabulary.RDF_TYPE.getIRI()) || triple.getObject().isAnonymous() || !triple.getObject().getIRI().equals(OWLRDFVocabulary.RDF_LIST.getIRI())) continue;
            ArrayList<RDFNode> items = new ArrayList<RDFNode>();
            this.toJavaList(node, items);
            for (RDFNode n : items) {
                if (!n.isLiteral()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void toJavaList(RDFNode n, List<RDFNode> list) {
        RDFNode currentNode = n;
        while (currentNode != null) {
            for (RDFTriple triple : this.graph.getSortedTriplesForSubject(currentNode, false)) {
                if (!triple.getProperty().getIRI().equals(OWLRDFVocabulary.RDF_FIRST.getIRI())) continue;
                list.add(triple.getObject());
            }
            for (RDFTriple triple : this.graph.getSortedTriplesForSubject(currentNode, false)) {
                if (!triple.getProperty().getIRI().equals(OWLRDFVocabulary.RDF_REST.getIRI())) continue;
                if (!triple.getObject().isAnonymous()) {
                    if (!triple.getObject().getIRI().equals(OWLRDFVocabulary.RDF_NIL.getIRI())) continue;
                    currentNode = null;
                    continue;
                }
                currentNode = triple.getObject();
            }
        }
    }

    public static class TripleComparator
    implements Comparator<RDFTriple>,
    Serializable {
        private static final long serialVersionUID = 30402L;
        private static final List<IRI> orderedURIs = Arrays.asList(OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_LABEL.getIRI(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI(), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI(), OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI(), OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_DATA_RANGE.getIRI(), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());

        private int getIndex(IRI iri) {
            int index = orderedURIs.indexOf(iri);
            if (index == -1) {
                index = orderedURIs.size();
            }
            return index;
        }

        @Override
        public int compare(RDFTriple o1, RDFTriple o2) {
            int diff = this.getIndex(o1.getProperty().getIRI()) - this.getIndex(o2.getProperty().getIRI());
            if (diff == 0) {
                diff = !o1.getSubject().isAnonymous() ? (!o2.getSubject().isAnonymous() ? o1.getSubject().getIRI().compareTo(o2.getSubject().getIRI()) : -1) : (!o2.getSubject().isAnonymous() ? 1 : 0);
                if (diff == 0 && (diff = o2.getProperty().getIRI().compareTo(o2.getProperty().getIRI())) == 0) {
                    if (!o1.getObject().isLiteral()) {
                        diff = !o2.getObject().isLiteral() ? (!o1.getObject().isAnonymous() ? (!o2.getObject().isAnonymous() ? o1.getObject().getIRI().compareTo(o2.getObject().getIRI()) : -1) : (!o2.getObject().isAnonymous() ? 1 : -1)) : 1;
                    } else if (!o2.getObject().isLiteral()) {
                        diff = -1;
                    } else {
                        RDFLiteralNode lit1 = (RDFLiteralNode)o1.getObject();
                        RDFLiteralNode lit2 = (RDFLiteralNode)o2.getObject();
                        if (lit1.isTyped()) {
                            if (lit2.isTyped()) {
                                diff = lit1.getLiteral().compareTo(lit2.getLiteral());
                                if (diff == 0) {
                                    diff = lit1.getDatatype().compareTo(lit2.getDatatype());
                                }
                            } else {
                                diff = -1;
                            }
                        } else if (lit2.isTyped()) {
                            diff = 1;
                        } else {
                            if (lit1.getLang() != null) {
                                if (lit2.getLang() != null) {
                                    diff = lit1.getLang().compareTo(lit2.getLang());
                                }
                            } else {
                                diff = -1;
                            }
                            if (diff == 0) {
                                diff = lit1.getLiteral().compareTo(lit2.getLiteral());
                            }
                        }
                    }
                }
            }
            if (diff == 0) {
                diff = 1;
            }
            return diff;
        }
    }

    private static final class OWLEntityIRIComparator
    implements Comparator<OWLEntity>,
    Serializable {
        private static final long serialVersionUID = 30402L;

        @Override
        public int compare(OWLEntity o1, OWLEntity o2) {
            return o1.getIRI().compareTo(o2.getIRI());
        }
    }
}

