/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.Utils;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;

public class NodeFactory {
    private static final PrefixMap prefixMappingDefault = PrefixMapFactory.createForInput(SSE.getDefaultPrefixMapRead());
    private static PrefixMap pmapEmpty = PrefixMapFactory.create();

    public static Node parseNode(String nodeString) {
        return NodeFactory.parseNode(nodeString, prefixMappingDefault);
    }

    public static Node parseNode(String nodeString, PrefixMap pmap) {
        String x;
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString(nodeString);
        if (!tokenizer.hasNext()) {
            throw new RiotException("Empty RDF term");
        }
        Token token = tokenizer.next();
        Node node = token.asNode(pmap);
        if (node == null) {
            throw new RiotException("Bad RDF Term: " + nodeString);
        }
        if (tokenizer.hasNext()) {
            throw new RiotException("Trailing characters in string: " + nodeString);
        }
        if (node.isURI() && (x = node.getURI()).indexOf(32) >= 0) {
            throw new RiotException("Space(s) in  IRI: " + nodeString);
        }
        return node;
    }

    private static QueryParseException makeException(String msg, int line, int column) {
        return new QueryParseException(msg, line, column);
    }

    public static Node createLiteralNode(String lex, String lang, String datatypeURI) {
        if (datatypeURI != null && datatypeURI.equals("")) {
            datatypeURI = null;
        }
        if (lang != null && lang.equals("")) {
            lang = null;
        }
        RDFDatatype dType = null;
        if (datatypeURI != null) {
            dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
        }
        Node n = Node.createLiteral((String)lex, (String)lang, (RDFDatatype)dType);
        return n;
    }

    public static int nodeToInt(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDinteger.isValidLiteral(lit)) {
            return Integer.MIN_VALUE;
        }
        int i = ((Number)lit.getValue()).intValue();
        return i;
    }

    public static long nodeToLong(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDinteger.isValidLiteral(lit)) {
            return Long.MIN_VALUE;
        }
        long i = ((Number)lit.getValue()).longValue();
        return i;
    }

    public static Node intToNode(int integer) {
        return Node.createLiteral((String)Integer.toString(integer), (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static Node intToNode(long integer) {
        return Node.createLiteral((String)Long.toString(integer), (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static Node floatToNode(float value) {
        return Node.createLiteral((String)Float.toString(value), (String)"", (RDFDatatype)XSDDatatype.XSDfloat);
    }

    public static Node nowAsDateTime() {
        String lex = Utils.nowAsXSDDateTimeString();
        return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static Node todayAsDate() {
        String lex = Utils.todayAsXSDDateString();
        return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDdate);
    }
}

