/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import com.hp.hpl.jena.sparql.graph.NodeTransformOp;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;

public class NodeTransformLib {
    public static Op transform(NodeTransform nodeTransform, Op op) {
        NodeTransformOp opTransform = new NodeTransformOp(nodeTransform);
        return Transformer.transform(opTransform, op);
    }

    public static BasicPattern transform(NodeTransform nodeTransform, BasicPattern pattern) {
        BasicPattern bgp2 = new BasicPattern();
        boolean changed = false;
        for (Triple triple : pattern) {
            Triple t2 = NodeTransformLib.transform(nodeTransform, triple);
            bgp2.add(t2);
            if (t2 == triple) continue;
            changed = true;
        }
        if (!changed) {
            return pattern;
        }
        return bgp2;
    }

    public static QuadPattern transform(NodeTransform nodeTransform, QuadPattern pattern) {
        QuadPattern qp2 = new QuadPattern();
        boolean changed = false;
        for (Quad quad : pattern) {
            Quad q2 = NodeTransformLib.transform(nodeTransform, quad);
            qp2.add(q2);
            if (q2 == quad) continue;
            changed = true;
        }
        if (!changed) {
            return pattern;
        }
        return qp2;
    }

    public static Triple transform(NodeTransform nodeTransform, Triple triple) {
        Node o1;
        Node p1;
        boolean change = false;
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Node s1 = nodeTransform.convert(s);
        if (s1 != s) {
            change = true;
            s = s1;
        }
        if ((p1 = nodeTransform.convert(p)) != p) {
            change = true;
            p = p1;
        }
        if ((o1 = nodeTransform.convert(o)) != o) {
            change = true;
            o = o1;
        }
        if (!change) {
            return triple;
        }
        return new Triple(s, p, o);
    }

    public static Quad transform(NodeTransform nodeTransform, Quad quad) {
        Node o1;
        Node p1;
        Node s1;
        boolean change = false;
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g = quad.getGraph();
        Node g1 = nodeTransform.convert(g);
        if (g1 != g) {
            change = true;
            g = g1;
        }
        if ((s1 = nodeTransform.convert(s)) != s) {
            change = true;
            s = s1;
        }
        if ((p1 = nodeTransform.convert(p)) != p) {
            change = true;
            p = p1;
        }
        if ((o1 = nodeTransform.convert(o)) != o) {
            change = true;
            o = o1;
        }
        if (!change) {
            return quad;
        }
        return new Quad(g, s, p, o);
    }

    public static List<Quad> transformQuads(NodeTransform nodeTransform, List<Quad> quads) {
        ArrayList<Quad> x = new ArrayList<Quad>();
        boolean changed = false;
        for (Quad q : quads) {
            Quad q2;
            if (q != (q2 = NodeTransformLib.transform(nodeTransform, q))) {
                changed = true;
            }
            x.add(q2);
        }
        if (!changed) {
            return quads;
        }
        return x;
    }

    public static VarExprList transform(NodeTransform nodeTransform, VarExprList varExprList) {
        VarExprList varExprList2 = new VarExprList();
        boolean changed = false;
        for (Var v : varExprList.getVars()) {
            Expr expr2;
            Expr expr = varExprList.getExpr(v);
            Var v2 = (Var)nodeTransform.convert((Node)v);
            Expr expr3 = expr2 = expr != null ? NodeTransformLib.transform(nodeTransform, expr) : null;
            if (!Lib.equal(v, v2) || !Lib.equal(expr, expr2)) {
                changed = true;
            }
            varExprList2.add(v2, expr2);
        }
        if (!changed) {
            return varExprList;
        }
        return varExprList2;
    }

    public static List<Var> transformVars(NodeTransform nodeTransform, List<Var> varList) {
        ArrayList<Var> varList2 = new ArrayList<Var>(varList.size());
        boolean changed = false;
        for (Var v : varList) {
            Var v2 = (Var)nodeTransform.convert((Node)v);
            varList2.add(v2);
            if (Lib.equal(v, v2)) continue;
            changed = true;
        }
        if (!changed) {
            return varList;
        }
        return varList2;
    }

    public static ExprList transform(NodeTransform nodeTransform, ExprList exprList) {
        ExprList exprList2 = new ExprList();
        boolean changed = false;
        for (Expr expr : exprList) {
            Expr expr2;
            if (expr != (expr2 = NodeTransformLib.transform(nodeTransform, expr))) {
                changed = true;
            }
            exprList2.add(expr2);
        }
        if (!changed) {
            return exprList;
        }
        return exprList2;
    }

    public static Expr transform(NodeTransform nodeTransform, Expr expr) {
        return expr.applyNodeTransform(nodeTransform);
    }

    public static List<SortCondition> transform(NodeTransform nodeTransform, List<SortCondition> conditions) {
        ArrayList<SortCondition> conditions2 = new ArrayList<SortCondition>();
        boolean same = true;
        for (SortCondition sc : conditions) {
            Expr expr2;
            Expr expr = sc.getExpression();
            if (expr != (expr2 = NodeTransformLib.transform(nodeTransform, expr))) {
                same = false;
            }
            SortCondition sc2 = new SortCondition(expr2, sc.getDirection());
            conditions2.add(sc2);
        }
        if (same) {
            return conditions;
        }
        return conditions2;
    }
}

