/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy.printer;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.TaxonomyPrinter;
import org.mindswap.pellet.utils.Comparators;

public class TreeTaxonomyPrinter<T>
implements TaxonomyPrinter<T> {
    static final String INDENT = "  ";
    protected Taxonomy<T> taxonomy;
    protected PrintWriter out;

    @Override
    public void print(Taxonomy<T> taxonomy) {
        this.print(taxonomy, new PrintWriter(System.out));
    }

    @Override
    public void print(Taxonomy<T> taxonomy, PrintWriter printWriter) {
        this.taxonomy = taxonomy;
        this.out = printWriter;
        printWriter.println();
        this.printTree();
        printWriter.println();
        printWriter.flush();
    }

    protected void printTree() {
        TreeSet<Object> treeSet = new TreeSet<Object>(Comparators.stringComparator);
        treeSet.add(this.taxonomy.getTop().getName());
        treeSet.addAll(this.taxonomy.getTop().getEquivalents());
        this.printTree(treeSet, " ");
        TreeSet<Object> treeSet2 = new TreeSet<Object>(Comparators.stringComparator);
        treeSet2.add(this.taxonomy.getBottom().getName());
        treeSet2.addAll(this.taxonomy.getBottom().getEquivalents());
        if (treeSet2.size() > 1) {
            this.printNode(treeSet2, " ");
        }
    }

    protected void printTree(Set<T> set, String string) {
        if (set.contains(this.taxonomy.getBottom().getName())) {
            return;
        }
        this.printNode(set, string);
        T t = set.iterator().next();
        Set<Set<T>> set2 = this.ss(this.taxonomy.getSubs(t, true));
        for (Set<T> set3 : set2) {
            if (set3.contains(t)) continue;
            this.printTree(this.s(set3), string + "   ");
        }
    }

    protected void printNode(Set<T> set, String string) {
        this.out.print(string);
        this.printNode(set);
        this.out.println();
    }

    protected void printNode(Set<T> set) {
        Iterator<T> iterator = set.iterator();
        T t = iterator.next();
        this.printURI(this.out, t);
        while (iterator.hasNext()) {
            this.out.print(" = ");
            this.printURI(this.out, iterator.next());
        }
    }

    protected void printURI(PrintWriter printWriter, T t) {
        printWriter.print(t.toString());
    }

    private Set<Set<T>> ss(Set<Set<T>> set) {
        TreeSet<Object> treeSet = new TreeSet<Object>(Comparators.stringComparator);
        treeSet.addAll(set);
        return treeSet;
    }

    private Set<T> s(Set<T> set) {
        TreeSet<Object> treeSet = new TreeSet<Object>(Comparators.stringComparator);
        treeSet.addAll(set);
        return treeSet;
    }
}

