/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UnionQueryAtom
implements QueryAtom {
    private List<List<QueryAtom>> union;
    private boolean isGround;
    private List<ATermAppl> args;

    public UnionQueryAtom(List<QueryAtom> list, List<QueryAtom> list2) {
        this(Arrays.asList(list, list2));
    }

    public UnionQueryAtom(List<List<QueryAtom>> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty collection of atoms not allowed in NotKnown atom");
        }
        this.union = Collections.unmodifiableList(list);
        this.isGround = true;
        this.args = new ArrayList<ATermAppl>();
        for (List<QueryAtom> list2 : list) {
            for (QueryAtom queryAtom : list2) {
                this.args.addAll(queryAtom.getArguments());
                if (!this.isGround || queryAtom.isGround()) continue;
                this.isGround = false;
            }
        }
    }

    @Override
    public QueryAtom apply(ResultBinding resultBinding) {
        ArrayList<List<QueryAtom>> arrayList = new ArrayList<List<QueryAtom>>();
        for (List<QueryAtom> list : this.union) {
            ArrayList<QueryAtom> arrayList2 = new ArrayList<QueryAtom>();
            for (QueryAtom queryAtom : list) {
                arrayList2.add(queryAtom.apply(resultBinding));
            }
            arrayList.add(arrayList2);
        }
        return new UnionQueryAtom(arrayList);
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnionQueryAtom)) {
            return false;
        }
        return this.union.equals(((UnionQueryAtom)object).union);
    }

    @Override
    public List<ATermAppl> getArguments() {
        return this.args;
    }

    public List<List<QueryAtom>> getUnion() {
        return this.union;
    }

    @Override
    public QueryPredicate getPredicate() {
        return QueryPredicate.Union;
    }

    public int hashCode() {
        return 31 * this.union.hashCode();
    }

    @Override
    public boolean isGround() {
        return this.isGround;
    }

    public String toString() {
        return "Union" + this.union;
    }
}

