/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.expressivity;

import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Set;

public class Expressivity {
    private boolean hasNegation = false;
    private boolean hasAllValues = false;
    private boolean hasDisjointClasses = false;
    private boolean hasInverse = false;
    private boolean hasFunctionality = false;
    private boolean hasCardinality = false;
    private boolean hasCardinalityQ = false;
    private boolean hasFunctionalityD = false;
    private boolean hasCardinalityD = false;
    private boolean hasTransitivity = false;
    private boolean hasRoleHierarchy = false;
    private boolean hasReflexivity = false;
    private boolean hasIrreflexivity = false;
    private boolean hasDisjointRoles = false;
    private boolean hasAsymmetry = false;
    private boolean hasComplexSubRoles = false;
    private boolean hasDatatype = false;
    private boolean hasUserDefinedDatatype = false;
    private boolean hasKeys = false;
    private boolean hasDomain = false;
    private boolean hasRange = false;
    private boolean hasIndividual = false;
    private Set<ATermAppl> nominals = new HashSet<ATermAppl>();
    private Set<ATermAppl> anonInverses = new HashSet<ATermAppl>();

    public Expressivity() {
    }

    public Expressivity(Expressivity expressivity) {
        this.hasNegation = expressivity.hasNegation;
        this.hasAllValues = expressivity.hasAllValues;
        this.hasDisjointClasses = expressivity.hasDisjointClasses;
        this.hasInverse = expressivity.hasInverse;
        this.hasFunctionality = expressivity.hasFunctionality;
        this.hasCardinality = expressivity.hasCardinality;
        this.hasCardinalityQ = expressivity.hasCardinalityQ;
        this.hasFunctionalityD = expressivity.hasFunctionalityD;
        this.hasCardinalityD = expressivity.hasCardinalityD;
        this.hasTransitivity = expressivity.hasTransitivity;
        this.hasRoleHierarchy = expressivity.hasRoleHierarchy;
        this.hasReflexivity = expressivity.hasReflexivity;
        this.hasIrreflexivity = expressivity.hasIrreflexivity;
        this.hasDisjointRoles = expressivity.hasDisjointRoles;
        this.hasAsymmetry = expressivity.hasAsymmetry;
        this.hasComplexSubRoles = expressivity.hasComplexSubRoles;
        this.hasDatatype = expressivity.hasDatatype;
        this.hasKeys = expressivity.hasKeys;
        this.hasDomain = expressivity.hasDomain;
        this.hasRange = expressivity.hasRange;
        this.hasIndividual = expressivity.hasIndividual;
        this.nominals = new HashSet<ATermAppl>(expressivity.nominals);
        this.anonInverses = new HashSet<ATermAppl>(expressivity.anonInverses);
    }

    public boolean isEL() {
        return !this.hasNegation && !this.hasAllValues && !this.hasInverse && !this.hasFunctionality && !this.hasCardinality && !this.hasCardinalityQ && !this.hasFunctionalityD && !this.hasCardinalityD && !this.hasIrreflexivity && !this.hasDisjointRoles && !this.hasAsymmetry && !this.hasDatatype && !this.hasKeys && !this.hasIndividual && this.nominals.isEmpty();
    }

    public String toString() {
        String string = "";
        if (this.isEL()) {
            string = "EL";
            if (this.hasComplexSubRoles || this.hasReflexivity || this.hasDomain || this.hasRange || this.hasDisjointClasses) {
                string = string + "+";
            } else if (this.hasRoleHierarchy) {
                string = string + "H";
            }
        } else {
            string = "AL";
            if (this.hasNegation) {
                string = "ALC";
            }
            if (this.hasTransitivity) {
                string = string + "R+";
            }
            if (string.equals("ALCR+")) {
                string = "S";
            }
            if (this.hasComplexSubRoles) {
                string = "SR";
            } else if (this.hasRoleHierarchy) {
                string = string + "H";
            }
            if (this.hasNominal()) {
                string = string + "O";
            }
            if (this.hasInverse) {
                string = string + "I";
            }
            if (this.hasCardinalityQ) {
                string = string + "Q";
            } else if (this.hasCardinality) {
                string = string + "N";
            } else if (this.hasFunctionality) {
                string = string + "F";
            }
            if (this.hasDatatype) {
                string = this.hasKeys ? string + "(Dk)" : string + "(D)";
            }
        }
        return string;
    }

    public boolean hasNegation() {
        return this.hasNegation;
    }

    public void setHasNegation(boolean bl) {
        this.hasNegation = bl;
    }

    public boolean hasAllValues() {
        return this.hasAllValues;
    }

    public void setHasAllValues(boolean bl) {
        this.hasAllValues = bl;
    }

    public boolean hasDisjointClasses() {
        return this.hasDisjointClasses;
    }

    public void setHasDisjointClasses(boolean bl) {
        this.hasDisjointClasses = bl;
    }

    public boolean hasInverse() {
        return this.hasInverse;
    }

    public void setHasInverse(boolean bl) {
        this.hasInverse = bl;
    }

    public boolean hasFunctionality() {
        return this.hasFunctionality;
    }

    public void setHasFunctionality(boolean bl) {
        this.hasFunctionality = bl;
    }

    public boolean hasCardinality() {
        return this.hasCardinality;
    }

    public void setHasCardinality(boolean bl) {
        this.hasCardinality = bl;
    }

    public boolean hasCardinalityQ() {
        return this.hasCardinalityQ;
    }

    public void setHasCardinalityQ(boolean bl) {
        this.hasCardinalityQ = bl;
    }

    public boolean hasFunctionalityD() {
        return this.hasFunctionalityD;
    }

    public void setHasFunctionalityD(boolean bl) {
        this.hasFunctionalityD = bl;
    }

    public boolean hasCardinalityD() {
        return this.hasCardinalityD;
    }

    public void setHasCardinalityD(boolean bl) {
        this.hasCardinalityD = bl;
    }

    public boolean hasTransitivity() {
        return this.hasTransitivity;
    }

    public void setHasTransitivity(boolean bl) {
        this.hasTransitivity = bl;
    }

    public boolean hasRoleHierarchy() {
        return this.hasRoleHierarchy;
    }

    public void setHasRoleHierarchy(boolean bl) {
        this.hasRoleHierarchy = bl;
    }

    public boolean hasReflexivity() {
        return this.hasReflexivity;
    }

    public void setHasReflexivity(boolean bl) {
        this.hasReflexivity = bl;
    }

    public boolean hasIrreflexivity() {
        return this.hasIrreflexivity;
    }

    public void setHasIrreflexivity(boolean bl) {
        this.hasIrreflexivity = bl;
    }

    public boolean hasDisjointRoles() {
        return this.hasDisjointRoles;
    }

    public void setHasDisjointRoles(boolean bl) {
        this.hasDisjointRoles = bl;
    }

    public boolean hasAntiSymmmetry() {
        return this.hasAsymmetry;
    }

    public boolean hasAsymmmetry() {
        return this.hasAsymmetry;
    }

    public void setHasAntiSymmetry(boolean bl) {
        this.hasAsymmetry = bl;
    }

    public void setHasAsymmetry(boolean bl) {
        this.hasAsymmetry = bl;
    }

    public boolean hasComplexSubRoles() {
        return this.hasComplexSubRoles;
    }

    public void setHasComplexSubRoles(boolean bl) {
        this.hasComplexSubRoles = bl;
    }

    public boolean hasDatatype() {
        return this.hasDatatype;
    }

    public void setHasDatatype(boolean bl) {
        this.hasDatatype = bl;
    }

    public boolean hasUserDefinedDatatype() {
        return this.hasUserDefinedDatatype;
    }

    public void setHasUserDefinedDatatype(boolean bl) {
        if (bl) {
            this.setHasDatatype(true);
        }
        this.hasUserDefinedDatatype = bl;
    }

    public boolean hasKeys() {
        return this.hasKeys;
    }

    public void setHasKeys(boolean bl) {
        this.hasKeys = bl;
    }

    public boolean hasDomain() {
        return this.hasDomain;
    }

    public void setHasDomain(boolean bl) {
        this.hasDomain = bl;
    }

    public boolean hasRange() {
        return this.hasRange;
    }

    public void setHasRange(boolean bl) {
        this.hasRange = bl;
    }

    public boolean hasIndividual() {
        return this.hasIndividual;
    }

    public void setHasIndividual(boolean bl) {
        this.hasIndividual = bl;
    }

    public boolean hasNominal() {
        return !this.nominals.isEmpty();
    }

    public Set<ATermAppl> getNominals() {
        return this.nominals;
    }

    public void addNominal(ATermAppl aTermAppl) {
        this.nominals.add(aTermAppl);
    }

    public Set<ATermAppl> getAnonInverses() {
        return this.anonInverses;
    }

    public void addAnonInverse(ATermAppl aTermAppl) {
        this.anonInverses.add(aTermAppl);
    }
}

