/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ReifiedStatementImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementBase;

public class StatementImpl
extends StatementBase
implements Statement {
    protected Resource subject;
    protected Property predicate;
    protected RDFNode object;
    protected static ModelCom empty = (ModelCom)ModelFactory.createDefaultModel();

    public StatementImpl(Resource subject, Property predicate, RDFNode object, ModelCom model) {
        super(model);
        this.subject = subject.inModel(model);
        this.predicate = predicate.inModel(model);
        this.object = object.inModel(model);
    }

    public StatementImpl(Resource subject, Property predicate, RDFNode object) {
        super(empty);
        this.subject = subject.inModel(this.model);
        this.predicate = predicate.inModel(this.model);
        this.object = object.inModel(this.model);
    }

    public static Statement toStatement(Triple t, ModelCom eg) {
        ResourceImpl s = new ResourceImpl(t.getSubject(), eg);
        PropertyImpl p = new PropertyImpl(t.getPredicate(), (EnhGraph)eg);
        RDFNode o = StatementImpl.createObject(t.getObject(), eg);
        return new StatementImpl(s, p, o, eg);
    }

    @Override
    public Resource getSubject() {
        return this.subject;
    }

    @Override
    public Property getPredicate() {
        return this.predicate;
    }

    @Override
    public RDFNode getObject() {
        return this.object;
    }

    @Override
    public Statement getStatementProperty(Property p) {
        return this.asResource().getRequiredProperty(p);
    }

    @Override
    public Resource getResource() {
        return this.mustBeResource(this.object);
    }

    @Override
    @Deprecated
    public Resource getResource(ResourceF f) {
        return f.createResource(this.getResource());
    }

    @Override
    public Statement getProperty(Property p) {
        return this.getResource().getRequiredProperty(p);
    }

    @Override
    public Literal getLiteral() {
        if (this.object instanceof Literal) {
            return (Literal)this.object;
        }
        throw new LiteralRequiredException(this.object);
    }

    @Override
    public Bag getBag() {
        return this.object.as(Bag.class);
    }

    @Override
    public Alt getAlt() {
        return this.object.as(Alt.class);
    }

    @Override
    public Seq getSeq() {
        return this.object.as(Seq.class);
    }

    @Override
    protected StatementImpl replace(RDFNode n) {
        StatementImpl s = new StatementImpl(this.subject, this.predicate, n, this.model);
        this.model.remove(this).add(s);
        return s;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Statement && this.sameAs((Statement)o);
    }

    private final boolean sameAs(Statement o) {
        return this.subject.equals(o.getSubject()) && this.predicate.equals(o.getPredicate()) && this.object.equals(o.getObject());
    }

    @Override
    public int hashCode() {
        return this.asTriple().hashCode();
    }

    public Resource asResource() {
        return this.model.getAnyReifiedStatement(this);
    }

    @Override
    public Statement remove() {
        this.model.remove(this);
        return this;
    }

    @Override
    public void removeReification() {
        this.model.removeAllReifications(this);
    }

    @Override
    public Triple asTriple() {
        return Triple.create(this.subject.asNode(), this.predicate.asNode(), this.object.asNode());
    }

    public static Triple[] asTriples(Statement[] statements) {
        Triple[] triples = new Triple[statements.length];
        for (int i = 0; i < statements.length; ++i) {
            triples[i] = statements[i].asTriple();
        }
        return triples;
    }

    @Override
    public boolean isReified() {
        return this.model.isReified(this);
    }

    @Override
    public ReifiedStatement createReifiedStatement() {
        return ReifiedStatementImpl.create(this);
    }

    @Override
    public ReifiedStatement createReifiedStatement(String uri) {
        return ReifiedStatementImpl.create((ModelCom)this.getModel(), uri, (Statement)this);
    }

    @Override
    public RSIterator listReifiedStatements() {
        return this.model.listReifiedStatements(this);
    }

    public static RDFNode createObject(Node n, EnhGraph g) {
        return n.isLiteral() ? new LiteralImpl(n, g) : new ResourceImpl(n, g);
    }
}

