/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader2;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.setup.DatasetBuilderStd;
import com.hp.hpl.jena.tdb.solver.stats.Stats;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollectorNodeId;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.bulkloader.BulkLoader;
import com.hp.hpl.jena.tdb.store.bulkloader.BulkStreamRDF;
import com.hp.hpl.jena.tdb.store.bulkloader2.ProgressLogger;
import com.hp.hpl.jena.tdb.store.bulkloader2.WriteRows;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.system.StreamRDF;
import org.slf4j.Logger;
import tdb.cmdline.CmdTDB;

public class CmdNodeTableBuilder
extends CmdGeneral {
    private static Logger cmdLog;
    private static ArgDecl argLocation;
    private static ArgDecl argTriplesOut;
    private static ArgDecl argQuadsOut;
    private String locationString;
    private String dataFileTriples;
    private String dataFileQuads;
    private List<String> datafiles;
    private Location location;

    public static void main(String ... argv) {
        CmdTDB.init();
        DatasetBuilderStd.setOptimizerWarningFlag(false);
        new CmdNodeTableBuilder(argv).mainRun();
    }

    public CmdNodeTableBuilder(String ... argv) {
        super(argv);
        super.add(argLocation, "--loc", "Location");
        super.add(argTriplesOut, "--triples", "Output file for triples");
        super.add(argQuadsOut, "--quads", "Output file for quads");
    }

    protected void processModulesAndArgs() {
        if (!super.contains(argLocation)) {
            throw new CmdException("Required: --loc DIR");
        }
        this.locationString = super.getValue(argLocation);
        this.location = new Location(this.locationString);
        this.dataFileTriples = super.getValue(argTriplesOut);
        if (this.dataFileTriples == null) {
            this.dataFileTriples = this.location.getPath("triples", "tmp");
        }
        this.dataFileQuads = super.getValue(argQuadsOut);
        if (this.dataFileQuads == null) {
            this.dataFileQuads = this.location.getPath("quads", "tmp");
        }
        if (Lib.equal((Object)this.dataFileTriples, (Object)this.dataFileQuads)) {
            this.cmdError("Triples and Quads work files are the same");
        }
        this.datafiles = this.getPositional();
        if (this.datafiles.isEmpty()) {
            this.datafiles = Arrays.asList("-");
        }
        for (String filename : this.datafiles) {
            Lang lang = RDFLanguages.filenameToLang((String)filename, (Lang)RDFLanguages.NQUADS);
            if (lang == null) {
                this.cmdError("File suffix not recognized: " + filename);
            }
            if (FileOps.exists((String)filename)) continue;
            this.cmdError("File does not exist: " + filename);
        }
    }

    protected void exec() {
        DatasetGraphTDB dsg = DatasetBuilderStd.build(this.location);
        dsg.getTripleTable().getNodeTupleTable().getTupleTable().close();
        dsg.getQuadTable().getNodeTupleTable().getTupleTable().close();
        dsg.getPrefixes().close();
        ProgressLogger monitor = new ProgressLogger(cmdLog, "Data", BulkLoader.DataTickPoint, BulkLoader.superTick);
        FileOutputStream outputTriples = null;
        FileOutputStream outputQuads = null;
        try {
            outputTriples = new FileOutputStream(this.dataFileTriples);
            outputQuads = new FileOutputStream(this.dataFileQuads);
        }
        catch (FileNotFoundException e) {
            throw new AtlasException((Throwable)e);
        }
        NodeTableBuilder sink = new NodeTableBuilder(dsg, monitor, outputTriples, outputQuads);
        monitor.start();
        sink.startBulk();
        for (String filename : this.datafiles) {
            if (this.datafiles.size() > 0) {
                cmdLog.info("Load: " + filename + " -- " + Utils.nowAsString());
            }
            RiotReader.parse((String)filename, (StreamRDF)sink);
        }
        sink.finishBulk();
        IO.close((Closeable)outputTriples);
        IO.close((Closeable)outputQuads);
        if (!this.location.isMem()) {
            Stats.write(dsg, sink.getCollector());
        }
        long time = monitor.finish();
        long total = monitor.getTicks();
        float elapsedSecs = (float)time / 1000.0f;
        float rate = elapsedSecs != 0.0f ? (float)total / elapsedSecs : 0.0f;
        String str = String.format("Total: %,d tuples : %,.2f seconds : %,.2f tuples/sec [%s]", total, Float.valueOf(elapsedSecs), Float.valueOf(rate), Utils.nowAsString());
        cmdLog.info(str);
    }

    protected String getSummary() {
        return this.getCommandName() + " --loc=DIR [--triples=tmpFile1] [--quads=tmpFile2] FILE ...";
    }

    protected String getCommandName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    static {
        Log.setLog4j();
        cmdLog = TDB.logLoader;
        argLocation = new ArgDecl(true, "loc", "location");
        argTriplesOut = new ArgDecl(true, "triples");
        argQuadsOut = new ArgDecl(true, "quads");
    }

    static class NodeTableBuilder
    implements BulkStreamRDF {
        private DatasetGraphTDB dsg;
        private NodeTable nodeTable;
        private WriteRows writerTriples;
        private WriteRows writerQuads;
        private ProgressLogger monitor;
        private StatsCollectorNodeId stats;

        NodeTableBuilder(DatasetGraphTDB dsg, ProgressLogger monitor, OutputStream outputTriples, OutputStream outputQuads) {
            this.dsg = dsg;
            this.monitor = monitor;
            NodeTupleTable ntt = dsg.getTripleTable().getNodeTupleTable();
            this.nodeTable = ntt.getNodeTable();
            this.writerTriples = new WriteRows(outputTriples, 3, 20000);
            this.writerQuads = new WriteRows(outputQuads, 4, 20000);
            this.stats = new StatsCollectorNodeId();
        }

        @Override
        public void startBulk() {
        }

        public void start() {
        }

        public void finish() {
        }

        @Override
        public void finishBulk() {
            this.writerTriples.flush();
            this.writerQuads.flush();
            this.nodeTable.sync();
        }

        public void triple(Triple triple) {
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            this.process(Quad.tripleInQuad, s, p, o);
        }

        public void quad(Quad quad) {
            Node s = quad.getSubject();
            Node p = quad.getPredicate();
            Node o = quad.getObject();
            Node g = null;
            if (!quad.isTriple() && !quad.isDefaultGraph()) {
                g = quad.getGraph();
            }
            this.process(g, s, p, o);
        }

        private void process(Node g, Node s, Node p, Node o) {
            NodeId sId = this.nodeTable.getAllocateNodeId(s);
            NodeId pId = this.nodeTable.getAllocateNodeId(p);
            NodeId oId = this.nodeTable.getAllocateNodeId(o);
            if (g != null) {
                NodeId gId = this.nodeTable.getAllocateNodeId(g);
                this.writerQuads.write(gId.getId());
                this.writerQuads.write(sId.getId());
                this.writerQuads.write(pId.getId());
                this.writerQuads.write(oId.getId());
                this.writerQuads.endOfRow();
                this.stats.record(gId, sId, pId, oId);
            } else {
                this.writerTriples.write(sId.getId());
                this.writerTriples.write(pId.getId());
                this.writerTriples.write(oId.getId());
                this.writerTriples.endOfRow();
                this.stats.record(null, sId, pId, oId);
            }
            this.monitor.tick();
        }

        public StatsCollectorNodeId getCollector() {
            return this.stats;
        }

        public void tuple(Tuple<Node> tuple) {
            throw new TDBException("Unexpected: tuple in bulk load (expected quads or triples)");
        }

        public void base(String base) {
        }

        public void prefix(String prefix, String iri) {
        }
    }
}

