/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class ProgressAdapter
implements ProgressMonitor {
    private ReasonerProgressMonitor monitor;
    private int length;
    private int progress;
    private String title;

    public ProgressAdapter(ReasonerProgressMonitor reasonerProgressMonitor) {
        this.monitor = reasonerProgressMonitor;
        this.progress = 0;
        this.length = -1;
        this.title = "<untitled>";
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getProgressPercent() {
        return this.length > 0 ? this.progress * 100 / this.length : 0;
    }

    @Override
    public void incrementProgress() {
        ++this.progress;
        if (this.length > 0) {
            this.monitor.reasonerTaskProgressChanged(this.progress, this.length);
        } else {
            this.monitor.reasonerTaskBusy();
        }
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void setProgress(int n) {
        this.progress = n;
        if (this.length > 0) {
            this.monitor.reasonerTaskProgressChanged(this.progress, this.length);
        } else {
            this.monitor.reasonerTaskBusy();
        }
    }

    @Override
    public void setProgressLength(int n) {
        this.length = n;
        if (n > 0) {
            this.monitor.reasonerTaskProgressChanged(this.progress, n);
        } else {
            this.monitor.reasonerTaskBusy();
        }
    }

    @Override
    public void setProgressMessage(String string) {
    }

    @Override
    public void setProgressTitle(String string) {
        this.title = string;
    }

    @Override
    public void taskFinished() {
        this.monitor.reasonerTaskStopped();
    }

    @Override
    public void taskStarted() {
        this.monitor.reasonerTaskStarted(this.title);
    }
}

