/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.engine.main.JoinClassifier;
import com.hp.hpl.jena.sparql.engine.main.LeftJoinClassifier;

public class TransformJoinStrategy
extends TransformCopy {
    @Override
    public Op transform(OpJoin opJoin, Op left, Op right) {
        boolean canDoLinear = JoinClassifier.isLinear(opJoin);
        if (canDoLinear) {
            boolean b;
            if (right instanceof OpTable && (b = JoinClassifier.isLinear(right, left))) {
                Op tmp = left;
                left = right;
                right = tmp;
            }
            return OpSequence.create(left, right);
        }
        return super.transform(opJoin, left, right);
    }

    @Override
    public Op transform(OpLeftJoin opLeftJoin, Op opLeft, Op opRight) {
        boolean canDoLinear = LeftJoinClassifier.isLinear(opLeftJoin);
        if (canDoLinear) {
            if (opLeftJoin.getExprs() != null) {
                opRight = OpFilter.filter(opLeftJoin.getExprs(), opRight);
            }
            return new OpConditional(opLeft, opRight);
        }
        return super.transform(opLeftJoin, opLeft, opRight);
    }
}

