/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class StatisticsTable<ROW, COL> {
    private static final Logger log = Logger.getLogger(StatisticsTable.class.getName());
    private Map<COL, Map<ROW, Number>> statistics = new HashMap<COL, Map<ROW, Number>>();
    private List<COL> cols = new ArrayList<COL>();
    private List<ROW> rows = new ArrayList<ROW>();
    private int firstColumnSize = 10;

    public void add(ROW ROW, COL COL, Number number) {
        Number number2;
        Map<ROW, Number> map = this.statistics.get(COL);
        if (map == null) {
            map = new HashMap<ROW, Number>();
            this.statistics.put(COL, map);
            this.cols.add(COL);
        }
        if ((number2 = map.get(ROW)) != null) {
            log.warning("Overwriting [" + ROW + " : " + COL + "].");
        } else if (!this.rows.contains(ROW)) {
            if (this.firstColumnSize < ROW.toString().length()) {
                this.firstColumnSize = ROW.toString().length();
            }
            this.rows.add(ROW);
        }
        map.put(ROW, number);
    }

    public void add(COL COL, Map<ROW, ? extends Number> map) {
        for (Map.Entry<ROW, Number> entry : map.entrySet()) {
            this.add(entry.getKey(), COL, entry.getValue());
        }
    }

    public String toString() {
        Object object2;
        String string = "";
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Object object2 : this.cols) {
            arrayList.add(object2.toString().length() + 2);
        }
        String string2 = "| %1$-" + (this.firstColumnSize + 2) + "s ";
        object2 = new StringBuffer();
        for (int i = 1; i < arrayList.size() + 1; ++i) {
            ((StringBuffer)object2).append("| %").append(i).append("$-10.10s ");
        }
        ((StringBuffer)object2).append("|\n");
        char[] cArray = new char[String.format(((StringBuffer)object2).toString(), this.cols.toArray()).length() + String.format(string2, "").length()];
        Arrays.fill(cArray, '=');
        String string3 = new String(cArray);
        string = string + string3 + "\n";
        string = string + String.format(string2, "") + String.format(((StringBuffer)object2).toString(), this.cols.toArray());
        string = string + string3 + "\n";
        for (ROW ROW : this.rows) {
            ArrayList<Number> arrayList2 = new ArrayList<Number>();
            for (COL COL : this.cols) {
                Map<ROW, Number> map = this.statistics.get(COL);
                Number number = map.get(ROW);
                if (number == null) {
                    arrayList2.add(Double.POSITIVE_INFINITY);
                    continue;
                }
                arrayList2.add(number);
            }
            String string4 = ROW.toString();
            string = string + String.format(string2, string4) + String.format(((StringBuffer)object2).toString(), arrayList2.toArray());
        }
        string = string + string3 + "\n";
        return string;
    }
}

