/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy.printer;

import aterm.ATermAppl;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.taxonomy.printer.TaxonomyPrinter;
import org.mindswap.pellet.taxonomy.printer.TreeTaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.TaxonomyUtils;

public class ClassTreePrinter
extends TreeTaxonomyPrinter<ATermAppl>
implements TaxonomyPrinter<ATermAppl> {
    private QNameProvider qnames = new QNameProvider();

    @Override
    protected void printNode(Set<ATermAppl> set) {
        super.printNode(set);
        Set set2 = TaxonomyUtils.getDirectInstances(this.taxonomy, set.iterator().next());
        if (set2.size() > 0) {
            this.out.print(" - (");
            boolean bl = false;
            int n = 0;
            Iterator iterator = set2.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                ATermAppl aTermAppl = (ATermAppl)iterator.next();
                if (ATermUtils.isBnode(aTermAppl)) {
                    ++n;
                } else {
                    if (bl) {
                        this.out.print(", ");
                    } else {
                        bl = true;
                    }
                    this.printURI(this.out, aTermAppl);
                }
                ++n2;
            }
            if (n > 0) {
                if (bl) {
                    this.out.print(", ");
                }
                this.out.print(n + " Anonymous Individual");
                if (n > 1) {
                    this.out.print("s");
                }
            }
            this.out.print(")");
        }
    }

    @Override
    protected void printURI(PrintWriter printWriter, ATermAppl aTermAppl) {
        String string = null;
        string = aTermAppl.equals(ATermUtils.TOP) ? "http://www.w3.org/2002/07/owl#Thing" : (aTermAppl.equals(ATermUtils.BOTTOM) ? "http://www.w3.org/2002/07/owl#Nothing" : (ATermUtils.isPrimitive(aTermAppl) ? aTermAppl.getName() : aTermAppl.toString()));
        printWriter.print(string);
    }
}

