/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class SelfRule
extends AbstractTableauRule {
    public SelfRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.ATOM, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public final void apply(Individual individual) {
        List<ATermAppl> list = individual.getTypes(0);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ATermAppl aTermAppl = list.get(i);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && individual.getDepends((ATerm)aTermAppl) == null || !ATermUtils.isSelf(aTermAppl)) continue;
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            Role role = this.strategy.getABox().getRole((ATerm)aTermAppl2);
            if (log.isLoggable(Level.FINE) && !individual.hasRSuccessor(role, individual)) {
                log.fine("SELF: " + individual + " " + role + " " + individual.getDepends((ATerm)aTermAppl));
            }
            this.strategy.addEdge(individual, role, individual, individual.getDepends((ATerm)aTermAppl));
            if (!this.strategy.getABox().isClosed()) continue;
            return;
        }
    }
}

