/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class AllValuesRule
extends AbstractTableauRule {
    public AllValuesRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.UNIVERSAL, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public void apply(Individual individual) {
        List<ATermAppl> list = individual.getTypes(3);
        int n = list.size();
        Iterator<ATermAppl> iterator = list.iterator();
        while (iterator.hasNext()) {
            ATermAppl aTermAppl = iterator.next();
            DependencySet dependencySet = individual.getDepends((ATerm)aTermAppl);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && dependencySet == null) continue;
            this.applyAllValues(individual, aTermAppl, dependencySet);
            if (individual.isMerged() || this.strategy.getABox().isClosed()) {
                return;
            }
            if (n == list.size()) continue;
            iterator = list.iterator();
            n = list.size();
        }
    }

    public void applyAllValues(Individual individual, ATermAppl aTermAppl, DependencySet dependencySet) {
        DependencySet dependencySet2;
        if (aTermAppl.getArity() == 0) {
            throw new InternalReasonerException();
        }
        ATerm aTerm = aTermAppl.getArgument(0);
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(1);
        ATermList aTermList = ATermUtils.EMPTY_LIST;
        Role role = null;
        if (aTerm.getType() == 4) {
            aTermList = (ATermList)aTerm;
            role = this.strategy.getABox().getRole(aTermList.getFirst());
            aTermList = aTermList.getNext();
        } else {
            role = this.strategy.getABox().getRole(aTerm);
        }
        if (role.isTop() && role.isObjectRole()) {
            this.applyAllValuesTop(aTermAppl, aTermAppl2, dependencySet);
            return;
        }
        EdgeList edgeList = individual.getRNeighborEdges(role);
        for (int i = 0; i < edgeList.size(); ++i) {
            Edge edge = edgeList.edgeAt(i);
            Node node = edge.getNeighbor(individual);
            dependencySet2 = dependencySet.union(edge.getDepends(), this.strategy.getABox().doExplanation());
            if (aTermList.isEmpty()) {
                this.applyAllValues(individual, role, node, aTermAppl2, dependencySet2);
            } else if (node.isIndividual()) {
                ATermAppl aTermAppl3 = ATermUtils.makeAllValues((ATerm)aTermList, (ATerm)aTermAppl2);
                this.strategy.addType(node, aTermAppl3, dependencySet2);
            }
            if (!individual.isMerged() && !this.strategy.getABox().isClosed()) continue;
            return;
        }
        if (!role.isSimple()) {
            Set<ATermList> set = role.getSubRoleChains();
            for (ATermList aTermList2 : set) {
                if (this.applyAllValuesPropertyChain(individual, aTermList2, aTermAppl2, dependencySet2 = dependencySet.union(role.getExplainSub((ATerm)aTermList2), this.strategy.getABox().doExplanation()))) continue;
                return;
            }
        }
        if (!aTermList.isEmpty()) {
            this.applyAllValuesPropertyChain(individual, (ATermList)aTerm, aTermAppl2, dependencySet);
        }
    }

    protected boolean applyAllValuesPropertyChain(Individual individual, ATermList aTermList, ATermAppl aTermAppl, DependencySet dependencySet) {
        Role role = this.strategy.getABox().getRole(aTermList.getFirst());
        EdgeList edgeList = individual.getRNeighborEdges(role);
        if (!edgeList.isEmpty()) {
            ATermAppl aTermAppl2 = ATermUtils.makeAllValues((ATerm)aTermList.getNext(), (ATerm)aTermAppl);
            for (int i = 0; i < edgeList.size(); ++i) {
                Edge edge = edgeList.edgeAt(i);
                Node node = edge.getNeighbor(individual);
                DependencySet dependencySet2 = dependencySet.union(edge.getDepends(), this.strategy.getABox().doExplanation());
                this.applyAllValues(individual, role, node, aTermAppl2, dependencySet2);
                if (!individual.isMerged() && !this.strategy.getABox().isClosed()) continue;
                return false;
            }
        }
        return true;
    }

    protected void applyAllValues(Individual individual, Role role, Node node, ATermAppl aTermAppl, DependencySet dependencySet) {
        if (!node.hasType((ATerm)aTermAppl)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("ALL : " + individual + " -> " + role + " -> " + node + " : " + ATermUtils.toString(aTermAppl) + " - " + dependencySet);
            }
            if (PelletOptions.USE_COMPLETION_QUEUE && !PelletOptions.MAINTAIN_COMPLETION_QUEUE && node.isPruned()) {
                return;
            }
            this.strategy.addType(node, aTermAppl, dependencySet);
        }
    }

    public void applyAllValues(Individual individual, Role role, Node node, DependencySet dependencySet) {
        List<ATermAppl> list = individual.getTypes(3);
        int n = list.size();
        Iterator<ATermAppl> iterator = list.iterator();
        while (iterator.hasNext()) {
            ATermAppl aTermAppl;
            DependencySet dependencySet2;
            ATermAppl aTermAppl2 = iterator.next();
            ATerm aTerm = aTermAppl2.getArgument(0);
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(1);
            ATermList aTermList = ATermUtils.EMPTY_LIST;
            Role role2 = null;
            if (aTerm.getType() == 4) {
                aTermList = (ATermList)aTerm;
                role2 = this.strategy.getABox().getRole(aTermList.getFirst());
                aTermList = aTermList.getNext();
            } else {
                role2 = this.strategy.getABox().getRole(aTerm);
            }
            if (role2.isTop() && role2.isObjectRole()) {
                this.applyAllValuesTop(aTermAppl2, aTermAppl3, dependencySet);
                if (!this.strategy.getABox().isClosed()) continue;
                return;
            }
            if (role.isSubRoleOf(role2)) {
                dependencySet2 = individual.getDepends((ATerm)aTermAppl2);
                dependencySet2 = dependencySet2.union(dependencySet, this.strategy.getABox().doExplanation());
                dependencySet2 = dependencySet2.union(role2.getExplainSubOrInv(role), this.strategy.getABox().doExplanation());
                if (aTermList.isEmpty()) {
                    this.applyAllValues(individual, role2, node, aTermAppl3, dependencySet2);
                } else if (node.isIndividual()) {
                    aTermAppl = ATermUtils.makeAllValues((ATerm)aTermList, (ATerm)aTermAppl3);
                    this.strategy.addType(node, aTermAppl, dependencySet2);
                }
                if (this.strategy.getABox().isClosed()) {
                    return;
                }
            }
            if (!role2.isSimple()) {
                dependencySet2 = individual.getDepends((ATerm)aTermAppl2).union(dependencySet, this.strategy.getABox().doExplanation());
                aTermAppl = role2.getSubRoleChains();
                for (ATermList aTermList2 : aTermAppl) {
                    Role role3 = this.strategy.getABox().getRole(aTermList2.getFirst());
                    if (!role.isSubRoleOf(role3)) continue;
                    ATermAppl aTermAppl4 = ATermUtils.makeAllValues((ATerm)aTermList2.getNext(), (ATerm)aTermAppl3);
                    this.applyAllValues(individual, role, node, aTermAppl4, dependencySet2.union(role3.getExplainSub((ATerm)role.getName()), this.strategy.getABox().doExplanation()).union(role2.getExplainSub((ATerm)aTermList2), this.strategy.getABox().doExplanation()));
                    if (!individual.isMerged() && !this.strategy.getABox().isClosed()) continue;
                    return;
                }
            }
            if (individual.isMerged()) {
                return;
            }
            node = node.getSame();
            if (n == list.size()) continue;
            iterator = list.iterator();
            n = list.size();
        }
    }

    void applyAllValuesTop(ATermAppl aTermAppl, ATermAppl aTermAppl2, DependencySet dependencySet) {
        for (Node node : this.strategy.getABox().getNodes()) {
            if (!node.isIndividual() || node.isPruned() || node.hasType((ATerm)aTermAppl2)) continue;
            node.addType(aTermAppl2, dependencySet);
            node.addType(aTermAppl, dependencySet);
            if (!this.strategy.getABox().isClosed()) continue;
            break;
        }
    }
}

