/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import com.clarkparsia.pellet.expressivity.Expressivity;
import java.util.Iterator;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.rule.TableauRule;

public class SROIQStrategy
extends CompletionStrategy {
    public SROIQStrategy(ABox aBox) {
        super(aBox);
    }

    protected boolean backtrack() {
        boolean bl = false;
        ++this.abox.stats.backtracks;
        while (!bl) {
            Object object;
            Object object2;
            this.completionTimer.check();
            int n = this.abox.getClash().getDepends().max();
            if (n <= 0) {
                return false;
            }
            if (n > this.abox.getBranches().size()) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + n + " but has only " + this.abox.getBranches().size() + " branches. Clash found: " + this.abox.getClash());
            }
            if (PelletOptions.USE_INCREMENTAL_DELETION && ((Branch)(object2 = this.abox.getBranches().get(n - 1))).getTryNext() == ((Branch)object2).getTryCount() - 1 && this.abox.getClash().getDepends().size() == 2) {
                this.abox.getKB().getDependencyIndex().addCloseBranchDependency((Branch)object2, this.abox.getClash().getDepends());
                return false;
            }
            object2 = this.abox.getBranches();
            this.abox.stats.backjumps += object2.size() - n;
            if (PelletOptions.USE_TRACING && PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
                object = object2.subList(n, object2.size());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    this.abox.getKB().getDependencyIndex().removeBranchDependencies((Branch)iterator.next());
                }
                object.clear();
            } else {
                object2.subList(n, object2.size()).clear();
            }
            object = (Branch)object2.get(n - 1);
            if (log.isLoggable(Level.FINE)) {
                log.fine("JUMP: Branch " + n);
            }
            if (n != ((Branch)object).getBranch()) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + n + " but got " + ((Branch)object).getBranch());
            }
            if (((Branch)object).getTryNext() < ((Branch)object).getTryCount()) {
                ((Branch)object).setLastClash(this.abox.getClash().getDepends());
            }
            ((Branch)object).setTryNext(((Branch)object).getTryNext() + 1);
            if (((Branch)object).getTryNext() < ((Branch)object).getTryCount()) {
                this.restore((Branch)object);
            }
            if ((bl = ((Branch)object).tryNext()) || !log.isLoggable(Level.FINE)) continue;
            log.fine("FAIL: Branch " + n);
        }
        return bl;
    }

    @Override
    public void complete(Expressivity expressivity) {
        this.initialize(expressivity);
        while (!this.abox.isComplete()) {
            Object object;
            while (this.abox.isChanged() && !this.abox.isClosed()) {
                this.completionTimer.check();
                this.abox.setChanged(false);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.stats.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb");
                    this.abox.validate();
                    this.printBlocked();
                    this.abox.printTree();
                }
                Object object2 = object = PelletOptions.USE_COMPLETION_QUEUE ? this.abox.getCompletionQueue() : this.abox.getIndIterator();
                if (PelletOptions.USE_COMPLETION_QUEUE) {
                    this.abox.getCompletionQueue().flushQueue();
                }
                for (TableauRule tableauRule : this.tableauRules) {
                    tableauRule.apply((IndividualIterator)object);
                    if (!this.abox.isClosed()) continue;
                    break;
                }
                if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                this.abox.getCompletionQueue().setClosed(this.abox.isClosed());
            }
            if (this.abox.isClosed()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                    this.abox.getCompletionQueue().setClosed(false);
                    continue;
                }
                this.abox.setComplete(true);
                if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                this.abox.getCompletionQueue().flushQueue();
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                object = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    object = this.abox.getBranches().get(i);
                    ((Branch)object).setTryNext(((Branch)object).getTryNext() + 1);
                    if (((Branch)object).getTryNext() < ((Branch)object).getTryCount()) {
                        this.restore((Branch)object);
                        System.out.println("restoring branch " + ((Branch)object).getBranch() + " tryNext = " + ((Branch)object).getTryNext() + " tryCount = " + ((Branch)object).getTryCount());
                        ((Branch)object).tryNext();
                        break;
                    }
                    System.out.println("removing branch " + ((Branch)object).getBranch());
                    this.abox.getBranches().remove(i);
                    object = null;
                }
                if (object != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
    }
}

