/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena.graph.loader;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomImpl;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.vocabulary.BuiltinNamespace;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.PropertyType;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.BuiltinTerm;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.graph.loader.GraphLoader;
import org.mindswap.pellet.jena.graph.loader.SimpleProperty;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.jena.vocabulary.SWRL;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.AnnotationClasses;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;

public class DefaultGraphLoader
implements GraphLoader {
    public static final Logger log = Logger.getLogger(DefaultGraphLoader.class.getName());
    protected static final Node[] TBOX_TYPES;
    protected static final Node[] TBOX_PREDICATES;
    private static final EnumSet<BuiltinTerm> OWL_MEMBERS_TYPES;
    private static final Graph EMPTY_GRAPH;
    public static QNameProvider qnames;
    protected KnowledgeBase kb;
    protected Graph graph;
    protected Map<Node, ATermAppl> terms;
    protected Map<Node, ATermList> lists;
    protected Set<Node> anonDatatypes;
    protected Map<Node, BuiltinTerm> naryDisjoints;
    private Map<ATermAppl, SimpleProperty> simpleProperties;
    private Set<String> unsupportedFeatures;
    private boolean loadABox = true;
    private boolean preprocessTypeTriples = true;
    protected ProgressMonitor monitor = new SilentProgressMonitor();

    public DefaultGraphLoader() {
        this.clear();
    }

    @Override
    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor == null ? new SilentProgressMonitor() : progressMonitor;
    }

    @Override
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public Set<String> getUnpportedFeatures() {
        return this.unsupportedFeatures;
    }

    protected void addSimpleProperty(ATermAppl aTermAppl, SimpleProperty simpleProperty) {
        this.simpleProperties.put(aTermAppl, simpleProperty);
        Role role = this.kb.getRBox().getRole((ATerm)aTermAppl);
        role.setForceSimple(true);
    }

    protected void addUnsupportedFeature(String string) {
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException(string);
        }
        if (this.unsupportedFeatures.add(string)) {
            log.warning("Unsupported axiom: " + string);
        }
    }

    @Override
    public void clear() {
        this.terms = new HashMap<Node, ATermAppl>();
        this.terms.put(OWL.Thing.asNode(), ATermUtils.TOP);
        this.terms.put(OWL.Nothing.asNode(), ATermUtils.BOTTOM);
        this.terms.put(OWL2.topDataProperty.asNode(), ATermUtils.TOP_DATA_PROPERTY);
        this.terms.put(OWL2.bottomDataProperty.asNode(), ATermUtils.BOTTOM_DATA_PROPERTY);
        this.terms.put(OWL2.topObjectProperty.asNode(), ATermUtils.TOP_OBJECT_PROPERTY);
        this.terms.put(OWL2.bottomObjectProperty.asNode(), ATermUtils.BOTTOM_OBJECT_PROPERTY);
        this.lists = new HashMap<Node, ATermList>();
        this.lists.put(RDF.nil.asNode(), ATermUtils.EMPTY_LIST);
        this.anonDatatypes = new HashSet<Node>();
        this.simpleProperties = new HashMap<ATermAppl, SimpleProperty>();
        this.unsupportedFeatures = new HashSet<String>();
        this.naryDisjoints = new HashMap<Node, BuiltinTerm>();
    }

    private Node getObject(Node node, Node node2) {
        ExtendedIterator extendedIterator = this.graph.find(node, node2, null);
        if (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            extendedIterator.close();
            return triple.getObject();
        }
        return null;
    }

    private boolean hasObject(Node node, Node node2, Node node3) {
        return this.graph.contains(node, node2, node3);
    }

    protected Node getFirst(Node node) {
        return this.getObject(node, RDF.first.asNode());
    }

    protected Node getRest(Node node) {
        return this.getObject(node, RDF.rest.asNode());
    }

    protected ATermList createList(Node node) {
        if (this.lists.containsKey(node)) {
            return this.lists.get(node);
        }
        ATermList aTermList = this.createList(new RDFListIterator(node));
        this.lists.put(node, aTermList);
        return aTermList;
    }

    protected ATermList createList(RDFListIterator rDFListIterator) {
        if (!rDFListIterator.hasNext()) {
            return ATermUtils.EMPTY_LIST;
        }
        Node node = rDFListIterator.next();
        if (node == null) {
            return ATermUtils.EMPTY_LIST;
        }
        ATermAppl aTermAppl = this.node2term(node);
        ATermList aTermList = this.createList(rDFListIterator);
        ATermList aTermList2 = ATermUtils.makeList((ATerm)aTermAppl, aTermList);
        return aTermList2;
    }

    protected boolean isRestriction(Node node) {
        return this.getObject(node, OWL.onProperty.asNode()) != null;
    }

    protected ATermAppl createRestriction(Node node) throws UnsupportedFeatureException {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        Node node5 = null;
        Bool bool = Bool.UNKNOWN;
        ExtendedIterator extendedIterator = this.graph.find(node, null, null);
        while (extendedIterator.hasNext()) {
            this.monitor.incrementProgress();
            Triple triple = (Triple)extendedIterator.next();
            Node node6 = triple.getPredicate();
            BuiltinTerm builtinTerm = BuiltinTerm.find(node6);
            if (builtinTerm == null) continue;
            switch (builtinTerm) {
                case OWL_someValuesFrom: 
                case OWL_allValuesFrom: 
                case OWL_cardinality: 
                case OWL_minCardinality: 
                case OWL_maxCardinality: 
                case OWL_hasValue: 
                case OWL2_hasSelf: 
                case OWL2_qualifiedCardinality: 
                case OWL2_minQualifiedCardinality: 
                case OWL2_maxQualifiedCardinality: {
                    node2 = node6;
                    node4 = triple.getObject();
                    break;
                }
                case OWL_onProperty: {
                    node3 = triple.getObject();
                    break;
                }
                case RDF_type: {
                    if (!triple.getObject().equals((Object)OWL2.SelfRestriction.asNode())) break;
                    node2 = OWL2.hasSelf.asNode();
                    node4 = JenaUtils.XSD_BOOLEAN_TRUE.asNode();
                    break;
                }
                case OWL2_onClass: {
                    bool = Bool.TRUE;
                    node5 = triple.getObject();
                    break;
                }
                case OWL2_onDataRange: {
                    bool = Bool.FALSE;
                    node5 = triple.getObject();
                    break;
                }
            }
        }
        extendedIterator.close();
        return this.createRestriction(node2, node3, node4, node5, bool);
    }

    protected ATermAppl createRestriction(Node node, Node node2, Node node3, Node node4, Bool bool) throws UnsupportedFeatureException {
        ATermAppl aTermAppl = ATermUtils.TOP;
        if (node == null || node3 == null) {
            this.addUnsupportedFeature("Skipping invalid restriction");
            return aTermAppl;
        }
        ATermAppl aTermAppl2 = this.node2term(node2);
        if (node.equals((Object)OWL2.hasSelf.asNode())) {
            Object object = null;
            try {
                object = this.kb.getDatatypeReasoner().getValue(this.node2term(node3));
            }
            catch (Exception exception) {
                log.log(Level.FINE, "Invalid hasSelf value: " + node3, exception);
            }
            if (Boolean.TRUE.equals(object)) {
                aTermAppl = ATermUtils.makeSelf(aTermAppl2);
                this.defineObjectProperty(aTermAppl2);
                this.addSimpleProperty(aTermAppl2, SimpleProperty.SELF);
            } else {
                this.addUnsupportedFeature("Invalid value for " + OWL2.hasSelf.getLocalName() + " restriction. Expecting \"true\"^^xsd:boolean but found: " + node3);
            }
        } else if (node.equals((Object)OWL.hasValue.asNode())) {
            ATermAppl aTermAppl3 = this.node2term(node3);
            if (node3.isLiteral()) {
                this.defineDatatypeProperty(aTermAppl2);
            } else {
                this.defineObjectProperty(aTermAppl2);
                this.defineIndividual(aTermAppl3);
            }
            aTermAppl = ATermUtils.makeHasValue((ATerm)aTermAppl2, (ATerm)aTermAppl3);
        } else if (node.equals((Object)OWL.allValuesFrom.asNode())) {
            ATermAppl aTermAppl4 = this.node2term(node3);
            if (this.kb.isClass((ATerm)aTermAppl4)) {
                this.defineObjectProperty(aTermAppl2);
            } else if (this.kb.isDatatype(aTermAppl4)) {
                this.defineDatatypeProperty(aTermAppl2);
            }
            aTermAppl = ATermUtils.makeAllValues((ATerm)aTermAppl2, (ATerm)aTermAppl4);
        } else if (node.equals((Object)OWL.someValuesFrom.asNode())) {
            ATermAppl aTermAppl5 = this.node2term(node3);
            if (this.kb.isClass((ATerm)aTermAppl5)) {
                this.defineObjectProperty(aTermAppl2);
            } else if (this.kb.isDatatype(aTermAppl5)) {
                this.defineDatatypeProperty(aTermAppl2);
            }
            aTermAppl = ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)aTermAppl5);
        } else if (node.equals((Object)OWL.minCardinality.asNode()) || node.equals((Object)OWL.maxCardinality.asNode()) || node.equals((Object)OWL.cardinality.asNode()) || node.equals((Object)OWL2.minQualifiedCardinality.asNode()) || node.equals((Object)OWL2.maxQualifiedCardinality.asNode()) || node.equals((Object)OWL2.qualifiedCardinality.asNode())) {
            try {
                ATermAppl aTermAppl6 = null;
                if (bool.isTrue()) {
                    aTermAppl6 = this.node2term(node4);
                    this.defineObjectProperty(aTermAppl2);
                } else if (bool.isFalse()) {
                    aTermAppl6 = this.node2term(node4);
                    this.defineDatatypeProperty(aTermAppl2);
                } else {
                    PropertyType propertyType = this.kb.getPropertyType((ATerm)aTermAppl2);
                    if (propertyType == PropertyType.OBJECT) {
                        aTermAppl6 = ATermUtils.TOP;
                    } else if (propertyType == PropertyType.DATATYPE) {
                        aTermAppl6 = ATermUtils.TOP_LIT;
                    } else {
                        this.defineObjectProperty(aTermAppl2);
                        aTermAppl6 = ATermUtils.TOP;
                    }
                }
                int n = Integer.parseInt(node3.getLiteral().getLexicalForm().trim());
                aTermAppl = node.equals((Object)OWL.minCardinality.asNode()) || node.equals((Object)OWL2.minQualifiedCardinality.asNode()) ? ATermUtils.makeMin((ATerm)aTermAppl2, n, (ATerm)aTermAppl6) : (node.equals((Object)OWL.maxCardinality.asNode()) || node.equals((Object)OWL2.maxQualifiedCardinality.asNode()) ? ATermUtils.makeMax((ATerm)aTermAppl2, n, (ATerm)aTermAppl6) : ATermUtils.makeCard((ATerm)aTermAppl2, n, (ATerm)aTermAppl6));
                this.addSimpleProperty(aTermAppl2, SimpleProperty.CARDINALITY);
            }
            catch (Exception exception) {
                this.addUnsupportedFeature("Invalid value for the owl:" + node.getLocalName() + " restriction: " + node3);
                log.log(Level.WARNING, "Invalid cardinality", exception);
            }
        } else {
            this.addUnsupportedFeature("Ignoring invalid restriction on " + node2);
        }
        return aTermAppl;
    }

    @Override
    public ATermAppl node2term(Node node) {
        ATermAppl aTermAppl = this.terms.get(node);
        if (aTermAppl == null) {
            boolean bl = true;
            if (this.isRestriction(node)) {
                aTermAppl = this.createRestriction(node);
            } else if (node.isBlank()) {
                Triple triple = this.getExpression(node);
                if (triple != null) {
                    Node node2 = triple.getPredicate();
                    Node node3 = triple.getObject();
                    if (node2.equals((Object)OWL.intersectionOf.asNode())) {
                        ATermList aTermList = this.createList(node3);
                        aTermAppl = ATermUtils.makeAnd(aTermList);
                    } else if (node2.equals((Object)OWL.unionOf.asNode())) {
                        ATermList aTermList = this.createList(node3);
                        aTermAppl = ATermUtils.makeOr(aTermList);
                    } else if (node2.equals((Object)OWL.complementOf.asNode()) || node2.equals((Object)OWL2.datatypeComplementOf.asNode())) {
                        ATermAppl aTermAppl2 = this.node2term(node3);
                        aTermAppl = ATermUtils.makeNot((ATerm)aTermAppl2);
                    } else if (node2.equals((Object)OWL.inverseOf.asNode())) {
                        ATermAppl aTermAppl3 = this.node2term(node3);
                        aTermAppl = ATermUtils.makeInv(aTermAppl3);
                    } else if (node2.equals((Object)OWL.oneOf.asNode())) {
                        ATermList aTermList = this.createList(node3);
                        ATermList aTermList2 = ATermUtils.EMPTY_LIST;
                        if (aTermList.isEmpty()) {
                            aTermAppl = ATermUtils.BOTTOM;
                        } else {
                            ATermList aTermList3 = aTermList;
                            while (!aTermList3.isEmpty()) {
                                ATermAppl aTermAppl4 = (ATermAppl)aTermList3.getFirst();
                                ATermAppl aTermAppl5 = ATermUtils.makeValue((ATerm)aTermAppl4);
                                aTermList2 = aTermList2.insert((ATerm)aTermAppl5);
                                aTermList3 = aTermList3.getNext();
                            }
                            aTermAppl = ATermUtils.makeOr(aTermList2);
                        }
                    } else if (node2.equals((Object)OWL2.onDatatype.asNode())) {
                        aTermAppl = this.parseDataRange(node, node3);
                    } else if (node2.equals((Object)OWL2.onDataRange.asNode())) {
                        aTermAppl = this.parseDataRangeLegacy(node, node3);
                    } else if (!node2.equals((Object)OWL2.propertyChain.asNode())) {
                        this.addUnsupportedFeature("Unexpected bnode " + node + " " + triple);
                    }
                } else {
                    bl = false;
                    aTermAppl = JenaUtils.makeATerm(node);
                }
            } else {
                aTermAppl = JenaUtils.makeATerm(node);
            }
            if (bl) {
                this.terms.put(node, aTermAppl);
            }
        }
        return aTermAppl;
    }

    protected Triple getExpression(Node node) {
        for (BuiltinTerm builtinTerm : BuiltinTerm.EXPRESSION_PREDICATES) {
            ExtendedIterator extendedIterator = this.graph.find(node, builtinTerm.getNode(), null);
            if (!extendedIterator.hasNext()) continue;
            this.monitor.incrementProgress();
            Triple triple = (Triple)extendedIterator.next();
            extendedIterator.close();
            return triple;
        }
        return null;
    }

    private ATermAppl parseDataRangeLegacy(Node node, Node node2) {
        if (!node2.isURI()) {
            this.addUnsupportedFeature("Invalid datatype definition, expected URI but found " + node);
            return ATermUtils.BOTTOM_LIT;
        }
        ATermAppl aTermAppl = ATermUtils.makeTermAppl(node2.getURI());
        Property[] propertyArray = new Property[]{OWL2.minInclusive, OWL2.maxInclusive, OWL2.minExclusive, OWL2.maxExclusive, OWL2.totalDigits, OWL2.fractionDigits, OWL2.pattern};
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (Property property : propertyArray) {
            Node node3 = this.getObject(node, property.asNode());
            if (node3 == null) continue;
            ATermAppl aTermAppl2 = ATermUtils.makeFacetRestriction(ATermUtils.makeTermAppl(property.getURI()), JenaUtils.makeATerm(node3));
            arrayList.add(aTermAppl2);
        }
        if (arrayList.isEmpty()) {
            this.addUnsupportedFeature("A data range is defined without XSD facet restrictions " + node);
            return ATermUtils.BOTTOM_LIT;
        }
        return ATermUtils.makeRestrictedDatatype(aTermAppl, arrayList.toArray(new ATermAppl[arrayList.size()]));
    }

    private ATermAppl parseDataRange(Node node, Node node2) {
        if (!node2.isURI()) {
            this.addUnsupportedFeature("Invalid datatype definition, expected URI but found " + node);
            return ATermUtils.BOTTOM_LIT;
        }
        ATermAppl aTermAppl = ATermUtils.makeTermAppl(node2.getURI());
        Property[] propertyArray = new Property[]{OWL2.minInclusive, OWL2.maxInclusive, OWL2.minExclusive, OWL2.maxExclusive, OWL2.totalDigits, OWL2.fractionDigits, OWL2.pattern};
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        Node node3 = this.getObject(node, OWL2.withRestrictions.asNode());
        RDFListIterator rDFListIterator = new RDFListIterator(node3);
        while (rDFListIterator.hasNext()) {
            Node node4 = rDFListIterator.next();
            if (node4 == null) continue;
            for (Property property : propertyArray) {
                Node node5 = this.getObject(node4, property.asNode());
                if (node5 == null) continue;
                ATermAppl aTermAppl2 = ATermUtils.makeFacetRestriction(ATermUtils.makeTermAppl(property.getURI()), JenaUtils.makeATerm(node5));
                arrayList.add(aTermAppl2);
            }
        }
        if (arrayList.isEmpty()) {
            this.addUnsupportedFeature("A data range is defined without XSD facet restrictions " + node);
            return ATermUtils.BOTTOM_LIT;
        }
        return ATermUtils.makeRestrictedDatatype(aTermAppl, arrayList.toArray(new ATermAppl[arrayList.size()]));
    }

    private void defineRule(Node node) {
        List<RuleAtom> list = this.parseAtomList(this.getObject(node, SWRL.head.asNode()));
        List<RuleAtom> list2 = this.parseAtomList(this.getObject(node, SWRL.body.asNode()));
        if (list == null || list2 == null) {
            String string = "head and body";
            if (list != null) {
                string = "body";
            } else if (list2 != null) {
                string = "head";
            }
            this.addUnsupportedFeature("Ignoring SWRL rule (unsupported " + string + "): " + node);
            return;
        }
        ATermAppl aTermAppl = JenaUtils.makeATerm(node);
        Rule rule = new Rule(aTermAppl, list, list2);
        this.kb.addRule(rule);
    }

    private AtomDObject createRuleDObject(Node node) {
        if (!node.isLiteral()) {
            ATermAppl aTermAppl = this.node2term(node);
            if (!ATermUtils.isPrimitive(aTermAppl)) {
                this.addUnsupportedFeature("Cannot create rule data variable out of " + node);
                return null;
            }
            return new AtomDVariable(aTermAppl.toString());
        }
        return new AtomDConstant(this.node2term(node));
    }

    private AtomIObject createRuleIObject(Node node) {
        if (this.hasObject(node, RDF.type.asNode(), SWRL.Variable.asNode())) {
            return new AtomIVariable(node.getURI());
        }
        ATermAppl aTermAppl = this.node2term(node);
        if (this.defineIndividual(aTermAppl)) {
            return new AtomIConstant(this.node2term(node));
        }
        this.addUnsupportedFeature("Cannot create rule individual object for node " + node);
        return null;
    }

    private List<RuleAtom> parseAtomList(Node node) {
        Node node2 = null;
        ArrayList<RuleAtom> arrayList = new ArrayList<RuleAtom>();
        while (node != null && !node.equals((Object)RDF.nil.asNode())) {
            AtomObject atomObject;
            Object object;
            Object object2;
            String string = "unsupported atom";
            Node node3 = this.getObject(node, RDF.first.asNode());
            RuleAtomImpl ruleAtomImpl = null;
            if (this.hasObject(node3, RDF.type.asNode(), SWRL.ClassAtom.asNode())) {
                object2 = null;
                object = null;
                string = "ClassAtom";
                node2 = this.getObject(node3, SWRL.classPredicate.asNode());
                if (node2 != null) {
                    object2 = this.node2term(node2);
                }
                if ((node2 = this.getObject(node3, SWRL.argument1.asNode())) != null) {
                    object = this.createRuleIObject(node2);
                }
                if (object2 == null) {
                    this.addUnsupportedFeature("Error on " + SWRL.classPredicate);
                } else if (object == null) {
                    this.addUnsupportedFeature("Error on" + SWRL.argument1);
                } else {
                    ruleAtomImpl = new ClassAtom((ATermAppl)object2, (AtomIObject)object);
                }
            } else if (this.hasObject(node3, RDF.type.asNode(), SWRL.IndividualPropertyAtom.asNode())) {
                object2 = null;
                object = null;
                atomObject = null;
                string = "IndividualPropertyAtom";
                node2 = this.getObject(node3, SWRL.propertyPredicate.asNode());
                if (node2 != null) {
                    object2 = this.node2term(node2);
                }
                if ((node2 = this.getObject(node3, SWRL.argument1.asNode())) != null) {
                    object = this.createRuleIObject(node2);
                }
                if ((node2 = this.getObject(node3, SWRL.argument2.asNode())) != null) {
                    atomObject = this.createRuleIObject(node2);
                }
                if (object2 == null || !this.defineObjectProperty((ATermAppl)object2)) {
                    this.addUnsupportedFeature("Cannot define datatype property " + object2);
                } else if (object == null) {
                    this.addUnsupportedFeature("Term not found: " + SWRL.argument1);
                } else if (atomObject == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument2);
                } else {
                    ruleAtomImpl = new IndividualPropertyAtom((ATermAppl)object2, (AtomIObject)object, (AtomIObject)atomObject);
                }
            } else if (this.hasObject(node3, RDF.type.asNode(), SWRL.DifferentIndividualsAtom.asNode())) {
                object2 = null;
                object = null;
                string = "DifferentIndividualsAtom";
                node2 = this.getObject(node3, SWRL.argument1.asNode());
                if (node2 != null) {
                    object2 = this.createRuleIObject(node2);
                }
                if ((node2 = this.getObject(node3, SWRL.argument2.asNode())) != null) {
                    object = this.createRuleIObject(node2);
                }
                if (object2 == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument1);
                } else if (object == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument2);
                } else {
                    ruleAtomImpl = new DifferentIndividualsAtom((AtomIObject)object2, (AtomIObject)object);
                }
            } else if (this.hasObject(node3, RDF.type.asNode(), SWRL.SameIndividualAtom.asNode())) {
                object2 = null;
                object = null;
                string = "SameIndividualAtom";
                node2 = this.getObject(node3, SWRL.argument1.asNode());
                if (node2 != null) {
                    object2 = this.createRuleIObject(node2);
                }
                if ((node2 = this.getObject(node3, SWRL.argument2.asNode())) != null) {
                    object = this.createRuleIObject(node2);
                }
                if (object2 == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument1);
                } else if (object == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument2);
                } else {
                    ruleAtomImpl = new SameIndividualAtom((AtomIObject)object2, (AtomIObject)object);
                }
            } else if (this.hasObject(node3, RDF.type.asNode(), SWRL.DatavaluedPropertyAtom.asNode())) {
                object2 = null;
                object = null;
                atomObject = null;
                string = "DatavaluedPropertyAtom";
                node2 = this.getObject(node3, SWRL.propertyPredicate.asNode());
                if (node2 != null) {
                    object2 = this.node2term(node2);
                }
                if ((node2 = this.getObject(node3, SWRL.argument1.asNode())) != null) {
                    object = this.createRuleIObject(node2);
                }
                if ((node2 = this.getObject(node3, SWRL.argument2.asNode())) != null) {
                    atomObject = this.createRuleDObject(node2);
                }
                if (object2 == null || !this.defineDatatypeProperty((ATermAppl)object2)) {
                    this.addUnsupportedFeature("Cannot define datatype property " + object2);
                } else if (object == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument1);
                } else if (atomObject == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument2);
                } else {
                    ruleAtomImpl = new DatavaluedPropertyAtom((ATermAppl)object2, (AtomIObject)object, (AtomDObject)atomObject);
                }
            } else if (this.hasObject(node3, RDF.type.asNode(), SWRL.BuiltinAtom.asNode())) {
                string = "BuiltinAtom";
                object2 = null;
                object = null;
                node2 = this.getObject(node3, SWRL.arguments.asNode());
                if (node2 != null) {
                    object = this.parseArgumentList(node2);
                }
                object2 = this.getObject(node3, SWRL.builtin.asNode());
                if (object == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.arguments);
                } else if (object2 != null && object2.isURI()) {
                    ruleAtomImpl = new BuiltInAtom(object2.getURI(), (List<AtomDObject>)object);
                }
            } else if (this.hasObject(node3, RDF.type.asNode(), SWRL.DataRangeAtom.asNode())) {
                string = "DataRangeAtom";
                object2 = null;
                object = null;
                node2 = this.getObject(node3, SWRL.dataRange.asNode());
                if (node2 != null) {
                    object2 = this.node2term(node2);
                }
                if ((node2 = this.getObject(node3, SWRL.argument1.asNode())) != null) {
                    object = this.createRuleDObject(node2);
                }
                if (object2 == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.dataRange);
                } else if (object == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument1);
                } else {
                    ruleAtomImpl = new DataRangeAtom((ATermAppl)object2, (AtomDObject)object);
                }
            }
            if (ruleAtomImpl == null) {
                this.addUnsupportedFeature("Ignoring SWRL " + string + ": " + node3);
                return null;
            }
            arrayList.add(ruleAtomImpl);
            node = this.getObject(node, RDF.rest.asNode());
        }
        if (node == null) {
            this.addUnsupportedFeature("Not nil-terminated list in atom list! (Seen " + arrayList + " )");
            return null;
        }
        return arrayList;
    }

    private List<AtomDObject> parseArgumentList(Node node) {
        ArrayList<AtomDObject> arrayList = new ArrayList<AtomDObject>();
        while (node != null && !node.equals((Object)RDF.nil.asNode())) {
            Node node2 = this.getObject(node, RDF.first.asNode());
            if (node2 == null) {
                this.addUnsupportedFeature("Term in list not found " + RDF.first);
                continue;
            }
            arrayList.add(this.createRuleDObject(node2));
            node = this.getObject(node, RDF.rest.asNode());
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addNegatedAssertion(Node node) {
        ATermAppl aTermAppl;
        Node node2 = this.getObject(node, OWL2.sourceIndividual.asNode());
        if (node2 == null) {
            this.addUnsupportedFeature("Negated property value is missing owl:sourceIndividual value");
            return false;
        }
        Node node3 = this.getObject(node, OWL2.assertionProperty.asNode());
        if (node3 == null) {
            this.addUnsupportedFeature("Negated property value is missing owl:assertionProperty value");
            return false;
        }
        Node node4 = this.getObject(node, OWL2.targetIndividual.asNode());
        Node node5 = this.getObject(node, OWL2.targetValue.asNode());
        if (node4 == null && node5 == null) {
            this.addUnsupportedFeature("Negated property value is missing owl:targetIndividual or owl:targetValue value");
            return false;
        }
        if (node4 != null && node5 != null) {
            this.addUnsupportedFeature("Negated property value must not have owl:targetIndividual and owl:targetValue value");
            return false;
        }
        ATermAppl aTermAppl2 = this.node2term(node2);
        ATermAppl aTermAppl3 = this.node2term(node3);
        this.defineIndividual(aTermAppl2);
        if (node4 != null) {
            aTermAppl = this.node2term(node4);
            if (!node4.isURI() && !node4.isBlank()) {
                this.addUnsupportedFeature("Invalid negated property target individual " + node);
                return false;
            }
            this.defineObjectProperty(aTermAppl3);
            this.defineIndividual(aTermAppl);
        } else {
            aTermAppl = this.node2term(node5);
            if (!node5.isLiteral()) {
                this.addUnsupportedFeature("Invalid negated property target value " + node);
                return false;
            }
            this.defineDatatypeProperty(aTermAppl3);
        }
        if (!this.kb.addNegatedPropertyValue(aTermAppl3, aTermAppl2, aTermAppl)) {
            this.addUnsupportedFeature("Skipping invalid negated property value " + node);
            return false;
        }
        return true;
    }

    protected boolean defineClass(ATermAppl aTermAppl) {
        if (ATermUtils.isPrimitive(aTermAppl)) {
            this.kb.addClass(aTermAppl);
            return true;
        }
        return ATermUtils.isComplexClass((ATerm)aTermAppl);
    }

    protected boolean defineDatatype(ATermAppl aTermAppl) {
        if (ATermUtils.isPrimitive(aTermAppl)) {
            this.kb.addDatatype(aTermAppl);
            return true;
        }
        return this.kb.isDatatype(aTermAppl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean defineProperties(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        PropertyType propertyType;
        PropertyType propertyType2 = this.kb.getPropertyType((ATerm)aTermAppl);
        if (propertyType2 != (propertyType = this.kb.getPropertyType((ATerm)aTermAppl2))) {
            if (propertyType2 == PropertyType.UNTYPED) {
                if (propertyType == PropertyType.OBJECT) {
                    this.defineObjectProperty(aTermAppl);
                    return true;
                } else {
                    if (propertyType != PropertyType.DATATYPE) return true;
                    this.defineDatatypeProperty(aTermAppl);
                }
                return true;
            } else {
                if (propertyType != PropertyType.UNTYPED) return false;
                if (propertyType2 == PropertyType.OBJECT) {
                    this.defineObjectProperty(aTermAppl2);
                    return true;
                } else {
                    if (propertyType2 != PropertyType.DATATYPE) return true;
                    this.defineDatatypeProperty(aTermAppl2);
                }
            }
            return true;
        } else {
            if (propertyType2 != PropertyType.UNTYPED) return true;
            this.defineProperty(aTermAppl);
            this.defineProperty(aTermAppl2);
        }
        return true;
    }

    protected boolean defineObjectProperty(ATermAppl aTermAppl) {
        if (!ATermUtils.isPrimitive(aTermAppl) && !ATermUtils.isInv(aTermAppl)) {
            return false;
        }
        return this.kb.addObjectProperty((ATerm)aTermAppl);
    }

    protected boolean defineDatatypeProperty(ATermAppl aTermAppl) {
        if (!ATermUtils.isPrimitive(aTermAppl)) {
            return false;
        }
        return this.kb.addDatatypeProperty((ATerm)aTermAppl);
    }

    private boolean defineAnnotationProperty(ATermAppl aTermAppl) {
        if (!ATermUtils.isPrimitive(aTermAppl)) {
            return false;
        }
        return this.kb.addAnnotationProperty((ATerm)aTermAppl);
    }

    protected boolean defineProperty(ATermAppl aTermAppl) {
        if (ATermUtils.isInv(aTermAppl)) {
            this.kb.addObjectProperty(aTermAppl.getArgument(0));
            return true;
        }
        if (!ATermUtils.isPrimitive(aTermAppl)) {
            return false;
        }
        this.kb.addProperty(aTermAppl);
        return true;
    }

    protected boolean defineIndividual(ATermAppl aTermAppl) {
        this.kb.addIndividual(aTermAppl);
        return true;
    }

    private PropertyType guessPropertyType(ATermAppl aTermAppl, Node node) {
        PropertyType propertyType = this.kb.getPropertyType((ATerm)aTermAppl);
        if (propertyType != PropertyType.UNTYPED) {
            return propertyType;
        }
        this.defineProperty(aTermAppl);
        ExtendedIterator extendedIterator = this.graph.find(node, RDF.type.asNode(), null);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            Node node2 = triple.getObject();
            if (node2.equals((Object)OWL.ObjectProperty.asNode())) {
                return PropertyType.OBJECT;
            }
            if (node2.equals((Object)OWL.DatatypeProperty.asNode())) {
                return PropertyType.DATATYPE;
            }
            if (node2.equals((Object)OWL.AnnotationProperty.asNode())) {
                return PropertyType.ANNOTATION;
            }
            if (!node2.equals((Object)OWL.OntologyProperty.asNode())) continue;
            return PropertyType.ANNOTATION;
        }
        return PropertyType.UNTYPED;
    }

    protected void processTypes() {
        if (this.preprocessTypeTriples) {
            log.fine("processTypes");
            if (this.isLoadABox()) {
                this.processTypes(Node.ANY);
            } else {
                for (Node node : TBOX_TYPES) {
                    this.processTypes(node);
                }
            }
        }
    }

    protected void processTypes(Node node) {
        ExtendedIterator extendedIterator = this.graph.find(null, RDF.type.asNode(), node);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            this.processType(triple);
        }
        extendedIterator.close();
    }

    protected void processType(Triple triple) {
        Node node = triple.getSubject();
        Node node2 = triple.getObject();
        BuiltinTerm builtinTerm = BuiltinTerm.find(node2);
        if (builtinTerm != null) {
            if (builtinTerm.isSyntax()) {
                return;
            }
            if (node.isBlank() && builtinTerm.equals((Object)BuiltinTerm.OWL_Class)) {
                return;
            }
        }
        this.monitor.incrementProgress();
        ATermAppl aTermAppl = this.node2term(node);
        if (builtinTerm == null) {
            BuiltinNamespace builtinNamespace;
            String string;
            if (PelletOptions.FREEZE_BUILTIN_NAMESPACES && node2.isURI() && (string = node2.getNameSpace()) != null && (builtinNamespace = BuiltinNamespace.find(string)) != null) {
                this.addUnsupportedFeature("Ignoring triple with unknown term from " + (Object)((Object)builtinNamespace) + " namespace: " + triple);
                return;
            }
            return;
        }
        switch (builtinTerm) {
            case RDF_Property: {
                this.defineProperty(aTermAppl);
                break;
            }
            case RDFS_Class: {
                this.defineClass(aTermAppl);
                break;
            }
            case RDFS_Datatype: 
            case OWL_DataRange: {
                if (node.isURI()) {
                    this.defineDatatype(aTermAppl);
                    break;
                }
                this.anonDatatypes.add(node);
                break;
            }
            case OWL_Class: {
                this.defineClass(aTermAppl);
                break;
            }
            case OWL_Thing: 
            case OWL2_NamedIndividual: {
                this.defineIndividual(aTermAppl);
                break;
            }
            case OWL_Nothing: {
                this.defineIndividual(aTermAppl);
                this.kb.addType(aTermAppl, ATermUtils.BOTTOM);
                break;
            }
            case OWL_ObjectProperty: {
                if (!node.isURI() || this.defineObjectProperty(aTermAppl)) break;
                this.addUnsupportedFeature("Property " + aTermAppl + " is defined both as an ObjectProperty and a " + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property");
                break;
            }
            case OWL_DatatypeProperty: {
                if (this.defineDatatypeProperty(aTermAppl)) break;
                this.addUnsupportedFeature("Property " + aTermAppl + " is defined both as a DatatypeProperty and a " + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property");
                break;
            }
            case OWL_FunctionalProperty: {
                this.defineProperty(aTermAppl);
                this.kb.addFunctionalProperty(aTermAppl);
                this.addSimpleProperty(aTermAppl, SimpleProperty.CARDINALITY);
                break;
            }
            case OWL_InverseFunctionalProperty: {
                if (this.defineProperty(aTermAppl)) {
                    this.kb.addInverseFunctionalProperty((ATerm)aTermAppl);
                    this.addSimpleProperty(aTermAppl, SimpleProperty.CARDINALITY);
                    break;
                }
                this.addUnsupportedFeature("Ignoring InverseFunctionalProperty axiom for " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property)");
                break;
            }
            case OWL_TransitiveProperty: {
                if (this.defineObjectProperty(aTermAppl)) {
                    this.kb.addTransitiveProperty(aTermAppl);
                    break;
                }
                this.addUnsupportedFeature("Ignoring TransitiveProperty axiom for " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property)");
                break;
            }
            case OWL_SymmetricProperty: {
                if (this.defineObjectProperty(aTermAppl)) {
                    this.kb.addSymmetricProperty(aTermAppl);
                    break;
                }
                this.addUnsupportedFeature("Ignoring SymmetricProperty axiom for " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property)");
                break;
            }
            case OWL_AnnotationProperty: {
                if (this.defineAnnotationProperty(aTermAppl)) break;
                this.addUnsupportedFeature("Property " + aTermAppl + " is defined both as an AnnotationProperty and a " + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property");
                break;
            }
            case OWL2_ReflexiveProperty: {
                if (this.defineObjectProperty(aTermAppl)) {
                    this.kb.addReflexiveProperty(aTermAppl);
                    break;
                }
                this.addUnsupportedFeature("Ignoring ReflexiveProperty axiom for " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property)");
                break;
            }
            case OWL2_IrreflexiveProperty: {
                if (this.defineObjectProperty(aTermAppl)) {
                    this.kb.addIrreflexiveProperty(aTermAppl);
                    this.addSimpleProperty(aTermAppl, SimpleProperty.IRREFLEXIVE);
                    break;
                }
                this.addUnsupportedFeature("Ignoring IrreflexiveProperty axiom for " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property)");
                break;
            }
            case OWL2_AsymmetricProperty: {
                if (this.defineObjectProperty(aTermAppl)) {
                    this.kb.addAsymmetricProperty(aTermAppl);
                    this.addSimpleProperty(aTermAppl, SimpleProperty.ANTI_SYM);
                    break;
                }
                this.addUnsupportedFeature("Ignoring AntisymmetricProperty axiom for " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property)");
                break;
            }
            case OWL2_NegativePropertyAssertion: {
                this.addNegatedAssertion(node);
                break;
            }
            case SWRL_Imp: {
                if (!PelletOptions.DL_SAFE_RULES) break;
                this.defineRule(node);
                break;
            }
            case OWL_AllDifferent: 
            case OWL2_AllDisjointClasses: 
            case OWL2_AllDisjointProperties: {
                this.naryDisjoints.put(node, builtinTerm);
                break;
            }
            default: {
                throw new InternalReasonerException("Unexpected term: " + node2);
            }
        }
    }

    protected void processTriples() {
        log.fine("processTriples");
        if (this.isLoadABox()) {
            this.processTriples(Node.ANY);
        } else {
            for (Node node : TBOX_PREDICATES) {
                this.processTriples(node);
            }
        }
    }

    protected void processTriples(Node node) {
        ExtendedIterator extendedIterator = this.graph.find(null, node, null);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            this.processTriple(triple);
        }
        extendedIterator.close();
    }

    protected void processTriple(Triple triple) {
        Node node = triple.getPredicate();
        Node node2 = triple.getSubject();
        Node node3 = triple.getObject();
        BuiltinTerm builtinTerm = BuiltinTerm.find(node);
        if (builtinTerm != null) {
            if (builtinTerm.isSyntax()) {
                return;
            }
            if (builtinTerm.equals((Object)BuiltinTerm.RDF_type)) {
                if (BuiltinTerm.find(node3) == null) {
                    ATermAppl aTermAppl;
                    if (this.isLoadABox() && !AnnotationClasses.contains(aTermAppl = this.node2term(node3))) {
                        this.defineClass(aTermAppl);
                        ATermAppl aTermAppl2 = this.node2term(node2);
                        this.defineIndividual(aTermAppl2);
                        this.kb.addType(aTermAppl2, aTermAppl);
                    }
                } else if (!this.preprocessTypeTriples) {
                    this.processType(triple);
                }
                return;
            }
        }
        this.monitor.incrementProgress();
        ATermAppl aTermAppl = this.node2term(node2);
        ATermAppl aTermAppl3 = this.node2term(node3);
        if (builtinTerm == null) {
            BuiltinNamespace builtinNamespace;
            String string;
            PropertyType propertyType;
            ATermAppl aTermAppl4 = this.node2term(node);
            Role role = this.kb.getProperty((ATerm)aTermAppl4);
            PropertyType propertyType2 = propertyType = role == null ? PropertyType.UNTYPED : role.getType();
            if (propertyType == PropertyType.ANNOTATION) {
                if (this.graph.contains(node2, RDF.type.asNode(), OWL.Ontology.asNode())) {
                    return;
                }
                if (this.defineAnnotationProperty(aTermAppl4)) {
                    this.kb.addAnnotation(aTermAppl, aTermAppl4, aTermAppl3);
                }
                return;
            }
            if (PelletOptions.FREEZE_BUILTIN_NAMESPACES && (string = node.getNameSpace()) != null && (builtinNamespace = BuiltinNamespace.find(string)) != null) {
                this.addUnsupportedFeature("Ignoring triple with unknown property from " + (Object)((Object)builtinNamespace) + " namespace: " + triple);
                return;
            }
            if (node3.isLiteral()) {
                if (this.defineDatatypeProperty(aTermAppl4)) {
                    string = ((ATermAppl)aTermAppl3.getArgument(2)).getName();
                    if (this.defineIndividual(aTermAppl)) {
                        this.defineDatatypeProperty(aTermAppl4);
                        if (!string.equals("")) {
                            this.defineDatatype(ATermUtils.makeTermAppl(string));
                        }
                        this.kb.addPropertyValue(aTermAppl4, aTermAppl, aTermAppl3);
                    } else if (propertyType == PropertyType.UNTYPED) {
                        this.defineAnnotationProperty(aTermAppl4);
                    } else {
                        this.addUnsupportedFeature("Ignoring ObjectProperty used with a class expression: " + triple);
                    }
                } else {
                    this.addUnsupportedFeature("Ignoring literal value used with ObjectProperty : " + triple);
                }
            } else if (!this.defineObjectProperty(aTermAppl4)) {
                this.addUnsupportedFeature("Ignoring object value used with DatatypeProperty: " + triple);
            } else if (!this.defineIndividual(aTermAppl)) {
                this.addUnsupportedFeature("Ignoring class expression used in subject position: " + triple);
            } else if (!this.defineIndividual(aTermAppl3)) {
                this.addUnsupportedFeature("Ignoring class expression used in object position: " + triple);
            } else {
                this.kb.addPropertyValue(aTermAppl4, aTermAppl, aTermAppl3);
            }
            return;
        }
        switch (builtinTerm) {
            case RDFS_subClassOf: {
                if (!this.defineClass(aTermAppl)) {
                    this.addUnsupportedFeature("Ignoring subClassOf axiom because the subject is not a class " + aTermAppl + " rdfs:subClassOf " + aTermAppl3);
                    break;
                }
                if (!this.defineClass(aTermAppl3)) {
                    this.addUnsupportedFeature("Ignoring subClassOf axiom because the object is not a class " + aTermAppl + " rdfs:subClassOf " + aTermAppl3);
                    break;
                }
                this.kb.addSubClass(aTermAppl, aTermAppl3);
                break;
            }
            case RDFS_subPropertyOf: {
                ATermAppl aTermAppl5 = null;
                if (node2.isBlank()) {
                    Triple triple2 = this.getExpression(node2);
                    if (triple2 == null) {
                        this.addUnsupportedFeature("Bnode in rdfs:subProperty axioms is not a valid property expression");
                    } else if (triple2.getPredicate().equals((Object)OWL2.inverseOf.asNode())) {
                        if (this.defineObjectProperty((ATermAppl)aTermAppl.getArgument(0)) && this.defineObjectProperty(aTermAppl3)) {
                            aTermAppl5 = aTermAppl;
                        }
                    } else if (triple2.getPredicate().equals((Object)OWL2.propertyChain.asNode())) {
                        aTermAppl5 = this.createList(triple2.getObject());
                        ATermList aTermList = (ATermList)aTermAppl5;
                        while (!aTermList.isEmpty() && this.defineObjectProperty((ATermAppl)aTermList.getFirst())) {
                            aTermList = aTermList.getNext();
                        }
                        if (!aTermList.isEmpty() || !this.defineObjectProperty(aTermAppl3)) {
                            aTermAppl5 = null;
                        }
                    } else {
                        this.addUnsupportedFeature("Bnode in rdfs:subProperty axioms is not a valid property expression");
                    }
                } else if (this.defineProperties(aTermAppl, aTermAppl3)) {
                    aTermAppl5 = aTermAppl;
                }
                if (aTermAppl5 != null) {
                    this.kb.addSubProperty((ATerm)aTermAppl5, aTermAppl3);
                    break;
                }
                this.addUnsupportedFeature("Ignoring subproperty axiom between " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property) and " + aTermAppl3 + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl3)) + "Property)");
                break;
            }
            case RDFS_domain: {
                if (this.kb.isAnnotationProperty((ATerm)aTermAppl)) {
                    this.addUnsupportedFeature("Ignoring domain axiom for AnnotationProperty " + aTermAppl);
                    break;
                }
                this.defineProperty(aTermAppl);
                this.defineClass(aTermAppl3);
                this.kb.addDomain((ATerm)aTermAppl, aTermAppl3);
                break;
            }
            case RDFS_range: {
                if (this.kb.isAnnotationProperty((ATerm)aTermAppl)) {
                    this.addUnsupportedFeature("Ignoring range axiom for AnnotationProperty " + aTermAppl);
                    break;
                }
                if (this.kb.isDatatype(aTermAppl3)) {
                    this.defineDatatypeProperty(aTermAppl);
                } else if (this.kb.isClass((ATerm)aTermAppl3)) {
                    this.defineObjectProperty(aTermAppl);
                } else {
                    this.defineProperty(aTermAppl);
                }
                if (this.kb.isDatatypeProperty((ATerm)aTermAppl)) {
                    this.defineDatatype(aTermAppl3);
                } else if (this.kb.isObjectProperty((ATerm)aTermAppl)) {
                    this.defineClass(aTermAppl3);
                }
                this.kb.addRange((ATerm)aTermAppl, aTermAppl3);
                break;
            }
            case OWL_intersectionOf: {
                ATermList aTermList = this.createList(node3);
                this.defineClass(aTermAppl);
                ATermAppl aTermAppl6 = ATermUtils.makeAnd(aTermList);
                this.kb.addEquivalentClass(aTermAppl, aTermAppl6);
                break;
            }
            case OWL_unionOf: {
                ATermList aTermList = this.createList(node3);
                this.defineClass(aTermAppl);
                ATermAppl aTermAppl7 = ATermUtils.makeOr(aTermList);
                this.kb.addEquivalentClass(aTermAppl, aTermAppl7);
                break;
            }
            case OWL2_disjointUnionOf: {
                ATermList aTermList = this.createList(node3);
                this.kb.addDisjointClasses(aTermList);
                this.defineClass(aTermAppl);
                ATermAppl aTermAppl8 = ATermUtils.makeOr(aTermList);
                this.kb.addEquivalentClass(aTermAppl, aTermAppl8);
                break;
            }
            case OWL_complementOf: {
                if (!this.defineClass(aTermAppl)) {
                    this.addUnsupportedFeature("Ignoring complementOf axiom because the subject is not a class " + aTermAppl + " owl:complementOf " + aTermAppl3);
                    break;
                }
                if (!this.defineClass(aTermAppl3)) {
                    this.addUnsupportedFeature("Ignoring complementOf axiom because the object is not a class " + aTermAppl + " owl:complementOf " + aTermAppl3);
                    break;
                }
                this.kb.addComplementClass(aTermAppl, aTermAppl3);
                break;
            }
            case OWL_equivalentClass: {
                if (this.kb.isDatatype(aTermAppl3) || this.anonDatatypes.contains(node3)) {
                    if (!this.defineDatatype(aTermAppl)) {
                        this.addUnsupportedFeature("Ignoring equivalentClass axiom because the subject is not a datatype " + aTermAppl + " owl:equivalentClass " + aTermAppl3);
                        break;
                    }
                    this.kb.addDatatypeDefinition(aTermAppl, aTermAppl3);
                    break;
                }
                if (!this.defineClass(aTermAppl)) {
                    this.addUnsupportedFeature("Ignoring equivalentClass axiom because the subject is not a class " + aTermAppl + " owl:equivalentClass " + aTermAppl3);
                    break;
                }
                if (!this.defineClass(aTermAppl3)) {
                    this.addUnsupportedFeature("Ignoring equivalentClass axiom because the object is not a class " + aTermAppl + " owl:equivalentClass " + aTermAppl3);
                    break;
                }
                this.kb.addEquivalentClass(aTermAppl, aTermAppl3);
                break;
            }
            case OWL_disjointWith: {
                if (!this.defineClass(aTermAppl)) {
                    this.addUnsupportedFeature("Ignoring disjointWith axiom because the subject is not a class " + aTermAppl + " owl:disjointWith " + aTermAppl3);
                    break;
                }
                if (!this.defineClass(aTermAppl3)) {
                    this.addUnsupportedFeature("Ignoring disjointWith axiom because the object is not a class " + aTermAppl + " owl:disjointWith " + aTermAppl3);
                    break;
                }
                this.kb.addDisjointClass(aTermAppl, aTermAppl3);
                break;
            }
            case OWL2_propertyDisjointWith: {
                if (this.defineProperties(aTermAppl, aTermAppl3)) {
                    this.kb.addDisjointProperty(aTermAppl, aTermAppl3);
                    this.addSimpleProperty(aTermAppl, SimpleProperty.DISJOINT);
                    this.addSimpleProperty(aTermAppl3, SimpleProperty.DISJOINT);
                    break;
                }
                this.addUnsupportedFeature("Ignoring disjoint property axiom between " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property) and " + aTermAppl3 + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl3)) + "Property)");
                break;
            }
            case OWL2_propertyChainAxiom: {
                ATermList aTermList;
                ATermAppl aTermAppl9 = null;
                if (node2.isBlank()) {
                    Triple triple3 = this.getExpression(node2);
                    if (triple3 == null) {
                        this.addUnsupportedFeature("Bnode in owl:propertyChainAxiom axiom is not a valid property expression");
                    } else if (triple3.getPredicate().equals((Object)OWL2.inverseOf.asNode())) {
                        if (this.defineObjectProperty((ATermAppl)aTermAppl.getArgument(0))) {
                            aTermAppl9 = aTermAppl;
                        }
                    } else {
                        this.addUnsupportedFeature("Bnode in owl:propertyChainAxiom axiom is not a valid property expression");
                    }
                } else if (this.defineObjectProperty(aTermAppl)) {
                    aTermAppl9 = aTermAppl;
                }
                ATermList aTermList2 = aTermList = this.createList(node3);
                while (!aTermList2.isEmpty() && this.defineObjectProperty((ATermAppl)aTermList2.getFirst())) {
                    aTermList2 = aTermList2.getNext();
                }
                if (!aTermList2.isEmpty()) {
                    aTermList = null;
                }
                if (aTermList != null && aTermAppl9 != null) {
                    this.kb.addSubProperty((ATerm)aTermList, aTermAppl9);
                    break;
                }
                this.addUnsupportedFeature("Ignoring property chain axiom between " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property) and " + aTermAppl3);
                break;
            }
            case OWL_equivalentProperty: {
                if (this.defineProperties(aTermAppl, aTermAppl3)) {
                    this.kb.addEquivalentProperty(aTermAppl, aTermAppl3);
                    break;
                }
                this.addUnsupportedFeature("Ignoring equivalent property axiom between " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property) and " + aTermAppl3 + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl3)) + "Property)");
                break;
            }
            case OWL_inverseOf: {
                if (this.defineObjectProperty(aTermAppl) && this.defineObjectProperty(aTermAppl3)) {
                    this.kb.addInverseProperty(aTermAppl, aTermAppl3);
                    break;
                }
                this.addUnsupportedFeature("Ignoring inverseOf axiom between " + aTermAppl + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl)) + "Property) and " + aTermAppl3 + " (" + (Object)((Object)this.kb.getPropertyType((ATerm)aTermAppl3)) + "Property)");
                break;
            }
            case OWL_sameAs: {
                if (this.defineIndividual(aTermAppl) && this.defineIndividual(aTermAppl3)) {
                    this.kb.addSame(aTermAppl, aTermAppl3);
                    break;
                }
                this.addUnsupportedFeature("Ignoring sameAs axiom between " + aTermAppl + " and " + aTermAppl3);
                break;
            }
            case OWL_differentFrom: {
                if (this.defineIndividual(aTermAppl) && this.defineIndividual(aTermAppl3)) {
                    this.kb.addDifferent(aTermAppl, aTermAppl3);
                    break;
                }
                this.addUnsupportedFeature("Ignoring differentFrom axiom between " + aTermAppl + " and " + aTermAppl3);
                break;
            }
            case OWL_distinctMembers: {
                ATermList aTermList;
                ATermList aTermList3 = aTermList = this.createList(node3);
                while (!aTermList3.isEmpty()) {
                    ATermAppl aTermAppl10 = (ATermAppl)aTermList3.getFirst();
                    this.defineIndividual(aTermAppl10);
                    aTermList3 = aTermList3.getNext();
                }
                this.kb.addAllDifferent(aTermList);
                break;
            }
            case OWL_members: {
                Node node4;
                BuiltinTerm builtinTerm2 = null;
                if (this.preprocessTypeTriples) {
                    builtinTerm2 = this.naryDisjoints.get(node2);
                } else {
                    node4 = this.getObject(node2, RDF.type.asNode());
                    if (node4 != null) {
                        builtinTerm2 = BuiltinTerm.find(node4);
                    }
                }
                if (builtinTerm2 == null) {
                    this.addUnsupportedFeature("There is no valid rdf:type for an owl:members assertion: " + node2);
                    break;
                }
                if (!OWL_MEMBERS_TYPES.contains((Object)builtinTerm2)) {
                    this.addUnsupportedFeature("The rdf:type for an owl:members assertion is not recognized: " + (Object)((Object)builtinTerm2));
                    break;
                }
                ATermList aTermList = this.createList(node3);
                node4 = aTermList;
                while (!node4.isEmpty()) {
                    ATermAppl aTermAppl11 = (ATermAppl)node4.getFirst();
                    switch (builtinTerm2) {
                        case OWL_AllDifferent: {
                            this.defineIndividual(aTermAppl11);
                            break;
                        }
                        case OWL2_AllDisjointClasses: {
                            this.defineClass(aTermAppl11);
                            break;
                        }
                        case OWL2_AllDisjointProperties: {
                            this.defineProperty(aTermAppl11);
                        }
                    }
                    node4 = node4.getNext();
                }
                switch (builtinTerm2) {
                    case OWL_AllDifferent: {
                        this.kb.addAllDifferent(aTermList);
                        break;
                    }
                    case OWL2_AllDisjointClasses: {
                        this.kb.addDisjointClasses(aTermList);
                        break;
                    }
                    case OWL2_AllDisjointProperties: {
                        this.kb.addDisjointProperties(aTermList);
                    }
                }
                break;
            }
            case OWL_oneOf: {
                ATermList aTermList = ATermUtils.EMPTY_LIST;
                if (this.kb.isDatatype(aTermAppl)) {
                    return;
                }
                this.defineClass(aTermAppl);
                ATermAppl aTermAppl12 = null;
                ATermList aTermList4 = this.createList(node3);
                if (node3.equals((Object)RDF.nil.asNode())) {
                    aTermAppl12 = ATermUtils.BOTTOM;
                } else {
                    ATermList aTermList5 = aTermList4;
                    while (!aTermList5.isEmpty()) {
                        ATermAppl aTermAppl13 = (ATermAppl)aTermList5.getFirst();
                        if (PelletOptions.USE_PSEUDO_NOMINALS) {
                            ATermAppl aTermAppl14 = ATermUtils.makeTermAppl(aTermAppl13.getName() + "_nominal");
                            aTermList = aTermList.insert((ATerm)aTermAppl14);
                            this.defineClass(aTermAppl14);
                            this.defineIndividual(aTermAppl13);
                            this.kb.addType(aTermAppl13, aTermAppl14);
                        } else {
                            this.defineIndividual(aTermAppl13);
                            aTermList = aTermList.insert((ATerm)ATermUtils.makeValue((ATerm)aTermAppl13));
                        }
                        aTermList5 = aTermList5.getNext();
                    }
                    aTermAppl12 = ATermUtils.makeOr(aTermList);
                }
                this.kb.addEquivalentClass(aTermAppl, aTermAppl12);
                break;
            }
            case OWL2_hasKey: {
                ATermList aTermList;
                if (node3.equals((Object)RDF.nil.asNode())) {
                    return;
                }
                HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
                this.defineClass(aTermAppl);
                ATermList aTermList6 = aTermList = this.createList(node3);
                while (!aTermList6.isEmpty()) {
                    ATermAppl aTermAppl15 = (ATermAppl)aTermList6.getFirst();
                    this.defineProperty(aTermAppl15);
                    hashSet.add(aTermAppl15);
                    aTermList6 = aTermList6.getNext();
                }
                this.kb.addKey(aTermAppl, hashSet);
                break;
            }
            case OWL2_topDataProperty: 
            case OWL2_bottomDataProperty: 
            case OWL2_topObjectProperty: 
            case OWL2_bottomObjectProperty: {
                this.defineIndividual(aTermAppl);
                this.kb.addPropertyValue(this.node2term(node), aTermAppl, aTermAppl3);
                break;
            }
            default: {
                throw new InternalReasonerException("Unrecognized term: " + node);
            }
        }
    }

    protected void processUntypedResources() {
        log.fine("processUntypedResource");
        for (Role role : this.kb.getRBox().getRoles().toArray(new Role[0])) {
            ATermAppl aTermAppl;
            Iterator iterator;
            SimpleProperty simpleProperty = this.simpleProperties.get(role.getName());
            if (simpleProperty != null) {
                String string = null;
                if (role.isTransitive()) {
                    string = "transitivity axiom";
                } else if (role.hasComplexSubRole()) {
                    string = "complex sub property axiom";
                }
                if (string != null) {
                    string = "Ignoring " + string + " due to an existing " + (Object)((Object)simpleProperty) + " for property " + role;
                    this.addUnsupportedFeature(string);
                    role.removeSubRoleChains();
                }
            }
            if (!role.isUntypedRole()) continue;
            boolean bl = false;
            Set<Role> set = SetUtils.union(role.getSubRoles(), role.getSuperRoles());
            Object object = set.iterator();
            block5: while (object.hasNext()) {
                iterator = object.next();
                switch (((Role)((Object)iterator)).getType()) {
                    case OBJECT: {
                        this.defineObjectProperty(role.getName());
                        continue block5;
                    }
                    case DATATYPE: {
                        this.defineDatatypeProperty(role.getName());
                        bl = true;
                        continue block5;
                    }
                }
            }
            if (!bl) {
                this.defineObjectProperty(role.getName());
            }
            if ((object = role.getRanges()) == null) continue;
            if (bl) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    aTermAppl = (ATermAppl)iterator.next();
                    if (aTermAppl.getAFun().getArity() != 0 || this.kb.isDatatype(aTermAppl)) continue;
                    this.defineDatatype(aTermAppl);
                }
                continue;
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                aTermAppl = (ATermAppl)iterator.next();
                if (aTermAppl.getAFun().getArity() != 0 || this.kb.isClass((ATerm)aTermAppl)) continue;
                this.defineClass(aTermAppl);
            }
        }
    }

    @Override
    public void setKB(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    private void defineBuiltinProperties() {
        this.defineAnnotationProperty(this.node2term(RDFS.label.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.comment.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.seeAlso.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.isDefinedBy.asNode()));
        this.defineAnnotationProperty(this.node2term(OWL.versionInfo.asNode()));
        this.defineAnnotationProperty(this.node2term(OWL.backwardCompatibleWith.asNode()));
        this.defineAnnotationProperty(this.node2term(OWL.priorVersion.asNode()));
        this.defineAnnotationProperty(this.node2term(OWL.incompatibleWith.asNode()));
    }

    @Override
    public void load(Iterable<Graph> iterable) throws UnsupportedFeatureException {
        Graph graph;
        Timer timer = this.kb.timers.startTimer("load");
        this.monitor.setProgressTitle("Loading");
        this.monitor.taskStarted();
        this.graph = EMPTY_GRAPH;
        this.preprocess();
        Iterator<Graph> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            this.graph = graph = iterator.next();
            this.processTypes();
        }
        iterator = iterable.iterator();
        while (iterator.hasNext()) {
            this.graph = graph = iterator.next();
            this.processTriples();
        }
        this.processUntypedResources();
        this.monitor.taskFinished();
        timer.stop();
    }

    @Override
    public void preprocess() {
        this.defineBuiltinProperties();
    }

    @Override
    public boolean isLoadABox() {
        return this.loadABox;
    }

    @Override
    public void setLoadABox(boolean bl) {
        this.loadABox = bl;
    }

    @Override
    public boolean isPreprocessTypeTriples() {
        return this.preprocessTypeTriples;
    }

    @Override
    public void setPreprocessTypeTriples(boolean bl) {
        this.preprocessTypeTriples = bl;
    }

    static {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (BuiltinTerm builtinTerm : BuiltinTerm.values()) {
            if (builtinTerm.isABox() || builtinTerm.isSyntax()) continue;
            if (builtinTerm.isPredicate()) {
                arrayList.add(builtinTerm.getNode());
                continue;
            }
            arrayList2.add(builtinTerm.getNode());
        }
        TBOX_PREDICATES = arrayList.toArray(new Node[arrayList.size()]);
        TBOX_TYPES = arrayList2.toArray(new Node[arrayList2.size()]);
        OWL_MEMBERS_TYPES = EnumSet.of(BuiltinTerm.OWL_AllDifferent, BuiltinTerm.OWL2_AllDisjointClasses, BuiltinTerm.OWL2_AllDisjointProperties);
        EMPTY_GRAPH = Factory.createGraphMem();
        qnames = new QNameProvider();
    }

    private class RDFListIterator
    implements Iterator<Node> {
        private Node list;

        public RDFListIterator(Node node) {
            this.list = node;
        }

        @Override
        public boolean hasNext() {
            return !this.list.equals((Object)RDF.nil.asNode());
        }

        @Override
        public Node next() {
            Node node = DefaultGraphLoader.this.getFirst(this.list);
            DefaultGraphLoader.this.monitor.incrementProgress();
            Node node2 = DefaultGraphLoader.this.getRest(this.list);
            DefaultGraphLoader.this.monitor.incrementProgress();
            if (node == null || node2 == null) {
                DefaultGraphLoader.this.addUnsupportedFeature("Invalid list structure: List " + this.list + " does not have a " + (node == null ? "rdf:first" : "rdf:rest") + " property. Ignoring rest of the list.");
                return null;
            }
            this.list = node2;
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

