/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Collection;
import java.util.HashSet;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.TaxonomyUtils;

public class TaxonomyExtractor {
    private Taxonomy<ATermAppl> taxonomy;
    private Model model;
    private boolean includeIndividuals;

    public TaxonomyExtractor(Taxonomy<ATermAppl> taxonomy) {
        this.taxonomy = taxonomy;
        this.includeIndividuals = false;
    }

    public void setIncludeIndividuals(boolean bl) {
        this.includeIndividuals = bl;
    }

    public Model extractModel() {
        if (this.model == null) {
            this.model = this.createExtractedModel();
        }
        return this.model;
    }

    private Model createExtractedModel() {
        Model model = ModelFactory.createDefaultModel();
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (TaxonomyNode<ATermAppl> taxonomyNode : this.taxonomy.getNodes()) {
            if (hashSet.contains(taxonomyNode.getName())) continue;
            hashSet.addAll(taxonomyNode.getEquivalents());
            for (ATermAppl aTermAppl : taxonomyNode.getEquivalents()) {
                Object object;
                model.add(TaxonomyExtractor.classAssertion(model, aTermAppl));
                Object object2 = taxonomyNode.getSupers().iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    model.add(TaxonomyExtractor.subClassOfAssertion(model, aTermAppl, ((TaxonomyNode)object).getName()));
                }
                if (taxonomyNode.getEquivalents().size() > 1) {
                    object2 = taxonomyNode.getEquivalents().iterator();
                    while (object2.hasNext()) {
                        object = (ATermAppl)object2.next();
                        if (object.equals(aTermAppl)) continue;
                        model.add(TaxonomyExtractor.equivalentClassAssertion(model, aTermAppl, (ATermAppl)object));
                    }
                }
                if (!this.includeIndividuals || (object2 = (Collection)taxonomyNode.getDatum(TaxonomyUtils.INSTANCES_KEY)) == null || object2.isEmpty()) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    ATermAppl aTermAppl2 = (ATermAppl)object.next();
                    model.add(TaxonomyExtractor.typeAssertion(model, aTermAppl2, aTermAppl));
                }
            }
        }
        return model;
    }

    private static Statement typeAssertion(Model model, ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Resource resource = TaxonomyExtractor.createResource(model, aTermAppl);
        Property property = RDF.type;
        Resource resource2 = TaxonomyExtractor.createResource(model, aTermAppl2);
        return model.createStatement(resource, property, (RDFNode)resource2);
    }

    private static Statement classAssertion(Model model, ATermAppl aTermAppl) {
        Resource resource = TaxonomyExtractor.createResource(model, aTermAppl);
        Property property = RDF.type;
        Resource resource2 = OWL2.Class;
        return model.createStatement(resource, property, (RDFNode)resource2);
    }

    private static Statement subClassOfAssertion(Model model, ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Resource resource = TaxonomyExtractor.createResource(model, aTermAppl);
        Property property = RDFS.subClassOf;
        Resource resource2 = TaxonomyExtractor.createResource(model, aTermAppl2);
        return model.createStatement(resource, property, (RDFNode)resource2);
    }

    private static Statement equivalentClassAssertion(Model model, ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Resource resource = TaxonomyExtractor.createResource(model, aTermAppl);
        Property property = OWL2.equivalentClass;
        Resource resource2 = TaxonomyExtractor.createResource(model, aTermAppl2);
        return model.createStatement(resource, property, (RDFNode)resource2);
    }

    private static Resource createResource(Model model, ATermAppl aTermAppl) {
        return JenaUtils.makeResource(aTermAppl, model);
    }
}

